/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.utils.helper;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import pro.gravit.utils.helper.IOHelper;

public class JarHelper {
    public static void zipWalk(ZipInputStream zipInputStream, ZipWalkCallback zipWalkCallback) throws IOException {
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        while (zipEntry != null) {
            zipWalkCallback.process(zipInputStream, zipEntry);
            zipEntry = zipInputStream.getNextEntry();
        }
    }

    public static void jarWalk(ZipInputStream zipInputStream, JarWalkCallback jarWalkCallback) throws IOException {
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        while (zipEntry != null) {
            String string = zipEntry.getName();
            if (string.endsWith(".class")) {
                String string2 = string.replaceAll("/", ".").substring(0, string.length() - ".class".length());
                String string3 = string2.substring(string2.lastIndexOf(46) + 1);
                jarWalkCallback.process(zipInputStream, zipEntry, string2, string3);
            }
            zipEntry = zipInputStream.getNextEntry();
        }
    }

    public static Map<String, String> jarMap(ZipInputStream zipInputStream, boolean bl) throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        JarHelper.jarMap(zipInputStream, hashMap, bl);
        return hashMap;
    }

    public static void jarMap(ZipInputStream zipInputStream2, Map<String, String> map, boolean bl) throws IOException {
        JarHelper.jarWalk(zipInputStream2, (zipInputStream, zipEntry, string, string2) -> {
            if (bl) {
                map.put(string2, string);
            } else {
                map.putIfAbsent(string2, string);
            }
        });
    }

    public static Map<String, String> jarMap(Path path, boolean bl) throws IOException {
        try (ZipInputStream zipInputStream = IOHelper.newZipInput(path);){
            Map<String, String> map = JarHelper.jarMap(zipInputStream, bl);
            return map;
        }
    }

    public static void jarMap(Path path, Map<String, String> map, boolean bl) throws IOException {
        try (ZipInputStream zipInputStream = IOHelper.newZipInput(path);){
            JarHelper.jarMap(zipInputStream, map, bl);
        }
    }

    public static Map<String, String> jarMap(Class<?> clazz, boolean bl) throws IOException {
        Path path = IOHelper.getCodeSource(clazz);
        return JarHelper.jarMap(path, bl);
    }

    public static void jarMap(Class<?> clazz, Map<String, String> map, boolean bl) throws IOException {
        Path path = IOHelper.getCodeSource(clazz);
        JarHelper.jarMap(path, map, bl);
    }

    public static String getClassFile(Class<?> clazz) {
        return JarHelper.getClassFile(clazz.getName());
    }

    public static String getClassFile(String string) {
        return string.replace('.', '/').concat(".class");
    }

    public static byte[] getClassBytes(Class<?> clazz) throws IOException {
        return JarHelper.getClassBytes(clazz, clazz.getClassLoader());
    }

    public static byte[] getClassBytes(Class<?> clazz, ClassLoader classLoader) throws IOException {
        return IOHelper.read(classLoader.getResourceAsStream(JarHelper.getClassFile(clazz)));
    }

    public static InputStream getClassBytesStream(Class<?> clazz) throws IOException {
        return JarHelper.getClassBytesStream(clazz, clazz.getClassLoader());
    }

    public static InputStream getClassBytesStream(Class<?> clazz, ClassLoader classLoader) {
        return classLoader.getResourceAsStream(JarHelper.getClassFile(clazz));
    }

    public static byte[] getClassFromJar(String string, Path path) throws IOException {
        String string2 = JarHelper.getClassFile(string);
        try (ZipInputStream zipInputStream = IOHelper.newZipInput(path);){
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                if (zipEntry.getName().equals(string2)) {
                    byte[] byArray = IOHelper.read(zipInputStream);
                    return byArray;
                }
                zipEntry = zipInputStream.getNextEntry();
            }
        }
        throw new FileNotFoundException(string2);
    }

    @FunctionalInterface
    public static interface ZipWalkCallback {
        public void process(ZipInputStream var1, ZipEntry var2);
    }

    @FunctionalInterface
    public static interface JarWalkCallback {
        public void process(ZipInputStream var1, ZipEntry var2, String var3, String var4);
    }
}

