/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.utils.helper;

import java.io.File;
import java.lang.invoke.MethodHandles;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import pro.gravit.utils.helper.LogHelper;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class JVMHelper {
    public static final RuntimeMXBean RUNTIME_MXBEAN = ManagementFactory.getRuntimeMXBean();
    public static final OperatingSystemMXBean OPERATING_SYSTEM_MXBEAN = ManagementFactory.getOperatingSystemMXBean();
    public static final OS OS_TYPE = OS.byName(OPERATING_SYSTEM_MXBEAN.getName());
    public static final int OS_BITS = JVMHelper.getCorrectOSArch();
    public static final String OS_VERSION = OPERATING_SYSTEM_MXBEAN.getVersion();
    public static final ARCH ARCH_TYPE = JVMHelper.getArch(System.getProperty("os.arch"));
    public static final String NATIVE_EXTENSION = JVMHelper.getNativeExtension(OS_TYPE);
    public static final String NATIVE_PREFIX = JVMHelper.getNativePrefix(OS_TYPE);
    public static final int JVM_BITS = Integer.parseInt(System.getProperty("sun.arch.data.model"));
    public static final Runtime RUNTIME = Runtime.getRuntime();
    public static final ClassLoader LOADER = ClassLoader.getSystemClassLoader();
    public static final int JVM_VERSION = JVMHelper.getVersion();
    public static final int JVM_BUILD = JVMHelper.getBuild();

    private JVMHelper() {
    }

    public static ARCH getArch(String string) {
        if (string.equals("amd64") || string.equals("x86-64") || string.equals("x86_64")) {
            return ARCH.X86_64;
        }
        if (string.equals("i386") || string.equals("i686") || string.equals("x86")) {
            return ARCH.X86;
        }
        if (string.startsWith("armv8") || string.startsWith("aarch64")) {
            return ARCH.ARM64;
        }
        if (string.startsWith("arm") || string.startsWith("aarch32")) {
            return ARCH.ARM32;
        }
        throw new InternalError(String.format("Unsupported arch '%s'", string));
    }

    public static int getVersion() {
        String string = System.getProperty("java.version");
        if (string.startsWith("1.")) {
            string = string.substring(2, 3);
        } else {
            int n = string.indexOf(".");
            if (n != -1) {
                string = string.substring(0, n);
            }
        }
        return Integer.parseInt(string);
    }

    public static int getBuild() {
        String string = System.getProperty("java.version");
        int n = string.startsWith("1.") ? string.indexOf("_") : string.lastIndexOf(".");
        if (n != -1) {
            string = string.substring(n + 1);
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static String getNativeExtension(OS oS) {
        switch (oS.ordinal()) {
            case 0: {
                return ".dll";
            }
            case 1: {
                return ".so";
            }
            case 2: {
                return ".dylib";
            }
        }
        throw new InternalError(String.format("Unsupported OS TYPE '%s'", new Object[]{oS}));
    }

    public static String getNativePrefix(OS oS) {
        switch (oS.ordinal()) {
            case 1: 
            case 2: {
                return "lib";
            }
        }
        return "";
    }

    public static void appendVars(ProcessBuilder processBuilder, Map<String, String> map) {
        processBuilder.environment().putAll(map);
    }

    public static Class<?> firstClass(String ... stringArray) throws ClassNotFoundException {
        for (String string : stringArray) {
            try {
                return Class.forName(string, false, LOADER);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        throw new ClassNotFoundException(Arrays.toString(stringArray));
    }

    public static void fullGC() {
        RUNTIME.gc();
        RUNTIME.runFinalization();
        LogHelper.debug("Used heap: %d MiB", RUNTIME.totalMemory() - RUNTIME.freeMemory() >> 20);
    }

    public static String[] getClassPath() {
        return System.getProperty("java.class.path").split(File.pathSeparator);
    }

    public static URL[] getClassPathURL() {
        String[] stringArray = System.getProperty("java.class.path").split(File.pathSeparator);
        URL[] uRLArray = new URL[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            URL uRL = null;
            try {
                uRL = new URL(stringArray[i]);
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
            uRLArray[i] = uRL;
        }
        return uRLArray;
    }

    public static X509Certificate[] getCertificates(Class<?> clazz) {
        Object[] objectArray = clazz.getSigners();
        if (objectArray == null) {
            return null;
        }
        return (X509Certificate[])Arrays.stream(objectArray).filter(object -> object instanceof X509Certificate).map(object -> (X509Certificate)object).toArray(X509Certificate[]::new);
    }

    public static void checkStackTrace(Class<?> clazz) {
        LogHelper.debug("Testing stacktrace");
        Exception exception = new Exception("Testing stacktrace");
        StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
        if (!stackTraceElementArray[stackTraceElementArray.length - 1].getClassName().equals(clazz.getName())) {
            throw new SecurityException(String.format("Invalid StackTraceElement: %s", stackTraceElementArray[stackTraceElementArray.length - 1].getClassName()));
        }
    }

    private static int getCorrectOSArch() {
        if (OS_TYPE == OS.MUSTDIE) {
            return System.getenv("ProgramFiles(x86)") == null ? 32 : 64;
        }
        return System.getProperty("os.arch").contains("64") ? 64 : 32;
    }

    public static String getEnvPropertyCaseSensitive(String string) {
        return System.getenv().get(string);
    }

    public static boolean isJVMMatchesSystemArch() {
        return JVM_BITS == OS_BITS;
    }

    public static String jvmProperty(String string, String string2) {
        return String.format("-D%s=%s", string, string2);
    }

    public static String systemToJvmProperty(String string) {
        return String.format("-D%s=%s", string, System.getProperties().getProperty(string));
    }

    public static void addSystemPropertyToArgs(Collection<String> collection, String string) {
        String string2 = System.getProperty(string);
        if (string2 != null) {
            collection.add(String.format("-D%s=%s", string, string2));
        }
    }

    public static void verifySystemProperties(Class<?> clazz, boolean bl) {
        Locale.setDefault(Locale.US);
        LogHelper.debug("Verifying class loader");
        if (bl && !clazz.getClassLoader().equals(LOADER)) {
            throw new SecurityException("ClassLoader should be system");
        }
        LogHelper.debug("Verifying JVM architecture");
    }

    static {
        try {
            MethodHandles.publicLookup();
        }
        catch (Throwable throwable) {
            throw new InternalError(throwable);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static enum ARCH {
        X86("x86"),
        X86_64("x86-64"),
        ARM64("arm64"),
        ARM32("arm32");

        public final String name;

        private ARCH(String string2) {
            this.name = string2;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static enum OS {
        MUSTDIE("mustdie"),
        LINUX("linux"),
        MACOSX("macosx");

        public final String name;

        private OS(String string2) {
            this.name = string2;
        }

        public static OS byName(String string) {
            if (string.startsWith("Windows")) {
                return MUSTDIE;
            }
            if (string.startsWith("Linux")) {
                return LINUX;
            }
            if (string.startsWith("Mac OS X")) {
                return MACOSX;
            }
            throw new RuntimeException(String.format("This shit is not yet supported: '%s'", string));
        }
    }
}

