/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.utils.helper;

import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.VerifyHelper;

public final class IOHelper {
    public static final long MB32 = 0x2000000L;
    public static final Charset UNICODE_CHARSET = StandardCharsets.UTF_8;
    public static final Charset ASCII_CHARSET = StandardCharsets.US_ASCII;
    public static final int MAX_BATCH_SIZE = 128;
    public static final int SOCKET_TIMEOUT = VerifyHelper.verifyInt(Integer.parseUnsignedInt(System.getProperty("launcher.socketTimeout", Integer.toString(30000))), VerifyHelper.POSITIVE, "launcher.socketTimeout can't be <= 0");
    public static final int HTTP_TIMEOUT = VerifyHelper.verifyInt(Integer.parseUnsignedInt(System.getProperty("launcher.httpTimeout", Integer.toString(5000))), VerifyHelper.POSITIVE, "launcher.httpTimeout can't be <= 0");
    public static final int BUFFER_SIZE = VerifyHelper.verifyInt(Integer.parseUnsignedInt(System.getProperty("launcher.bufferSize", Integer.toString(4096))), VerifyHelper.POSITIVE, "launcher.bufferSize can't be <= 0");
    public static final String CROSS_SEPARATOR = "/";
    public static final FileSystem FS = FileSystems.getDefault();
    public static final String PLATFORM_SEPARATOR = FS.getSeparator();
    private static final Pattern PLATFORM_SEPARATOR_PATTERN = Pattern.compile(PLATFORM_SEPARATOR, 16);
    public static final boolean POSIX = FS.supportedFileAttributeViews().contains("posix") || FS.supportedFileAttributeViews().contains("Posix");
    public static final Path JVM_DIR = Paths.get(System.getProperty("java.home"), new String[0]);
    public static final Path HOME_DIR = Paths.get(System.getProperty("user.home"), new String[0]);
    public static final Path WORKING_DIR = Paths.get(System.getProperty("user.dir"), new String[0]);
    public static final String USER_AGENT = System.getProperty("launcher.userAgentDefault", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0)");
    private static final OpenOption[] READ_OPTIONS = new OpenOption[]{StandardOpenOption.READ};
    private static final OpenOption[] WRITE_OPTIONS = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING};
    private static final OpenOption[] APPEND_OPTIONS = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.APPEND};
    private static final LinkOption[] LINK_OPTIONS = new LinkOption[0];
    private static final CopyOption[] COPY_OPTIONS = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
    private static final Set<FileVisitOption> WALK_OPTIONS = Collections.singleton(FileVisitOption.FOLLOW_LINKS);
    private static final Pattern CROSS_SEPARATOR_PATTERN = Pattern.compile("/", 16);

    private IOHelper() {
    }

    public static void close(AutoCloseable autoCloseable) {
        try {
            autoCloseable.close();
        }
        catch (Exception exception) {
            LogHelper.error(exception);
        }
    }

    public static void close(InputStream inputStream) {
        try {
            inputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void close(OutputStream outputStream) {
        try {
            outputStream.flush();
            outputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static URL convertToURL(String string) {
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("Invalid URL", malformedURLException);
        }
    }

    public static void copy(Path path, Path path2) throws IOException {
        IOHelper.createParentDirs(path2);
        Files.copy(path, path2, COPY_OPTIONS);
    }

    public static void createParentDirs(Path path) throws IOException {
        Path path2 = path.getParent();
        if (path2 != null && !IOHelper.isDir(path2)) {
            Files.createDirectories(path2, new FileAttribute[0]);
        }
    }

    public static String decode(byte[] byArray) {
        return new String(byArray, UNICODE_CHARSET);
    }

    public static String decodeASCII(byte[] byArray) {
        return new String(byArray, ASCII_CHARSET);
    }

    public static void deleteDir(Path path, boolean bl) throws IOException {
        IOHelper.walk(path, new DeleteDirVisitor(path, bl), true);
    }

    public static byte[] encode(String string) {
        return string.getBytes(UNICODE_CHARSET);
    }

    public static byte[] encodeASCII(String string) {
        return string.getBytes(ASCII_CHARSET);
    }

    public static boolean exists(Path path) {
        return Files.exists(path, LINK_OPTIONS);
    }

    public static Path getCodeSource(Class<?> clazz) {
        return Paths.get(IOHelper.toURI(clazz.getProtectionDomain().getCodeSource().getLocation()));
    }

    public static String getFileName(Path path) {
        return path.getFileName().toString();
    }

    public static String getIP(SocketAddress socketAddress) {
        return ((InetSocketAddress)socketAddress).getAddress().getHostAddress();
    }

    public static Path getRoot() {
        switch (JVMHelper.OS_TYPE) {
            case MUSTDIE: {
                String string = System.getenv("SystemDrive").concat("\\");
                return Paths.get(string, new String[0]);
            }
            case LINUX: 
            case MACOSX: {
                return Paths.get(CROSS_SEPARATOR, new String[0]);
            }
        }
        throw new UnsupportedOperationException();
    }

    public static byte[] getResourceBytes(String string) throws IOException {
        return IOHelper.read(IOHelper.getResourceURL(string));
    }

    public static URL getResourceURL(String string) throws NoSuchFileException {
        URL uRL = IOHelper.class.getResource('/' + string);
        if (uRL == null) {
            throw new NoSuchFileException(string);
        }
        return uRL;
    }

    public static boolean hasExtension(Path path, String string) {
        return IOHelper.getFileName(path).endsWith('.' + string);
    }

    public static boolean isDir(Path path) {
        return Files.isDirectory(path, LINK_OPTIONS);
    }

    public static boolean isEmpty(Path path) throws IOException {
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
            boolean bl = !directoryStream.iterator().hasNext();
            return bl;
        }
    }

    public static boolean isFile(Path path) {
        return Files.isRegularFile(path, LINK_OPTIONS);
    }

    public static boolean isValidFileName(String string) {
        return !string.equals(".") && !string.equals("..") && string.chars().noneMatch(n -> n == 47 || n == 92) && IOHelper.isValidPath(string);
    }

    public static boolean isValidPath(String string) {
        try {
            IOHelper.toPath(string);
            return true;
        }
        catch (InvalidPathException invalidPathException) {
            return false;
        }
    }

    public static boolean isValidTextureBounds(int n, int n2, boolean bl) {
        return n % 64 == 0 && (n2 << 1 == n || !bl && n2 == n) && n <= 1024 || bl && n % 22 == 0 && n2 % 17 == 0 && n / 22 == n2 / 17;
    }

    public static void move(Path path, Path path2) throws IOException {
        IOHelper.walk(path, new MoveFileVisitor(path, path2), true);
    }

    public static byte[] newBuffer() {
        return new byte[BUFFER_SIZE];
    }

    public static ByteArrayOutputStream newByteArrayOutput() {
        return new ByteArrayOutputStream();
    }

    public static char[] newCharBuffer() {
        return new char[BUFFER_SIZE];
    }

    public static URLConnection newConnection(URL uRL) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        if (uRLConnection instanceof HttpURLConnection) {
            uRLConnection.setReadTimeout(HTTP_TIMEOUT);
            uRLConnection.setConnectTimeout(HTTP_TIMEOUT);
            uRLConnection.addRequestProperty("User-Agent", USER_AGENT);
        } else {
            uRLConnection.setUseCaches(false);
        }
        uRLConnection.setDoInput(true);
        uRLConnection.setDoOutput(false);
        return uRLConnection;
    }

    public static HttpURLConnection newConnectionPost(URL uRL) throws IOException {
        HttpURLConnection httpURLConnection = (HttpURLConnection)IOHelper.newConnection(uRL);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setRequestMethod("POST");
        return httpURLConnection;
    }

    public static Deflater newDeflater() {
        Deflater deflater = new Deflater(-1, true);
        deflater.setStrategy(0);
        return deflater;
    }

    public static Inflater newInflater() {
        return new Inflater(true);
    }

    public static InputStream newInput(Path path) throws IOException {
        return Files.newInputStream(path, READ_OPTIONS);
    }

    public static InputStream newBufferedInput(Path path) throws IOException {
        return new BufferedInputStream(Files.newInputStream(path, READ_OPTIONS));
    }

    public static InputStream newInput(URL uRL) throws IOException {
        return IOHelper.newConnection(uRL).getInputStream();
    }

    public static BufferedInputStream newBufferedInput(URL uRL) throws IOException {
        return new BufferedInputStream(IOHelper.newConnection(uRL).getInputStream());
    }

    public static OutputStream newOutput(Path path) throws IOException {
        return IOHelper.newOutput(path, false);
    }

    public static OutputStream newBufferedOutput(Path path) throws IOException {
        return IOHelper.newBufferedOutput(path, false);
    }

    public static OutputStream newOutput(Path path, boolean bl) throws IOException {
        IOHelper.createParentDirs(path);
        return Files.newOutputStream(path, bl ? APPEND_OPTIONS : WRITE_OPTIONS);
    }

    public static OutputStream newBufferedOutput(Path path, boolean bl) throws IOException {
        IOHelper.createParentDirs(path);
        return new BufferedOutputStream(Files.newOutputStream(path, bl ? APPEND_OPTIONS : WRITE_OPTIONS));
    }

    public static BufferedReader newReader(InputStream inputStream) {
        return IOHelper.newReader(inputStream, UNICODE_CHARSET);
    }

    public static BufferedReader newReader(InputStream inputStream, Charset charset) {
        return new BufferedReader(new InputStreamReader(inputStream, charset));
    }

    public static BufferedReader newReader(Path path) throws IOException {
        return Files.newBufferedReader(path, UNICODE_CHARSET);
    }

    public static BufferedReader newReader(URL uRL) throws IOException {
        URLConnection uRLConnection = IOHelper.newConnection(uRL);
        String string = uRLConnection.getContentEncoding();
        return IOHelper.newReader(uRLConnection.getInputStream(), string == null ? UNICODE_CHARSET : Charset.forName(string));
    }

    public static Socket newSocket() throws SocketException {
        Socket socket = new Socket();
        IOHelper.setSocketFlags(socket);
        return socket;
    }

    public static BufferedWriter newWriter(FileDescriptor fileDescriptor) {
        return IOHelper.newWriter(new FileOutputStream(fileDescriptor));
    }

    public static BufferedWriter newWriter(OutputStream outputStream) {
        return new BufferedWriter(new OutputStreamWriter(outputStream, UNICODE_CHARSET));
    }

    public static BufferedWriter newWriter(Path path) throws IOException {
        return IOHelper.newWriter(path, false);
    }

    public static BufferedWriter newWriter(Path path, boolean bl) throws IOException {
        IOHelper.createParentDirs(path);
        return Files.newBufferedWriter(path, UNICODE_CHARSET, bl ? APPEND_OPTIONS : WRITE_OPTIONS);
    }

    public static ZipEntry newZipEntry(String string) {
        ZipEntry zipEntry = new ZipEntry(string);
        zipEntry.setTime(0L);
        return zipEntry;
    }

    public static ZipEntry newZipEntry(ZipEntry zipEntry) {
        return IOHelper.newZipEntry(zipEntry.getName());
    }

    public static ZipInputStream newZipInput(InputStream inputStream) {
        return new ZipInputStream(inputStream, UNICODE_CHARSET);
    }

    public static ZipInputStream newZipInput(Path path) throws IOException {
        return IOHelper.newZipInput(IOHelper.newInput(path));
    }

    public static ZipInputStream newZipInput(URL uRL) throws IOException {
        return IOHelper.newZipInput(IOHelper.newInput(uRL));
    }

    public static byte[] read(InputStream inputStream) throws IOException {
        try (ByteArrayOutputStream byteArrayOutputStream = IOHelper.newByteArrayOutput();){
            IOHelper.transfer(inputStream, (OutputStream)byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
    }

    public static void read(InputStream inputStream, byte[] byArray) throws IOException {
        int n;
        for (int i = 0; i < byArray.length; i += n) {
            n = inputStream.read(byArray, i, byArray.length - i);
            if (n >= 0) continue;
            throw new EOFException(String.format("%d bytes remaining", byArray.length - i));
        }
    }

    public static byte[] read(Path path) throws IOException {
        long l = IOHelper.readAttributes(path).size();
        if (l > Integer.MAX_VALUE) {
            throw new IOException("File too big");
        }
        byte[] byArray = new byte[(int)l];
        try (InputStream inputStream = IOHelper.newInput(path);){
            IOHelper.read(inputStream, byArray);
        }
        return byArray;
    }

    public static byte[] read(URL uRL) throws IOException {
        try (InputStream inputStream = IOHelper.newInput(uRL);){
            byte[] byArray = IOHelper.read(inputStream);
            return byArray;
        }
    }

    public static BasicFileAttributes readAttributes(Path path) throws IOException {
        return Files.readAttributes(path, BasicFileAttributes.class, LINK_OPTIONS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readTexture(Object object, boolean bl) throws IOException {
        ImageReader imageReader = ImageIO.getImageReadersByMIMEType("image/png").next();
        try {
            imageReader.setInput(ImageIO.createImageInputStream(object), false, false);
            int n = imageReader.getWidth(0);
            int n2 = imageReader.getHeight(0);
            if (!IOHelper.isValidTextureBounds(n, n2, bl)) {
                throw new IOException(String.format("Invalid texture bounds: %dx%d", n, n2));
            }
            imageReader.read(0);
        }
        finally {
            imageReader.dispose();
        }
    }

    public static String request(URL uRL) throws IOException {
        return IOHelper.decode(IOHelper.read(uRL)).trim();
    }

    public static InetSocketAddress resolve(InetSocketAddress inetSocketAddress) {
        if (inetSocketAddress.isUnresolved()) {
            return new InetSocketAddress(inetSocketAddress.getHostString(), inetSocketAddress.getPort());
        }
        return inetSocketAddress;
    }

    public static Path resolveIncremental(Path path, String string, String string2) {
        Path path2;
        Path path3 = path.resolve(string + '.' + string2);
        if (!IOHelper.exists(path3)) {
            return path3;
        }
        int n = 1;
        while (IOHelper.exists(path2 = path.resolve(String.format("%s (%d).%s", string, n, string2)))) {
            ++n;
        }
        return path2;
    }

    public static Path resolveJavaBin(Path path) {
        return IOHelper.resolveJavaBin(path, false);
    }

    public static Path resolveJavaBin(Path path, boolean bl) {
        Path path2;
        Path path3 = (path == null ? JVM_DIR : path).resolve("bin");
        if (!bl && !LogHelper.isDebugEnabled() && IOHelper.isFile(path2 = path3.resolve("javaw.exe"))) {
            return path2;
        }
        path2 = path3.resolve("java.exe");
        if (IOHelper.isFile(path2)) {
            return path2;
        }
        Path path4 = path3.resolve("java");
        if (IOHelper.isFile(path4)) {
            return path4;
        }
        throw new RuntimeException("Java binary wasn't found");
    }

    public static void setSocketFlags(Socket socket) throws SocketException {
        socket.setKeepAlive(false);
        socket.setTcpNoDelay(false);
        socket.setReuseAddress(true);
        socket.setSoTimeout(SOCKET_TIMEOUT);
        try {
            socket.setTrafficClass(28);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        socket.setPerformancePreferences(1, 0, 2);
    }

    public static String toAbsPathString(Path path) {
        return IOHelper.toAbsPath(path).toFile().getAbsolutePath();
    }

    public static Path toAbsPath(Path path) {
        return path.normalize().toAbsolutePath();
    }

    public static byte[] toByteArray(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(inputStream.available());
        IOHelper.transfer(inputStream, (OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static Path toPath(String string) {
        return Paths.get(CROSS_SEPARATOR_PATTERN.matcher(string).replaceAll(Matcher.quoteReplacement(PLATFORM_SEPARATOR)), new String[0]);
    }

    public static String toString(Path path) {
        return PLATFORM_SEPARATOR_PATTERN.matcher(path.toString()).replaceAll(Matcher.quoteReplacement(CROSS_SEPARATOR));
    }

    public static URI toURI(URL uRL) {
        try {
            return uRL.toURI();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException(uRISyntaxException);
        }
    }

    public static URL toURL(Path path) {
        try {
            return path.toUri().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            throw new InternalError(malformedURLException);
        }
    }

    public static void transfer(byte[] byArray, Path path, boolean bl) throws IOException {
        try (OutputStream outputStream = IOHelper.newOutput(path, bl);){
            outputStream.write(byArray);
        }
    }

    public static long transfer(InputStream inputStream, OutputStream outputStream) throws IOException {
        long l = 0L;
        byte[] byArray = IOHelper.newBuffer();
        int n = inputStream.read(byArray);
        while (n >= 0) {
            outputStream.write(byArray, 0, n);
            l += (long)n;
            n = inputStream.read(byArray);
        }
        return l;
    }

    public static void transfer(InputStream inputStream, Path path) throws IOException {
        IOHelper.transfer(inputStream, path, false);
    }

    public static long transfer(InputStream inputStream, Path path, boolean bl) throws IOException {
        try (OutputStream outputStream = IOHelper.newOutput(path, bl);){
            long l = IOHelper.transfer(inputStream, outputStream);
            return l;
        }
    }

    public static void transfer(Path path, OutputStream outputStream) throws IOException {
        try (InputStream inputStream = IOHelper.newInput(path);){
            IOHelper.transfer(inputStream, outputStream);
        }
    }

    public static String urlDecode(String string) {
        try {
            return URLDecoder.decode(string, UNICODE_CHARSET.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalError(unsupportedEncodingException);
        }
    }

    public static String urlEncode(String string) {
        try {
            return URLEncoder.encode(string, UNICODE_CHARSET.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalError(unsupportedEncodingException);
        }
    }

    public static String verifyFileName(String string) {
        return VerifyHelper.verify(string, IOHelper::isValidFileName, String.format("Invalid file name: '%s'", string));
    }

    public static int verifyLength(int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 && n != -n2 || n2 > 0 && n > n2) {
            throw new IOException("Illegal length: " + n);
        }
        return n;
    }

    public static BufferedImage verifyTexture(BufferedImage bufferedImage2, boolean bl) {
        return VerifyHelper.verify(bufferedImage2, bufferedImage -> IOHelper.isValidTextureBounds(bufferedImage.getWidth(), bufferedImage.getHeight(), bl), String.format("Invalid texture bounds: %dx%d", bufferedImage2.getWidth(), bufferedImage2.getHeight()));
    }

    public static String verifyURL(String string) {
        try {
            new URL(string).toURI();
            return string;
        }
        catch (MalformedURLException | URISyntaxException exception) {
            throw new IllegalArgumentException("Invalid URL", exception);
        }
    }

    public static void walk(Path path, FileVisitor<Path> skipHiddenVisitor, boolean bl) throws IOException {
        Files.walkFileTree(path, WALK_OPTIONS, Integer.MAX_VALUE, bl ? skipHiddenVisitor : new SkipHiddenVisitor(skipHiddenVisitor));
    }

    public static void write(Path path, byte[] byArray) throws IOException {
        IOHelper.createParentDirs(path);
        Files.write(path, byArray, WRITE_OPTIONS);
    }

    public static InputStream nonClosing(InputStream inputStream) {
        return new FilterInputStream(inputStream){

            @Override
            public void close() {
            }
        };
    }

    public static OutputStream nonClosing(OutputStream outputStream) {
        return new FilterOutputStream(outputStream){

            @Override
            public void write(byte[] byArray, int n, int n2) throws IOException {
                this.out.write(byArray, n, n2);
            }

            @Override
            public void close() {
            }
        };
    }

    private static final class DeleteDirVisitor
    extends SimpleFileVisitor<Path> {
        private final Path dir;
        private final boolean self;

        private DeleteDirVisitor(Path path, boolean bl) {
            this.dir = path;
            this.self = bl;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path path, IOException iOException) throws IOException {
            FileVisitResult fileVisitResult = super.postVisitDirectory(path, iOException);
            if (this.self || !this.dir.equals(path)) {
                Files.delete(path);
            }
            return fileVisitResult;
        }

        @Override
        public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
            Files.delete(path);
            return super.visitFile(path, basicFileAttributes);
        }
    }

    private static class MoveFileVisitor
    implements FileVisitor<Path> {
        private final Path from;
        private final Path to;

        private MoveFileVisitor(Path path, Path path2) {
            this.from = path;
            this.to = path2;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
            Path path2 = this.to.resolve(this.from.relativize(path));
            if (!IOHelper.isDir(path2)) {
                Files.createDirectories(path2, new FileAttribute[0]);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
            Files.move(path, this.to.resolve(this.from.relativize(path)), COPY_OPTIONS);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path path, IOException iOException) throws IOException {
            throw iOException;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path path, IOException iOException) throws IOException {
            if (iOException != null) {
                throw iOException;
            }
            if (!this.from.equals(path)) {
                Files.delete(path);
            }
            return FileVisitResult.CONTINUE;
        }
    }

    private static final class SkipHiddenVisitor
    implements FileVisitor<Path> {
        private final FileVisitor<Path> visitor;

        private SkipHiddenVisitor(FileVisitor<Path> fileVisitor) {
            this.visitor = fileVisitor;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path path, IOException iOException) throws IOException {
            return Files.isHidden(path) ? FileVisitResult.CONTINUE : this.visitor.postVisitDirectory(path, iOException);
        }

        @Override
        public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
            return Files.isHidden(path) ? FileVisitResult.SKIP_SUBTREE : this.visitor.preVisitDirectory(path, basicFileAttributes);
        }

        @Override
        public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
            return Files.isHidden(path) ? FileVisitResult.CONTINUE : this.visitor.visitFile(path, basicFileAttributes);
        }

        @Override
        public FileVisitResult visitFileFailed(Path path, IOException iOException) throws IOException {
            return this.visitor.visitFileFailed(path, iOException);
        }
    }
}

