/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.utils.helper;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Base64;
import java.util.LinkedList;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptEngine;
import pro.gravit.utils.command.CommandException;

public final class CommonHelper {
    private CommonHelper() {
    }

    public static String low(String string) {
        return string.toLowerCase(Locale.US);
    }

    public static boolean multiMatches(Pattern[] patternArray, String string) {
        for (Pattern pattern : patternArray) {
            if (!pattern.matcher(string).matches()) continue;
            return true;
        }
        return false;
    }

    public static String multiReplace(Pattern[] patternArray, String string, String string2) {
        String string3 = null;
        for (Pattern pattern : patternArray) {
            Matcher matcher = pattern.matcher(string);
            if (!matcher.matches()) continue;
            string3 = matcher.replaceAll(string2);
        }
        return string3 != null ? string3 : string;
    }

    @Deprecated
    public static ScriptEngine newScriptEngine() {
        throw new UnsupportedOperationException("ScriptEngine not supported");
    }

    public static Thread newThread(String string, boolean bl, Runnable runnable) {
        Thread thread = new Thread(runnable);
        thread.setDaemon(bl);
        if (string != null) {
            thread.setName(string);
        }
        return thread;
    }

    public static String replace(String string, String ... stringArray) {
        for (int i = 0; i < stringArray.length; i += 2) {
            string = string.replace('%' + stringArray[i] + '%', stringArray[i + 1]);
        }
        return string;
    }

    public static String[] parseCommand(CharSequence charSequence) throws CommandException {
        boolean bl = false;
        boolean bl2 = false;
        LinkedList<String> linkedList = new LinkedList<String>();
        StringBuilder stringBuilder = new StringBuilder(100);
        block4: for (int i = 0; i <= charSequence.length(); ++i) {
            char c;
            boolean bl3 = i >= charSequence.length();
            char c2 = c = bl3 ? (char)'\u0000' : charSequence.charAt(i);
            if (bl3 || !bl && Character.isWhitespace(c)) {
                if (bl3 && bl) {
                    throw new CommandException("Quotes wasn't closed");
                }
                if (bl2 || stringBuilder.length() > 0) {
                    linkedList.add(stringBuilder.toString());
                }
                bl2 = false;
                stringBuilder.setLength(0);
                continue;
            }
            switch (c) {
                case '\"': {
                    bl = !bl;
                    bl2 = true;
                    continue block4;
                }
                case '\\': {
                    if (i + 1 >= charSequence.length()) {
                        throw new CommandException("Escape character is not specified");
                    }
                    char c3 = charSequence.charAt(i + 1);
                    stringBuilder.append(c3);
                    ++i;
                    continue block4;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return linkedList.toArray(new String[0]);
    }

    public static GsonBuilder newBuilder() {
        return new GsonBuilder().registerTypeHierarchyAdapter(byte[].class, ByteArrayToBase64TypeAdapter.INSTANCE);
    }

    private static class ByteArrayToBase64TypeAdapter
    implements JsonSerializer<byte[]>,
    JsonDeserializer<byte[]> {
        private static final ByteArrayToBase64TypeAdapter INSTANCE = new ByteArrayToBase64TypeAdapter();
        private final Base64.Decoder decoder = Base64.getUrlDecoder();
        private final Base64.Encoder encoder = Base64.getUrlEncoder();

        private ByteArrayToBase64TypeAdapter() {
        }

        @Override
        public byte[] deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            if (jsonElement.isJsonArray()) {
                JsonArray jsonArray = jsonElement.getAsJsonArray();
                byte[] byArray = new byte[jsonArray.size()];
                for (int i = 0; i < byArray.length; ++i) {
                    byArray[i] = jsonArray.get(i).getAsByte();
                }
                return byArray;
            }
            return this.decoder.decode(jsonElement.getAsString());
        }

        @Override
        public JsonElement serialize(byte[] byArray, Type type, JsonSerializationContext jsonSerializationContext) {
            return new JsonPrimitive(this.encoder.encodeToString(byArray));
        }
    }
}

