/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.utils;

import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import pro.gravit.launcher.AsyncDownloader;
import pro.gravit.utils.helper.LogHelper;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class Downloader {
    private final CompletableFuture<Void> future;
    private final AsyncDownloader asyncDownloader;

    private Downloader(CompletableFuture<Void> completableFuture, AsyncDownloader asyncDownloader) {
        this.future = completableFuture;
        this.asyncDownloader = asyncDownloader;
    }

    public static Downloader downloadList(List<AsyncDownloader.SizedFile> list, String string, Path path, DownloadCallback downloadCallback, ExecutorService executorService, int n) {
        boolean bl;
        LogHelper.info("Download with legacy mode");
        if (executorService == null) {
            executorService = Executors.newWorkStealingPool(4);
            bl = true;
        } else {
            bl = false;
        }
        AsyncDownloader asyncDownloader = new AsyncDownloader(l -> {
            if (downloadCallback != null) {
                downloadCallback.apply(l);
            }
        });
        List<List<AsyncDownloader.SizedFile>> list2 = asyncDownloader.sortFiles(list, n);
        CompletableFuture<Void> completableFuture = CompletableFuture.allOf(asyncDownloader.runDownloadList(list2, string, path, executorService));
        ExecutorService executorService2 = executorService;
        return new Downloader((CompletableFuture<Void>)completableFuture.thenAccept(void_ -> {
            if (bl) {
                executorService2.shutdownNow();
            }
        }), asyncDownloader);
    }

    public CompletableFuture<Void> getFuture() {
        return this.future;
    }

    public void cancel() {
        this.asyncDownloader.isClosed = true;
    }

    public boolean isCanceled() {
        return this.asyncDownloader.isClosed;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface DownloadCallback {
        public void apply(long var1);

        public void onComplete(Path var1);
    }
}

