/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.util.internal;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.PosixFilePermission;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.Set;
import pro.gravit.repackage.io.netty.util.CharsetUtil;
import pro.gravit.repackage.io.netty.util.internal.NativeLibraryUtil;
import pro.gravit.repackage.io.netty.util.internal.PlatformDependent;
import pro.gravit.repackage.io.netty.util.internal.SuppressJava6Requirement;
import pro.gravit.repackage.io.netty.util.internal.SystemPropertyUtil;
import pro.gravit.repackage.io.netty.util.internal.ThrowableUtil;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLogger;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLoggerFactory;

public final class NativeLibraryLoader {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(NativeLibraryLoader.class);
    private static final String NATIVE_RESOURCE_HOME = "META-INF/native/";
    private static final File WORKDIR;
    private static final boolean DELETE_NATIVE_LIB_AFTER_LOADING;
    private static final boolean TRY_TO_PATCH_SHADED_ID;
    private static final boolean DETECT_NATIVE_LIBRARY_DUPLICATES;
    private static final byte[] UNIQUE_ID_BYTES;

    public static void loadFirstAvailable(ClassLoader classLoader, String ... stringArray) {
        ArrayList<Throwable> arrayList = new ArrayList<Throwable>();
        for (String string : stringArray) {
            try {
                NativeLibraryLoader.load(string, classLoader);
                logger.debug("Loaded library with name '{}'", (Object)string);
                return;
            }
            catch (Throwable throwable) {
                arrayList.add(throwable);
            }
        }
        IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Failed to load any of the given libraries: " + Arrays.toString(stringArray));
        ThrowableUtil.addSuppressedAndClear(illegalArgumentException, arrayList);
        throw illegalArgumentException;
    }

    private static String calculateMangledPackagePrefix() {
        String string;
        String string2 = NativeLibraryLoader.class.getName();
        if (!string2.endsWith(string = "io!netty!util!internal!NativeLibraryLoader".replace('!', '.'))) {
            throw new UnsatisfiedLinkError(String.format("Could not find prefix added to %s to get %s. When shading, only adding a package prefix is supported", string, string2));
        }
        return string2.substring(0, string2.length() - string.length()).replace("_", "_1").replace('.', '_');
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void load(String string, ClassLoader classLoader) {
        String string2 = NativeLibraryLoader.calculateMangledPackagePrefix();
        String string3 = string2 + string;
        ArrayList<Throwable> arrayList = new ArrayList<Throwable>();
        try {
            NativeLibraryLoader.loadLibrary(classLoader, string3, false);
            return;
        }
        catch (Throwable throwable) {
            arrayList.add(throwable);
            String string4 = System.mapLibraryName(string3);
            String string5 = NATIVE_RESOURCE_HOME + string4;
            InputStream inputStream = null;
            FileOutputStream fileOutputStream = null;
            File file = null;
            URL uRL = NativeLibraryLoader.getResource(string5, classLoader);
            try {
                int n;
                if (uRL == null) {
                    if (!PlatformDependent.isOsx()) {
                        FileNotFoundException fileNotFoundException = new FileNotFoundException(string5);
                        ThrowableUtil.addSuppressedAndClear(fileNotFoundException, arrayList);
                        throw fileNotFoundException;
                    }
                    String string6 = string5.endsWith(".jnilib") ? "META-INF/native/lib" + string3 + ".dynlib" : "META-INF/native/lib" + string3 + ".jnilib";
                    uRL = NativeLibraryLoader.getResource(string6, classLoader);
                    if (uRL == null) {
                        FileNotFoundException fileNotFoundException = new FileNotFoundException(string6);
                        ThrowableUtil.addSuppressedAndClear(fileNotFoundException, arrayList);
                        throw fileNotFoundException;
                    }
                }
                int n2 = string4.lastIndexOf(46);
                String string7 = string4.substring(0, n2);
                String string8 = string4.substring(n2);
                file = PlatformDependent.createTempFile(string7, string8, WORKDIR);
                inputStream = uRL.openStream();
                fileOutputStream = new FileOutputStream(file);
                byte[] byArray = new byte[8192];
                while ((n = inputStream.read(byArray)) > 0) {
                    ((OutputStream)fileOutputStream).write(byArray, 0, n);
                }
                fileOutputStream.flush();
                if (NativeLibraryLoader.shouldShadedLibraryIdBePatched(string2)) {
                    NativeLibraryLoader.tryPatchShadedLibraryIdAndSign(file, string);
                }
                NativeLibraryLoader.closeQuietly(fileOutputStream);
                fileOutputStream = null;
                NativeLibraryLoader.loadLibrary(classLoader, file.getPath(), true);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                try {
                    try {
                        if (file != null && file.isFile() && file.canRead() && !NoexecVolumeDetector.canExecuteExecutable(file)) {
                            logger.info("{} exists but cannot be executed even when execute permissions set; check volume for \"noexec\" flag; use -D{}=[path] to set native working directory separately.", (Object)file.getPath(), (Object)"pro.gravit.repackage.io.netty.native.workdir");
                        }
                    }
                    catch (Throwable throwable2) {
                        arrayList.add(throwable2);
                        logger.debug("Error checking if {} is on a file store mounted with noexec", (Object)file, (Object)throwable2);
                    }
                    ThrowableUtil.addSuppressedAndClear(unsatisfiedLinkError, arrayList);
                    throw unsatisfiedLinkError;
                    catch (Exception exception) {
                        UnsatisfiedLinkError unsatisfiedLinkError2 = new UnsatisfiedLinkError("could not load a native library: " + string3);
                        unsatisfiedLinkError2.initCause(exception);
                        ThrowableUtil.addSuppressedAndClear(unsatisfiedLinkError2, arrayList);
                        throw unsatisfiedLinkError2;
                    }
                }
                catch (Throwable throwable3) {
                    NativeLibraryLoader.closeQuietly(inputStream);
                    NativeLibraryLoader.closeQuietly(fileOutputStream);
                    if (file == null) throw throwable3;
                    if (DELETE_NATIVE_LIB_AFTER_LOADING) {
                        if (file.delete()) throw throwable3;
                    }
                    file.deleteOnExit();
                    throw throwable3;
                }
            }
            NativeLibraryLoader.closeQuietly(inputStream);
            NativeLibraryLoader.closeQuietly(fileOutputStream);
            if (file == null) return;
            if (DELETE_NATIVE_LIB_AFTER_LOADING) {
                if (file.delete()) return;
            }
            file.deleteOnExit();
            return;
        }
    }

    private static URL getResource(String string, ClassLoader classLoader) {
        Enumeration<URL> enumeration;
        try {
            enumeration = classLoader == null ? ClassLoader.getSystemResources(string) : classLoader.getResources(string);
        }
        catch (IOException iOException) {
            throw new RuntimeException("An error occurred while getting the resources for " + string, iOException);
        }
        ArrayList<URL> arrayList = Collections.list(enumeration);
        int n = arrayList.size();
        switch (n) {
            case 0: {
                return null;
            }
            case 1: {
                return (URL)arrayList.get(0);
            }
        }
        if (DETECT_NATIVE_LIBRARY_DUPLICATES) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
                URL uRL = (URL)arrayList.get(0);
                byte[] byArray = NativeLibraryLoader.digest(messageDigest, uRL);
                boolean bl = true;
                if (byArray != null) {
                    for (int i = 1; i < n; ++i) {
                        byte[] byArray2 = NativeLibraryLoader.digest(messageDigest, (URL)arrayList.get(i));
                        if (byArray2 != null && Arrays.equals(byArray, byArray2)) continue;
                        bl = false;
                        break;
                    }
                } else {
                    bl = false;
                }
                if (bl) {
                    return uRL;
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                logger.debug("Don't support SHA-256, can't check if resources have same content.", noSuchAlgorithmException);
            }
            throw new IllegalStateException("Multiple resources found for '" + string + "' with different content: " + arrayList);
        }
        logger.warn("Multiple resources found for '" + string + "' with different content: " + arrayList + ". Please fix your dependency graph.");
        return (URL)arrayList.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] digest(MessageDigest messageDigest, URL uRL) {
        InputStream inputStream = null;
        try {
            int n;
            inputStream = uRL.openStream();
            byte[] byArray = new byte[8192];
            while ((n = inputStream.read(byArray)) != -1) {
                messageDigest.update(byArray, 0, n);
            }
            byte[] byArray2 = messageDigest.digest();
            return byArray2;
        }
        catch (IOException iOException) {
            logger.debug("Can't read resource.", iOException);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            NativeLibraryLoader.closeQuietly(inputStream);
        }
    }

    static void tryPatchShadedLibraryIdAndSign(File file, String string) {
        if (!new File("/Library/Developer/CommandLineTools").exists()) {
            logger.debug("Can't patch shaded library id as CommandLineTools are not installed. Consider installing CommandLineTools with 'xcode-select --install'");
            return;
        }
        String string2 = new String(NativeLibraryLoader.generateUniqueId(string.length()), CharsetUtil.UTF_8);
        if (!NativeLibraryLoader.tryExec("install_name_tool -id " + string2 + " " + file.getAbsolutePath())) {
            return;
        }
        NativeLibraryLoader.tryExec("codesign -s - " + file.getAbsolutePath());
    }

    private static boolean tryExec(String string) {
        try {
            int n = Runtime.getRuntime().exec(string).waitFor();
            if (n != 0) {
                logger.debug("Execution of '{}' failed: {}", (Object)string, (Object)n);
                return false;
            }
            logger.debug("Execution of '{}' succeed: {}", (Object)string, (Object)n);
            return true;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            logger.info("Execution of '{}' failed.", (Object)string, (Object)iOException);
        }
        catch (SecurityException securityException) {
            logger.error("Execution of '{}' failed.", (Object)string, (Object)securityException);
        }
        return false;
    }

    private static boolean shouldShadedLibraryIdBePatched(String string) {
        return TRY_TO_PATCH_SHADED_ID && PlatformDependent.isOsx() && !string.isEmpty();
    }

    private static byte[] generateUniqueId(int n) {
        byte[] byArray = new byte[n];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = UNIQUE_ID_BYTES[PlatformDependent.threadLocalRandom().nextInt(UNIQUE_ID_BYTES.length)];
        }
        return byArray;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void loadLibrary(ClassLoader classLoader, String string, boolean bl) {
        Throwable throwable = null;
        try {
            try {
                Class<?> clazz = NativeLibraryLoader.tryToLoadClass(classLoader, NativeLibraryUtil.class);
                NativeLibraryLoader.loadLibraryByHelper(clazz, string, bl);
                logger.debug("Successfully loaded the library {}", (Object)string);
                return;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                try {
                    block8: {
                        throwable = unsatisfiedLinkError;
                        break block8;
                        catch (Exception exception) {
                            throwable = exception;
                        }
                    }
                    NativeLibraryUtil.loadLibrary(string, bl);
                    logger.debug("Successfully loaded the library {}", (Object)string);
                    return;
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError2) {
                    if (throwable == null) throw unsatisfiedLinkError2;
                    ThrowableUtil.addSuppressed((Throwable)unsatisfiedLinkError2, throwable);
                    throw unsatisfiedLinkError2;
                }
            }
        }
        catch (NoSuchMethodError noSuchMethodError) {
            if (throwable != null) {
                ThrowableUtil.addSuppressed((Throwable)noSuchMethodError, throwable);
            }
            NativeLibraryLoader.rethrowWithMoreDetailsIfPossible(string, noSuchMethodError);
            return;
        }
    }

    @SuppressJava6Requirement(reason="Guarded by version check")
    private static void rethrowWithMoreDetailsIfPossible(String string, NoSuchMethodError noSuchMethodError) {
        if (PlatformDependent.javaVersion() >= 7) {
            throw new LinkageError("Possible multiple incompatible native libraries on the classpath for '" + string + "'?", noSuchMethodError);
        }
        throw noSuchMethodError;
    }

    private static void loadLibraryByHelper(final Class<?> clazz, final String string, final boolean bl) throws UnsatisfiedLinkError {
        Object object = AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    Method method = clazz.getMethod("loadLibrary", String.class, Boolean.TYPE);
                    method.setAccessible(true);
                    return method.invoke(null, string, bl);
                }
                catch (Exception exception) {
                    return exception;
                }
            }
        });
        if (object instanceof Throwable) {
            Throwable throwable = (Throwable)object;
            assert (!(throwable instanceof UnsatisfiedLinkError)) : throwable + " should be a wrapper throwable";
            Throwable throwable2 = throwable.getCause();
            if (throwable2 instanceof UnsatisfiedLinkError) {
                throw (UnsatisfiedLinkError)throwable2;
            }
            UnsatisfiedLinkError unsatisfiedLinkError = new UnsatisfiedLinkError(throwable.getMessage());
            unsatisfiedLinkError.initCause(throwable);
            throw unsatisfiedLinkError;
        }
    }

    private static Class<?> tryToLoadClass(final ClassLoader classLoader, final Class<?> clazz) throws ClassNotFoundException {
        try {
            return Class.forName(clazz.getName(), false, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (classLoader == null) {
                throw classNotFoundException;
            }
            try {
                final byte[] byArray = NativeLibraryLoader.classToByteArray(clazz);
                return (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

                    @Override
                    public Class<?> run() {
                        try {
                            Method method = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
                            method.setAccessible(true);
                            return (Class)method.invoke((Object)classLoader, clazz.getName(), byArray, 0, byArray.length);
                        }
                        catch (Exception exception) {
                            throw new IllegalStateException("Define class failed!", exception);
                        }
                    }
                });
            }
            catch (ClassNotFoundException classNotFoundException2) {
                ThrowableUtil.addSuppressed((Throwable)classNotFoundException2, classNotFoundException);
                throw classNotFoundException2;
            }
            catch (RuntimeException runtimeException) {
                ThrowableUtil.addSuppressed((Throwable)runtimeException, classNotFoundException);
                throw runtimeException;
            }
            catch (Error error) {
                ThrowableUtil.addSuppressed((Throwable)error, classNotFoundException);
                throw error;
            }
        }
    }

    private static byte[] classToByteArray(Class<?> clazz) throws ClassNotFoundException {
        URL uRL;
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        if (n > 0) {
            string = string.substring(n + 1);
        }
        if ((uRL = clazz.getResource(string + ".class")) == null) {
            throw new ClassNotFoundException(clazz.getName());
        }
        byte[] byArray = new byte[1024];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
        InputStream inputStream = null;
        try {
            int n2;
            inputStream = uRL.openStream();
            while ((n2 = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n2);
            }
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            return byArray2;
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException(clazz.getName(), iOException);
        }
        finally {
            NativeLibraryLoader.closeQuietly(inputStream);
            NativeLibraryLoader.closeQuietly(byteArrayOutputStream);
        }
    }

    private static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private NativeLibraryLoader() {
    }

    static {
        UNIQUE_ID_BYTES = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".getBytes(CharsetUtil.US_ASCII);
        String string = SystemPropertyUtil.get("pro.gravit.repackage.io.netty.native.workdir");
        if (string != null) {
            File file = new File(string);
            file.mkdirs();
            try {
                file = file.getAbsoluteFile();
            }
            catch (Exception exception) {
                // empty catch block
            }
            WORKDIR = file;
            logger.debug("-Dio.netty.native.workdir: " + WORKDIR);
        } else {
            WORKDIR = PlatformDependent.tmpdir();
            logger.debug("-Dio.netty.native.workdir: " + WORKDIR + " (io.netty.tmpdir)");
        }
        DELETE_NATIVE_LIB_AFTER_LOADING = SystemPropertyUtil.getBoolean("pro.gravit.repackage.io.netty.native.deleteLibAfterLoading", true);
        logger.debug("-Dio.netty.native.deleteLibAfterLoading: {}", (Object)DELETE_NATIVE_LIB_AFTER_LOADING);
        TRY_TO_PATCH_SHADED_ID = SystemPropertyUtil.getBoolean("pro.gravit.repackage.io.netty.native.tryPatchShadedId", true);
        logger.debug("-Dio.netty.native.tryPatchShadedId: {}", (Object)TRY_TO_PATCH_SHADED_ID);
        DETECT_NATIVE_LIBRARY_DUPLICATES = SystemPropertyUtil.getBoolean("pro.gravit.repackage.io.netty.native.detectNativeLibraryDuplicates", true);
        logger.debug("-Dio.netty.native.detectNativeLibraryDuplicates: {}", (Object)DETECT_NATIVE_LIBRARY_DUPLICATES);
    }

    private static final class NoexecVolumeDetector {
        @SuppressJava6Requirement(reason="Usage guarded by java version check")
        private static boolean canExecuteExecutable(File file) throws IOException {
            EnumSet<PosixFilePermission> enumSet;
            if (PlatformDependent.javaVersion() < 7) {
                return true;
            }
            if (file.canExecute()) {
                return true;
            }
            Set<PosixFilePermission> set = Files.getPosixFilePermissions(file.toPath(), new LinkOption[0]);
            if (set.containsAll(enumSet = EnumSet.of(PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OTHERS_EXECUTE))) {
                return false;
            }
            EnumSet<PosixFilePermission> enumSet2 = EnumSet.copyOf(set);
            enumSet2.addAll(enumSet);
            Files.setPosixFilePermissions(file.toPath(), enumSet2);
            return file.canExecute();
        }

        private NoexecVolumeDetector() {
        }
    }
}

