/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.resolver;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import pro.gravit.repackage.io.netty.resolver.InetNameResolver;
import pro.gravit.repackage.io.netty.resolver.NameResolver;
import pro.gravit.repackage.io.netty.util.concurrent.EventExecutor;
import pro.gravit.repackage.io.netty.util.concurrent.Future;
import pro.gravit.repackage.io.netty.util.concurrent.FutureListener;
import pro.gravit.repackage.io.netty.util.concurrent.GenericFutureListener;
import pro.gravit.repackage.io.netty.util.concurrent.Promise;
import pro.gravit.repackage.io.netty.util.internal.PlatformDependent;

public class RoundRobinInetAddressResolver
extends InetNameResolver {
    private final NameResolver<InetAddress> nameResolver;

    public RoundRobinInetAddressResolver(EventExecutor eventExecutor, NameResolver<InetAddress> nameResolver) {
        super(eventExecutor);
        this.nameResolver = nameResolver;
    }

    @Override
    protected void doResolve(final String string, final Promise<InetAddress> promise) throws Exception {
        this.nameResolver.resolveAll(string).addListener((GenericFutureListener<Future<List<InetAddress>>>)new FutureListener<List<InetAddress>>(){

            @Override
            public void operationComplete(Future<List<InetAddress>> future) throws Exception {
                if (future.isSuccess()) {
                    List<InetAddress> list = future.getNow();
                    int n = list.size();
                    if (n > 0) {
                        promise.setSuccess(list.get(RoundRobinInetAddressResolver.randomIndex(n)));
                    } else {
                        promise.setFailure(new UnknownHostException(string));
                    }
                } else {
                    promise.setFailure(future.cause());
                }
            }
        });
    }

    @Override
    protected void doResolveAll(String string, final Promise<List<InetAddress>> promise) throws Exception {
        this.nameResolver.resolveAll(string).addListener((GenericFutureListener<Future<List<InetAddress>>>)new FutureListener<List<InetAddress>>(){

            @Override
            public void operationComplete(Future<List<InetAddress>> future) throws Exception {
                if (future.isSuccess()) {
                    List<InetAddress> list = future.getNow();
                    if (!list.isEmpty()) {
                        ArrayList<InetAddress> arrayList = new ArrayList<InetAddress>(list);
                        Collections.rotate(arrayList, RoundRobinInetAddressResolver.randomIndex(list.size()));
                        promise.setSuccess(arrayList);
                    } else {
                        promise.setSuccess(list);
                    }
                } else {
                    promise.setFailure(future.cause());
                }
            }
        });
    }

    private static int randomIndex(int n) {
        return n == 1 ? 0 : PlatformDependent.threadLocalRandom().nextInt(n);
    }

    @Override
    public void close() {
        this.nameResolver.close();
    }
}

