/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.ssl.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.util.Date;
import pro.gravit.repackage.io.netty.handler.ssl.util.SelfSignedCertificate;
import pro.gravit.repackage.io.netty.util.internal.PlatformDependent;
import pro.gravit.repackage.io.netty.util.internal.SuppressJava6Requirement;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLogger;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLoggerFactory;
import sun.security.x509.AlgorithmId;
import sun.security.x509.CertificateAlgorithmId;
import sun.security.x509.CertificateSerialNumber;
import sun.security.x509.CertificateSubjectName;
import sun.security.x509.CertificateValidity;
import sun.security.x509.CertificateVersion;
import sun.security.x509.CertificateX509Key;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;

final class OpenJdkSelfSignedCertGenerator {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(OpenJdkSelfSignedCertGenerator.class);
    private static final Method CERT_INFO_SET_METHOD;
    private static final Constructor<?> ISSUER_NAME_CONSTRUCTOR;
    private static final Constructor<X509CertImpl> CERT_IMPL_CONSTRUCTOR;
    private static final Method CERT_IMPL_GET_METHOD;
    private static final Method CERT_IMPL_SIGN_METHOD;

    @SuppressJava6Requirement(reason="Usage guarded by dependency check")
    static String[] generate(String string, KeyPair keyPair, SecureRandom secureRandom, Date date, Date date2, String string2) throws Exception {
        if (CERT_INFO_SET_METHOD == null || ISSUER_NAME_CONSTRUCTOR == null || CERT_IMPL_CONSTRUCTOR == null || CERT_IMPL_GET_METHOD == null || CERT_IMPL_SIGN_METHOD == null) {
            throw new UnsupportedOperationException(OpenJdkSelfSignedCertGenerator.class.getSimpleName() + " not supported on the used JDK version");
        }
        PrivateKey privateKey = keyPair.getPrivate();
        X509CertInfo x509CertInfo = new X509CertInfo();
        X500Name x500Name = new X500Name("CN=" + string);
        CERT_INFO_SET_METHOD.invoke((Object)x509CertInfo, "version", new CertificateVersion(2));
        CERT_INFO_SET_METHOD.invoke((Object)x509CertInfo, "serialNumber", new CertificateSerialNumber(new BigInteger(64, secureRandom)));
        try {
            CERT_INFO_SET_METHOD.invoke((Object)x509CertInfo, "subject", new CertificateSubjectName(x500Name));
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getCause() instanceof CertificateException) {
                CERT_INFO_SET_METHOD.invoke((Object)x509CertInfo, "subject", x500Name);
            }
            throw invocationTargetException;
        }
        try {
            CERT_INFO_SET_METHOD.invoke((Object)x509CertInfo, "issuer", ISSUER_NAME_CONSTRUCTOR.newInstance(x500Name));
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getCause() instanceof CertificateException) {
                CERT_INFO_SET_METHOD.invoke((Object)x509CertInfo, "issuer", x500Name);
            }
            throw invocationTargetException;
        }
        CERT_INFO_SET_METHOD.invoke((Object)x509CertInfo, "validity", new CertificateValidity(date, date2));
        CERT_INFO_SET_METHOD.invoke((Object)x509CertInfo, "key", new CertificateX509Key(keyPair.getPublic()));
        CERT_INFO_SET_METHOD.invoke((Object)x509CertInfo, "algorithmID", new CertificateAlgorithmId(AlgorithmId.get("1.2.840.113549.1.1.11")));
        X509CertImpl x509CertImpl = CERT_IMPL_CONSTRUCTOR.newInstance(x509CertInfo);
        CERT_IMPL_SIGN_METHOD.invoke((Object)x509CertImpl, privateKey, string2.equalsIgnoreCase("EC") ? "SHA256withECDSA" : "SHA256withRSA");
        CERT_INFO_SET_METHOD.invoke((Object)x509CertInfo, "algorithmID.algorithm", CERT_IMPL_GET_METHOD.invoke((Object)x509CertImpl, "x509.algorithm"));
        x509CertImpl = CERT_IMPL_CONSTRUCTOR.newInstance(x509CertInfo);
        CERT_IMPL_SIGN_METHOD.invoke((Object)x509CertImpl, privateKey, string2.equalsIgnoreCase("EC") ? "SHA256withECDSA" : "SHA256withRSA");
        x509CertImpl.verify(keyPair.getPublic());
        return SelfSignedCertificate.newSelfSignedCertificate(string, privateKey, x509CertImpl);
    }

    private OpenJdkSelfSignedCertGenerator() {
    }

    static {
        Method method = null;
        Constructor constructor = null;
        Constructor constructor2 = null;
        Method method2 = null;
        Method method3 = null;
        try {
            Object object = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    try {
                        return X509CertInfo.class.getMethod("set", String.class, Object.class);
                    }
                    catch (Throwable throwable) {
                        return throwable;
                    }
                }
            });
            if (!(object instanceof Method)) {
                throw (Throwable)object;
            }
            method = (Method)object;
            Object object2 = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    try {
                        Class<?> clazz = Class.forName("sun.security.x509.CertificateIssuerName", false, PlatformDependent.getClassLoader(OpenJdkSelfSignedCertGenerator.class));
                        return clazz.getConstructor(X500Name.class);
                    }
                    catch (Throwable throwable) {
                        return throwable;
                    }
                }
            });
            if (!(object2 instanceof Constructor)) {
                throw (Throwable)object2;
            }
            constructor = (Constructor)object2;
            Object object3 = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    try {
                        return X509CertImpl.class.getConstructor(X509CertInfo.class);
                    }
                    catch (Throwable throwable) {
                        return throwable;
                    }
                }
            });
            if (!(object3 instanceof Constructor)) {
                throw (Throwable)object3;
            }
            Object object4 = (Constructor)object3;
            constructor2 = object4;
            object4 = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    try {
                        return X509CertImpl.class.getMethod("get", String.class);
                    }
                    catch (Throwable throwable) {
                        return throwable;
                    }
                }
            });
            if (!(object4 instanceof Method)) {
                throw (Throwable)object4;
            }
            method2 = (Method)object4;
            Object object5 = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    try {
                        return X509CertImpl.class.getMethod("sign", PrivateKey.class, String.class);
                    }
                    catch (Throwable throwable) {
                        return throwable;
                    }
                }
            });
            if (!(object5 instanceof Method)) {
                throw (Throwable)object5;
            }
            method3 = (Method)object5;
        }
        catch (Throwable throwable) {
            logger.debug(OpenJdkSelfSignedCertGenerator.class.getSimpleName() + " not supported", throwable);
        }
        CERT_INFO_SET_METHOD = method;
        ISSUER_NAME_CONSTRUCTOR = constructor;
        CERT_IMPL_CONSTRUCTOR = constructor2;
        CERT_IMPL_GET_METHOD = method2;
        CERT_IMPL_SIGN_METHOD = method3;
    }
}

