/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.spdy;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import pro.gravit.repackage.io.netty.handler.codec.CharSequenceValueConverter;
import pro.gravit.repackage.io.netty.handler.codec.DefaultHeaders;
import pro.gravit.repackage.io.netty.handler.codec.HeadersUtils;
import pro.gravit.repackage.io.netty.handler.codec.spdy.SpdyCodecUtil;
import pro.gravit.repackage.io.netty.handler.codec.spdy.SpdyHeaders;
import pro.gravit.repackage.io.netty.util.AsciiString;

public class DefaultSpdyHeaders
extends DefaultHeaders<CharSequence, CharSequence, SpdyHeaders>
implements SpdyHeaders {
    private static final DefaultHeaders.NameValidator<CharSequence> SpdyNameValidator = new DefaultHeaders.NameValidator<CharSequence>(){

        @Override
        public void validateName(CharSequence charSequence) {
            SpdyCodecUtil.validateHeaderName(charSequence);
        }
    };

    public DefaultSpdyHeaders() {
        this(true);
    }

    public DefaultSpdyHeaders(boolean bl) {
        super(AsciiString.CASE_INSENSITIVE_HASHER, bl ? HeaderValueConverterAndValidator.INSTANCE : CharSequenceValueConverter.INSTANCE, bl ? SpdyNameValidator : DefaultHeaders.NameValidator.NOT_NULL);
    }

    @Override
    public String getAsString(CharSequence charSequence) {
        return HeadersUtils.getAsString(this, charSequence);
    }

    @Override
    public List<String> getAllAsString(CharSequence charSequence) {
        return HeadersUtils.getAllAsString(this, charSequence);
    }

    @Override
    public Iterator<Map.Entry<String, String>> iteratorAsString() {
        return HeadersUtils.iteratorAsString(this);
    }

    @Override
    public boolean contains(CharSequence charSequence, CharSequence charSequence2) {
        return this.contains(charSequence, charSequence2, false);
    }

    @Override
    public boolean contains(CharSequence charSequence, CharSequence charSequence2, boolean bl) {
        return this.contains(charSequence, charSequence2, bl ? AsciiString.CASE_INSENSITIVE_HASHER : AsciiString.CASE_SENSITIVE_HASHER);
    }

    private static final class HeaderValueConverterAndValidator
    extends CharSequenceValueConverter {
        public static final HeaderValueConverterAndValidator INSTANCE = new HeaderValueConverterAndValidator();

        private HeaderValueConverterAndValidator() {
        }

        @Override
        public CharSequence convertObject(Object object) {
            CharSequence charSequence = super.convertObject(object);
            SpdyCodecUtil.validateHeaderValue(charSequence);
            return charSequence;
        }
    }
}

