/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.channel;

import pro.gravit.repackage.io.netty.channel.Channel;
import pro.gravit.repackage.io.netty.channel.ChannelFuture;
import pro.gravit.repackage.io.netty.channel.ChannelHandlerContext;
import pro.gravit.repackage.io.netty.channel.ChannelOutboundInvoker;
import pro.gravit.repackage.io.netty.channel.ChannelPromise;
import pro.gravit.repackage.io.netty.channel.PendingBytesTracker;
import pro.gravit.repackage.io.netty.channel.VoidChannelPromise;
import pro.gravit.repackage.io.netty.util.ReferenceCountUtil;
import pro.gravit.repackage.io.netty.util.concurrent.EventExecutor;
import pro.gravit.repackage.io.netty.util.concurrent.PromiseCombiner;
import pro.gravit.repackage.io.netty.util.internal.ObjectPool;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;
import pro.gravit.repackage.io.netty.util.internal.SystemPropertyUtil;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLogger;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLoggerFactory;

public final class PendingWriteQueue {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(PendingWriteQueue.class);
    private static final int PENDING_WRITE_OVERHEAD = SystemPropertyUtil.getInt("pro.gravit.repackage.io.netty.transport.pendingWriteSizeOverhead", 64);
    private final ChannelOutboundInvoker invoker;
    private final EventExecutor executor;
    private final PendingBytesTracker tracker;
    private PendingWrite head;
    private PendingWrite tail;
    private int size;
    private long bytes;

    public PendingWriteQueue(ChannelHandlerContext channelHandlerContext) {
        this.tracker = PendingBytesTracker.newTracker(channelHandlerContext.channel());
        this.invoker = channelHandlerContext;
        this.executor = channelHandlerContext.executor();
    }

    public PendingWriteQueue(Channel channel) {
        this.tracker = PendingBytesTracker.newTracker(channel);
        this.invoker = channel;
        this.executor = channel.eventLoop();
    }

    public boolean isEmpty() {
        assert (this.executor.inEventLoop());
        return this.head == null;
    }

    public int size() {
        assert (this.executor.inEventLoop());
        return this.size;
    }

    public long bytes() {
        assert (this.executor.inEventLoop());
        return this.bytes;
    }

    private int size(Object object) {
        int n = this.tracker.size(object);
        if (n < 0) {
            n = 0;
        }
        return n + PENDING_WRITE_OVERHEAD;
    }

    public void add(Object object, ChannelPromise channelPromise) {
        assert (this.executor.inEventLoop());
        ObjectUtil.checkNotNull(object, "msg");
        ObjectUtil.checkNotNull(channelPromise, "promise");
        int n = this.size(object);
        PendingWrite pendingWrite = PendingWrite.newInstance(object, n, channelPromise);
        PendingWrite pendingWrite2 = this.tail;
        if (pendingWrite2 == null) {
            this.tail = this.head = pendingWrite;
        } else {
            pendingWrite2.next = pendingWrite;
            this.tail = pendingWrite;
        }
        ++this.size;
        this.bytes += (long)n;
        this.tracker.incrementPendingOutboundBytes(pendingWrite.size);
    }

    public ChannelFuture removeAndWriteAll() {
        assert (this.executor.inEventLoop());
        if (this.isEmpty()) {
            return null;
        }
        ChannelPromise channelPromise = this.invoker.newPromise();
        PromiseCombiner promiseCombiner = new PromiseCombiner(this.executor);
        try {
            PendingWrite pendingWrite = this.head;
            while (pendingWrite != null) {
                this.tail = null;
                this.head = null;
                this.size = 0;
                this.bytes = 0L;
                while (pendingWrite != null) {
                    PendingWrite pendingWrite2 = pendingWrite.next;
                    Object object = pendingWrite.msg;
                    ChannelPromise channelPromise2 = pendingWrite.promise;
                    this.recycle(pendingWrite, false);
                    if (!(channelPromise2 instanceof VoidChannelPromise)) {
                        promiseCombiner.add(channelPromise2);
                    }
                    this.invoker.write(object, channelPromise2);
                    pendingWrite = pendingWrite2;
                }
                pendingWrite = this.head;
            }
            promiseCombiner.finish(channelPromise);
        }
        catch (Throwable throwable) {
            channelPromise.setFailure(throwable);
        }
        this.assertEmpty();
        return channelPromise;
    }

    public void removeAndFailAll(Throwable throwable) {
        assert (this.executor.inEventLoop());
        ObjectUtil.checkNotNull(throwable, "cause");
        PendingWrite pendingWrite = this.head;
        while (pendingWrite != null) {
            this.tail = null;
            this.head = null;
            this.size = 0;
            this.bytes = 0L;
            while (pendingWrite != null) {
                PendingWrite pendingWrite2 = pendingWrite.next;
                ReferenceCountUtil.safeRelease(pendingWrite.msg);
                ChannelPromise channelPromise = pendingWrite.promise;
                this.recycle(pendingWrite, false);
                PendingWriteQueue.safeFail(channelPromise, throwable);
                pendingWrite = pendingWrite2;
            }
            pendingWrite = this.head;
        }
        this.assertEmpty();
    }

    public void removeAndFail(Throwable throwable) {
        assert (this.executor.inEventLoop());
        ObjectUtil.checkNotNull(throwable, "cause");
        PendingWrite pendingWrite = this.head;
        if (pendingWrite == null) {
            return;
        }
        ReferenceCountUtil.safeRelease(pendingWrite.msg);
        ChannelPromise channelPromise = pendingWrite.promise;
        PendingWriteQueue.safeFail(channelPromise, throwable);
        this.recycle(pendingWrite, true);
    }

    private void assertEmpty() {
        assert (this.tail == null && this.head == null && this.size == 0);
    }

    public ChannelFuture removeAndWrite() {
        assert (this.executor.inEventLoop());
        PendingWrite pendingWrite = this.head;
        if (pendingWrite == null) {
            return null;
        }
        Object object = pendingWrite.msg;
        ChannelPromise channelPromise = pendingWrite.promise;
        this.recycle(pendingWrite, true);
        return this.invoker.write(object, channelPromise);
    }

    public ChannelPromise remove() {
        assert (this.executor.inEventLoop());
        PendingWrite pendingWrite = this.head;
        if (pendingWrite == null) {
            return null;
        }
        ChannelPromise channelPromise = pendingWrite.promise;
        ReferenceCountUtil.safeRelease(pendingWrite.msg);
        this.recycle(pendingWrite, true);
        return channelPromise;
    }

    public Object current() {
        assert (this.executor.inEventLoop());
        PendingWrite pendingWrite = this.head;
        if (pendingWrite == null) {
            return null;
        }
        return pendingWrite.msg;
    }

    private void recycle(PendingWrite pendingWrite, boolean bl) {
        PendingWrite pendingWrite2 = pendingWrite.next;
        long l = pendingWrite.size;
        if (bl) {
            if (pendingWrite2 == null) {
                this.tail = null;
                this.head = null;
                this.size = 0;
                this.bytes = 0L;
            } else {
                this.head = pendingWrite2;
                --this.size;
                this.bytes -= l;
                assert (this.size > 0 && this.bytes >= 0L);
            }
        }
        pendingWrite.recycle();
        this.tracker.decrementPendingOutboundBytes(l);
    }

    private static void safeFail(ChannelPromise channelPromise, Throwable throwable) {
        if (!(channelPromise instanceof VoidChannelPromise) && !channelPromise.tryFailure(throwable)) {
            logger.warn("Failed to mark a promise as failure because it's done already: {}", (Object)channelPromise, (Object)throwable);
        }
    }

    static final class PendingWrite {
        private static final ObjectPool<PendingWrite> RECYCLER = ObjectPool.newPool(new ObjectPool.ObjectCreator<PendingWrite>(){

            @Override
            public PendingWrite newObject(ObjectPool.Handle<PendingWrite> handle) {
                return new PendingWrite(handle);
            }
        });
        private final ObjectPool.Handle<PendingWrite> handle;
        private PendingWrite next;
        private long size;
        private ChannelPromise promise;
        private Object msg;

        private PendingWrite(ObjectPool.Handle<PendingWrite> handle) {
            this.handle = handle;
        }

        static PendingWrite newInstance(Object object, int n, ChannelPromise channelPromise) {
            PendingWrite pendingWrite = RECYCLER.get();
            pendingWrite.size = n;
            pendingWrite.msg = object;
            pendingWrite.promise = channelPromise;
            return pendingWrite;
        }

        private void recycle() {
            this.size = 0L;
            this.next = null;
            this.msg = null;
            this.promise = null;
            this.handle.recycle(this);
        }
    }
}

