/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.channel;

import java.net.SocketAddress;
import pro.gravit.repackage.io.netty.buffer.ByteBufAllocator;
import pro.gravit.repackage.io.netty.channel.Channel;
import pro.gravit.repackage.io.netty.channel.ChannelDuplexHandler;
import pro.gravit.repackage.io.netty.channel.ChannelFuture;
import pro.gravit.repackage.io.netty.channel.ChannelHandler;
import pro.gravit.repackage.io.netty.channel.ChannelHandlerContext;
import pro.gravit.repackage.io.netty.channel.ChannelInboundHandler;
import pro.gravit.repackage.io.netty.channel.ChannelOutboundHandler;
import pro.gravit.repackage.io.netty.channel.ChannelPipeline;
import pro.gravit.repackage.io.netty.channel.ChannelPipelineException;
import pro.gravit.repackage.io.netty.channel.ChannelProgressivePromise;
import pro.gravit.repackage.io.netty.channel.ChannelPromise;
import pro.gravit.repackage.io.netty.util.Attribute;
import pro.gravit.repackage.io.netty.util.AttributeKey;
import pro.gravit.repackage.io.netty.util.concurrent.EventExecutor;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;
import pro.gravit.repackage.io.netty.util.internal.ThrowableUtil;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLogger;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLoggerFactory;

public class CombinedChannelDuplexHandler<I extends ChannelInboundHandler, O extends ChannelOutboundHandler>
extends ChannelDuplexHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(CombinedChannelDuplexHandler.class);
    private DelegatingChannelHandlerContext inboundCtx;
    private DelegatingChannelHandlerContext outboundCtx;
    private volatile boolean handlerAdded;
    private I inboundHandler;
    private O outboundHandler;

    protected CombinedChannelDuplexHandler() {
        this.ensureNotSharable();
    }

    public CombinedChannelDuplexHandler(I i, O o) {
        this.ensureNotSharable();
        this.init(i, o);
    }

    protected final void init(I i, O o) {
        this.validate(i, o);
        this.inboundHandler = i;
        this.outboundHandler = o;
    }

    private void validate(I i, O o) {
        if (this.inboundHandler != null) {
            throw new IllegalStateException("init() can not be invoked if " + CombinedChannelDuplexHandler.class.getSimpleName() + " was constructed with non-default constructor.");
        }
        ObjectUtil.checkNotNull(i, "inboundHandler");
        ObjectUtil.checkNotNull(o, "outboundHandler");
        if (i instanceof ChannelOutboundHandler) {
            throw new IllegalArgumentException("inboundHandler must not implement " + ChannelOutboundHandler.class.getSimpleName() + " to get combined.");
        }
        if (o instanceof ChannelInboundHandler) {
            throw new IllegalArgumentException("outboundHandler must not implement " + ChannelInboundHandler.class.getSimpleName() + " to get combined.");
        }
    }

    protected final I inboundHandler() {
        return this.inboundHandler;
    }

    protected final O outboundHandler() {
        return this.outboundHandler;
    }

    private void checkAdded() {
        if (!this.handlerAdded) {
            throw new IllegalStateException("handler not added to pipeline yet");
        }
    }

    public final void removeInboundHandler() {
        this.checkAdded();
        this.inboundCtx.remove();
    }

    public final void removeOutboundHandler() {
        this.checkAdded();
        this.outboundCtx.remove();
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) throws Exception {
        if (this.inboundHandler == null) {
            throw new IllegalStateException("init() must be invoked before being added to a " + ChannelPipeline.class.getSimpleName() + " if " + CombinedChannelDuplexHandler.class.getSimpleName() + " was constructed with the default constructor.");
        }
        this.outboundCtx = new DelegatingChannelHandlerContext(channelHandlerContext, (ChannelHandler)this.outboundHandler);
        this.inboundCtx = new DelegatingChannelHandlerContext(channelHandlerContext, (ChannelHandler)this.inboundHandler){

            @Override
            public ChannelHandlerContext fireExceptionCaught(Throwable throwable) {
                if (!((CombinedChannelDuplexHandler)CombinedChannelDuplexHandler.this).outboundCtx.removed) {
                    try {
                        CombinedChannelDuplexHandler.this.outboundHandler.exceptionCaught(CombinedChannelDuplexHandler.this.outboundCtx, throwable);
                    }
                    catch (Throwable throwable2) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("An exception {}was thrown by a user handler's exceptionCaught() method while handling the following exception:", (Object)ThrowableUtil.stackTraceToString(throwable2), (Object)throwable);
                        } else if (logger.isWarnEnabled()) {
                            logger.warn("An exception '{}' [enable DEBUG level for full stacktrace] was thrown by a user handler's exceptionCaught() method while handling the following exception:", (Object)throwable2, (Object)throwable);
                        }
                    }
                } else {
                    super.fireExceptionCaught(throwable);
                }
                return this;
            }
        };
        this.handlerAdded = true;
        try {
            this.inboundHandler.handlerAdded(this.inboundCtx);
        }
        finally {
            this.outboundHandler.handlerAdded(this.outboundCtx);
        }
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext channelHandlerContext) throws Exception {
        try {
            this.inboundCtx.remove();
        }
        finally {
            this.outboundCtx.remove();
        }
    }

    @Override
    public void channelRegistered(ChannelHandlerContext channelHandlerContext) throws Exception {
        assert (channelHandlerContext == this.inboundCtx.ctx);
        if (!this.inboundCtx.removed) {
            this.inboundHandler.channelRegistered(this.inboundCtx);
        } else {
            this.inboundCtx.fireChannelRegistered();
        }
    }

    @Override
    public void channelUnregistered(ChannelHandlerContext channelHandlerContext) throws Exception {
        assert (channelHandlerContext == this.inboundCtx.ctx);
        if (!this.inboundCtx.removed) {
            this.inboundHandler.channelUnregistered(this.inboundCtx);
        } else {
            this.inboundCtx.fireChannelUnregistered();
        }
    }

    @Override
    public void channelActive(ChannelHandlerContext channelHandlerContext) throws Exception {
        assert (channelHandlerContext == this.inboundCtx.ctx);
        if (!this.inboundCtx.removed) {
            this.inboundHandler.channelActive(this.inboundCtx);
        } else {
            this.inboundCtx.fireChannelActive();
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext channelHandlerContext) throws Exception {
        assert (channelHandlerContext == this.inboundCtx.ctx);
        if (!this.inboundCtx.removed) {
            this.inboundHandler.channelInactive(this.inboundCtx);
        } else {
            this.inboundCtx.fireChannelInactive();
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) throws Exception {
        assert (channelHandlerContext == this.inboundCtx.ctx);
        if (!this.inboundCtx.removed) {
            this.inboundHandler.exceptionCaught(this.inboundCtx, throwable);
        } else {
            this.inboundCtx.fireExceptionCaught(throwable);
        }
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext channelHandlerContext, Object object) throws Exception {
        assert (channelHandlerContext == this.inboundCtx.ctx);
        if (!this.inboundCtx.removed) {
            this.inboundHandler.userEventTriggered(this.inboundCtx, object);
        } else {
            this.inboundCtx.fireUserEventTriggered(object);
        }
    }

    @Override
    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) throws Exception {
        assert (channelHandlerContext == this.inboundCtx.ctx);
        if (!this.inboundCtx.removed) {
            this.inboundHandler.channelRead(this.inboundCtx, object);
        } else {
            this.inboundCtx.fireChannelRead(object);
        }
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext channelHandlerContext) throws Exception {
        assert (channelHandlerContext == this.inboundCtx.ctx);
        if (!this.inboundCtx.removed) {
            this.inboundHandler.channelReadComplete(this.inboundCtx);
        } else {
            this.inboundCtx.fireChannelReadComplete();
        }
    }

    @Override
    public void channelWritabilityChanged(ChannelHandlerContext channelHandlerContext) throws Exception {
        assert (channelHandlerContext == this.inboundCtx.ctx);
        if (!this.inboundCtx.removed) {
            this.inboundHandler.channelWritabilityChanged(this.inboundCtx);
        } else {
            this.inboundCtx.fireChannelWritabilityChanged();
        }
    }

    @Override
    public void bind(ChannelHandlerContext channelHandlerContext, SocketAddress socketAddress, ChannelPromise channelPromise) throws Exception {
        assert (channelHandlerContext == this.outboundCtx.ctx);
        if (!this.outboundCtx.removed) {
            this.outboundHandler.bind(this.outboundCtx, socketAddress, channelPromise);
        } else {
            this.outboundCtx.bind(socketAddress, channelPromise);
        }
    }

    @Override
    public void connect(ChannelHandlerContext channelHandlerContext, SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) throws Exception {
        assert (channelHandlerContext == this.outboundCtx.ctx);
        if (!this.outboundCtx.removed) {
            this.outboundHandler.connect(this.outboundCtx, socketAddress, socketAddress2, channelPromise);
        } else {
            this.outboundCtx.connect(socketAddress, socketAddress2, channelPromise);
        }
    }

    @Override
    public void disconnect(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) throws Exception {
        assert (channelHandlerContext == this.outboundCtx.ctx);
        if (!this.outboundCtx.removed) {
            this.outboundHandler.disconnect(this.outboundCtx, channelPromise);
        } else {
            this.outboundCtx.disconnect(channelPromise);
        }
    }

    @Override
    public void close(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) throws Exception {
        assert (channelHandlerContext == this.outboundCtx.ctx);
        if (!this.outboundCtx.removed) {
            this.outboundHandler.close(this.outboundCtx, channelPromise);
        } else {
            this.outboundCtx.close(channelPromise);
        }
    }

    @Override
    public void deregister(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) throws Exception {
        assert (channelHandlerContext == this.outboundCtx.ctx);
        if (!this.outboundCtx.removed) {
            this.outboundHandler.deregister(this.outboundCtx, channelPromise);
        } else {
            this.outboundCtx.deregister(channelPromise);
        }
    }

    @Override
    public void read(ChannelHandlerContext channelHandlerContext) throws Exception {
        assert (channelHandlerContext == this.outboundCtx.ctx);
        if (!this.outboundCtx.removed) {
            this.outboundHandler.read(this.outboundCtx);
        } else {
            this.outboundCtx.read();
        }
    }

    @Override
    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) throws Exception {
        assert (channelHandlerContext == this.outboundCtx.ctx);
        if (!this.outboundCtx.removed) {
            this.outboundHandler.write(this.outboundCtx, object, channelPromise);
        } else {
            this.outboundCtx.write(object, channelPromise);
        }
    }

    @Override
    public void flush(ChannelHandlerContext channelHandlerContext) throws Exception {
        assert (channelHandlerContext == this.outboundCtx.ctx);
        if (!this.outboundCtx.removed) {
            this.outboundHandler.flush(this.outboundCtx);
        } else {
            this.outboundCtx.flush();
        }
    }

    private static class DelegatingChannelHandlerContext
    implements ChannelHandlerContext {
        private final ChannelHandlerContext ctx;
        private final ChannelHandler handler;
        boolean removed;

        DelegatingChannelHandlerContext(ChannelHandlerContext channelHandlerContext, ChannelHandler channelHandler) {
            this.ctx = channelHandlerContext;
            this.handler = channelHandler;
        }

        @Override
        public Channel channel() {
            return this.ctx.channel();
        }

        @Override
        public EventExecutor executor() {
            return this.ctx.executor();
        }

        @Override
        public String name() {
            return this.ctx.name();
        }

        @Override
        public ChannelHandler handler() {
            return this.ctx.handler();
        }

        @Override
        public boolean isRemoved() {
            return this.removed || this.ctx.isRemoved();
        }

        @Override
        public ChannelHandlerContext fireChannelRegistered() {
            this.ctx.fireChannelRegistered();
            return this;
        }

        @Override
        public ChannelHandlerContext fireChannelUnregistered() {
            this.ctx.fireChannelUnregistered();
            return this;
        }

        @Override
        public ChannelHandlerContext fireChannelActive() {
            this.ctx.fireChannelActive();
            return this;
        }

        @Override
        public ChannelHandlerContext fireChannelInactive() {
            this.ctx.fireChannelInactive();
            return this;
        }

        @Override
        public ChannelHandlerContext fireExceptionCaught(Throwable throwable) {
            this.ctx.fireExceptionCaught(throwable);
            return this;
        }

        @Override
        public ChannelHandlerContext fireUserEventTriggered(Object object) {
            this.ctx.fireUserEventTriggered(object);
            return this;
        }

        @Override
        public ChannelHandlerContext fireChannelRead(Object object) {
            this.ctx.fireChannelRead(object);
            return this;
        }

        @Override
        public ChannelHandlerContext fireChannelReadComplete() {
            this.ctx.fireChannelReadComplete();
            return this;
        }

        @Override
        public ChannelHandlerContext fireChannelWritabilityChanged() {
            this.ctx.fireChannelWritabilityChanged();
            return this;
        }

        @Override
        public ChannelFuture bind(SocketAddress socketAddress) {
            return this.ctx.bind(socketAddress);
        }

        @Override
        public ChannelFuture connect(SocketAddress socketAddress) {
            return this.ctx.connect(socketAddress);
        }

        @Override
        public ChannelFuture connect(SocketAddress socketAddress, SocketAddress socketAddress2) {
            return this.ctx.connect(socketAddress, socketAddress2);
        }

        @Override
        public ChannelFuture disconnect() {
            return this.ctx.disconnect();
        }

        @Override
        public ChannelFuture close() {
            return this.ctx.close();
        }

        @Override
        public ChannelFuture deregister() {
            return this.ctx.deregister();
        }

        @Override
        public ChannelFuture bind(SocketAddress socketAddress, ChannelPromise channelPromise) {
            return this.ctx.bind(socketAddress, channelPromise);
        }

        @Override
        public ChannelFuture connect(SocketAddress socketAddress, ChannelPromise channelPromise) {
            return this.ctx.connect(socketAddress, channelPromise);
        }

        @Override
        public ChannelFuture connect(SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
            return this.ctx.connect(socketAddress, socketAddress2, channelPromise);
        }

        @Override
        public ChannelFuture disconnect(ChannelPromise channelPromise) {
            return this.ctx.disconnect(channelPromise);
        }

        @Override
        public ChannelFuture close(ChannelPromise channelPromise) {
            return this.ctx.close(channelPromise);
        }

        @Override
        public ChannelFuture deregister(ChannelPromise channelPromise) {
            return this.ctx.deregister(channelPromise);
        }

        @Override
        public ChannelHandlerContext read() {
            this.ctx.read();
            return this;
        }

        @Override
        public ChannelFuture write(Object object) {
            return this.ctx.write(object);
        }

        @Override
        public ChannelFuture write(Object object, ChannelPromise channelPromise) {
            return this.ctx.write(object, channelPromise);
        }

        @Override
        public ChannelHandlerContext flush() {
            this.ctx.flush();
            return this;
        }

        @Override
        public ChannelFuture writeAndFlush(Object object, ChannelPromise channelPromise) {
            return this.ctx.writeAndFlush(object, channelPromise);
        }

        @Override
        public ChannelFuture writeAndFlush(Object object) {
            return this.ctx.writeAndFlush(object);
        }

        @Override
        public ChannelPipeline pipeline() {
            return this.ctx.pipeline();
        }

        @Override
        public ByteBufAllocator alloc() {
            return this.ctx.alloc();
        }

        @Override
        public ChannelPromise newPromise() {
            return this.ctx.newPromise();
        }

        @Override
        public ChannelProgressivePromise newProgressivePromise() {
            return this.ctx.newProgressivePromise();
        }

        @Override
        public ChannelFuture newSucceededFuture() {
            return this.ctx.newSucceededFuture();
        }

        @Override
        public ChannelFuture newFailedFuture(Throwable throwable) {
            return this.ctx.newFailedFuture(throwable);
        }

        @Override
        public ChannelPromise voidPromise() {
            return this.ctx.voidPromise();
        }

        @Override
        public <T> Attribute<T> attr(AttributeKey<T> attributeKey) {
            return this.ctx.channel().attr(attributeKey);
        }

        @Override
        public <T> boolean hasAttr(AttributeKey<T> attributeKey) {
            return this.ctx.channel().hasAttr(attributeKey);
        }

        final void remove() {
            EventExecutor eventExecutor = this.executor();
            if (eventExecutor.inEventLoop()) {
                this.remove0();
            } else {
                eventExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        DelegatingChannelHandlerContext.this.remove0();
                    }
                });
            }
        }

        private void remove0() {
            if (!this.removed) {
                this.removed = true;
                try {
                    this.handler.handlerRemoved(this);
                }
                catch (Throwable throwable) {
                    this.fireExceptionCaught(new ChannelPipelineException(this.handler.getClass().getName() + ".handlerRemoved() has thrown an exception.", throwable));
                }
            }
        }
    }
}

