/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.buffer.search;

import pro.gravit.repackage.io.netty.buffer.search.AbstractSearchProcessorFactory;
import pro.gravit.repackage.io.netty.buffer.search.SearchProcessor;
import pro.gravit.repackage.io.netty.util.internal.PlatformDependent;

public class BitapSearchProcessorFactory
extends AbstractSearchProcessorFactory {
    private final long[] bitMasks = new long[256];
    private final long successBit;

    BitapSearchProcessorFactory(byte[] byArray) {
        if (byArray.length > 64) {
            throw new IllegalArgumentException("Maximum supported search pattern length is 64, got " + byArray.length);
        }
        long l = 1L;
        for (byte by : byArray) {
            int n = by & 0xFF;
            this.bitMasks[n] = this.bitMasks[n] | l;
            l <<= 1;
        }
        this.successBit = 1L << byArray.length - 1;
    }

    @Override
    public Processor newSearchProcessor() {
        return new Processor(this.bitMasks, this.successBit);
    }

    public static class Processor
    implements SearchProcessor {
        private final long[] bitMasks;
        private final long successBit;
        private long currentMask;

        Processor(long[] lArray, long l) {
            this.bitMasks = lArray;
            this.successBit = l;
        }

        @Override
        public boolean process(byte by) {
            this.currentMask = (this.currentMask << 1 | 1L) & PlatformDependent.getLong(this.bitMasks, (long)by & 0xFFL);
            return (this.currentMask & this.successBit) == 0L;
        }

        @Override
        public void reset() {
            this.currentMask = 0L;
        }
    }
}

