/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchermodules.discordgame;

import de.jcm.discordgamesdk.Core;
import de.jcm.discordgamesdk.CreateParams;
import de.jcm.discordgamesdk.GameSDKException;
import de.jcm.discordgamesdk.activity.Activity;
import java.io.IOException;
import java.nio.file.Path;
import pro.gravit.launcher.LauncherEngine;
import pro.gravit.launcher.client.DirBridge;
import pro.gravit.launcher.client.api.DiscordActivityService;
import pro.gravit.launchermodules.discordgame.DiscordUpdateTask;
import pro.gravit.launchermodules.discordgame.event.DiscordInitEvent;
import pro.gravit.utils.helper.CommonHelper;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.UnpackHelper;

public class DiscordBridge {
    public static final DiscordActivityService activityService = new DiscordActivityService();
    private static Thread thread;
    private static Core core;
    private static CreateParams params;
    private static Activity activity;

    private static void initCore() throws IOException {
        Path path = DirBridge.getGuardDir(JVMHelper.ARCH_TYPE, JVMHelper.OS_TYPE);
        String string = "";
        switch (JVMHelper.OS_TYPE) {
            case MUSTDIE: {
                string = "windows";
                break;
            }
            case LINUX: {
                string = "linux";
                break;
            }
            case MACOSX: {
                string = "macos";
            }
        }
        String string2 = JVMHelper.ARCH_TYPE == JVMHelper.ARCH.X86_64 ? "amd64" : JVMHelper.ARCH_TYPE.name;
        DiscordBridge.loadNative(path, "discord_game_sdk_jni", string, string2);
        Core.initDiscordNative(DiscordBridge.loadNative(path, "discord_game_sdk", string, string2));
    }

    public static void init(long l) throws IOException {
        if (JVMHelper.ARCH_TYPE == JVMHelper.ARCH.ARM32 || JVMHelper.ARCH_TYPE == JVMHelper.ARCH.ARM64) {
            LogHelper.info("Cannot initialize Discord Game SDK because of launcher started at unsupported system && arch");
            return;
        }
        DiscordBridge.initCore();
        params = new CreateParams();
        params.setClientID(l);
        params.setFlags(CreateParams.getDefaultFlags() | 1L);
        try {
            core = new Core(params);
            activity = new Activity();
            activityService.applyToActivity(activity);
            activityService.resetStartTime();
            core.activityManager().updateActivity(DiscordBridge.getActivity());
        }
        catch (GameSDKException gameSDKException) {
            LogHelper.info("Failed to start Discord Game SDK. Most surely because local discord app is down");
            DiscordBridge.close();
            return;
        }
        LauncherEngine.modulesManager.invokeEvent(new DiscordInitEvent(core));
        LogHelper.debug("Initialized Discord Game. Application ID %d", l);
        thread = CommonHelper.newThread("DiscordGameBridge callbacks", true, new DiscordUpdateTask(core));
        thread.start();
    }

    public static Core getCore() {
        return core;
    }

    public static Activity getActivity() {
        return activity;
    }

    public static void close() {
        if (thread != null) {
            thread.interrupt();
        }
        if (core != null) {
            try {
                core.close();
            }
            catch (Throwable throwable) {
                if (LogHelper.isDebugEnabled()) {
                    LogHelper.error(throwable);
                }
                LogHelper.warning("DiscordGame core object not closed correctly. Discord is down?");
            }
        }
        if (params != null) {
            try {
                params.close();
            }
            catch (Throwable throwable) {
                if (LogHelper.isDebugEnabled()) {
                    LogHelper.error(throwable);
                }
                LogHelper.warning("DiscordGame params object not closed correctly. Discord is down?");
            }
        }
    }

    private static String loadNative(Path path, String string, String string2, String string3) throws IOException {
        String string4 = JVMHelper.NATIVE_PREFIX.concat(string).concat(JVMHelper.NATIVE_EXTENSION);
        Path path2 = path.resolve(string4);
        String string5 = String.join((CharSequence)"/", "native", string2, string3, string4);
        UnpackHelper.unpack(IOHelper.getResourceURL(string5), path2);
        System.load(path2.toAbsolutePath().toString());
        return path2.toAbsolutePath().toString();
    }
}

