/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.managers;

import java.io.IOException;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.LauncherEngine;
import pro.gravit.launcher.client.events.ClientUnlockConsoleEvent;
import pro.gravit.launcher.console.UnlockCommand;
import pro.gravit.launcher.console.test.PrintHardwareInfoCommand;
import pro.gravit.utils.command.CommandHandler;
import pro.gravit.utils.command.JLineCommandHandler;
import pro.gravit.utils.command.StdCommandHandler;
import pro.gravit.utils.command.basic.ClearCommand;
import pro.gravit.utils.command.basic.DebugCommand;
import pro.gravit.utils.command.basic.GCCommand;
import pro.gravit.utils.command.basic.HelpCommand;
import pro.gravit.utils.helper.CommonHelper;
import pro.gravit.utils.helper.LogHelper;

public class ConsoleManager {
    public static CommandHandler handler;
    public static Thread thread;
    public static boolean isConsoleUnlock;

    public static void initConsole() throws IOException {
        CommandHandler commandHandler;
        try {
            Class.forName("org.jline.terminal.Terminal");
            commandHandler = new JLineCommandHandler();
            LogHelper.info("JLine2 terminal enabled");
        }
        catch (ClassNotFoundException classNotFoundException) {
            commandHandler = new StdCommandHandler(true);
            LogHelper.warning("JLine2 isn't in classpath, using std");
        }
        handler = commandHandler;
        ConsoleManager.registerCommands();
        thread = CommonHelper.newThread("Launcher Console", true, handler);
        thread.start();
    }

    public static void registerCommands() {
        handler.registerCommand("help", new HelpCommand(handler));
        handler.registerCommand("gc", new GCCommand());
        handler.registerCommand("clear", new ClearCommand(handler));
        handler.registerCommand("unlock", new UnlockCommand());
        handler.registerCommand("printhardware", new PrintHardwareInfoCommand());
    }

    public static boolean checkUnlockKey(String string) {
        return string.equals(Launcher.getConfig().unlockSecret);
    }

    public static boolean unlock() {
        if (isConsoleUnlock) {
            return true;
        }
        ClientUnlockConsoleEvent clientUnlockConsoleEvent = new ClientUnlockConsoleEvent(handler);
        LauncherEngine.modulesManager.invokeEvent(clientUnlockConsoleEvent);
        if (clientUnlockConsoleEvent.isCancel()) {
            return false;
        }
        handler.registerCommand("debug", new DebugCommand());
        handler.unregisterCommand("unlock");
        isConsoleUnlock = true;
        return true;
    }

    static {
        isConsoleUnlock = false;
    }
}

