/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.managers;

import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Objects;
import pro.gravit.launcher.config.JsonConfigurable;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.VerifyHelper;

public class ConfigManager {
    private final HashMap<String, JsonConfigurable> CONFIGURABLE = new HashMap();

    public void registerConfigurable(String string, JsonConfigurable jsonConfigurable) {
        VerifyHelper.putIfAbsent(this.CONFIGURABLE, string.toLowerCase(), Objects.requireNonNull(jsonConfigurable, "adapter"), String.format("Reloadable has been already registered: '%s'", string));
    }

    public void printConfigurables() {
        LogHelper.info("Print configurables");
        this.CONFIGURABLE.forEach((string, jsonConfigurable) -> LogHelper.subInfo(string));
        LogHelper.info("Found %d configurables", this.CONFIGURABLE.size());
    }

    public void save(String string) throws IOException {
        this.CONFIGURABLE.get(string).saveConfig();
    }

    public void load(String string) throws IOException {
        this.CONFIGURABLE.get(string).loadConfig();
    }

    public void save(String string, Path path) throws IOException {
        this.CONFIGURABLE.get(string).saveConfig(path);
    }

    public void reset(String string) throws IOException {
        this.CONFIGURABLE.get(string).resetConfig();
    }

    public void load(String string, Path path) throws IOException {
        this.CONFIGURABLE.get(string).loadConfig(path);
    }

    public void reset(String string, Path path) throws IOException {
        this.CONFIGURABLE.get(string).resetConfig(path);
    }
}

