/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.service;

import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import pro.gravit.launcher.ClientPermissions;
import pro.gravit.launcher.client.DirBridge;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.events.request.AuthRequestEvent;
import pro.gravit.launcher.events.request.ProfilesRequestEvent;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.launcher.profiles.PlayerProfile;
import pro.gravit.launcher.profiles.Texture;
import pro.gravit.launcher.request.Request;
import pro.gravit.launcher.request.auth.AuthRequest;
import pro.gravit.launcher.request.update.ProfilesRequest;
import pro.gravit.launcher.request.websockets.OfflineRequestService;
import pro.gravit.utils.helper.SecurityHelper;

public class OfflineService {
    private final JavaFXApplication application;

    public OfflineService(JavaFXApplication javaFXApplication) {
        this.application = javaFXApplication;
    }

    public boolean isAvailableOfflineMode() {
        if (this.application.guiModuleConfig.disableOfflineMode) {
            return false;
        }
        return this.application.runtimeSettings.profiles != null;
    }

    public boolean isOfflineMode() {
        return Request.getRequestService() instanceof OfflineRequestService;
    }

    public static void applyRuntimeProcessors(OfflineRequestService offlineRequestService) {
        offlineRequestService.registerRequestProcessor(AuthRequest.class, authRequest -> new AuthRequestEvent(new ClientPermissions(), new PlayerProfile(UUID.nameUUIDFromBytes(authRequest.login.getBytes(StandardCharsets.UTF_8)), authRequest.login, new HashMap<String, Texture>(), new HashMap<String, String>()), SecurityHelper.randomStringToken(), "", null, new AuthRequestEvent.OAuthRequestEvent(SecurityHelper.randomStringToken(), null, 0L)));
        offlineRequestService.registerRequestProcessor(ProfilesRequest.class, profilesRequest -> {
            JavaFXApplication javaFXApplication = JavaFXApplication.getInstance();
            List<ClientProfile> list = javaFXApplication.runtimeSettings.profiles.stream().filter(clientProfile -> Files.exists(DirBridge.dirUpdates.resolve(clientProfile.getDir()), new LinkOption[0]) && Files.exists(DirBridge.dirUpdates.resolve(clientProfile.getAssetDir()), new LinkOption[0])).collect(Collectors.toList());
            return new ProfilesRequestEvent(list);
        });
    }
}

