/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.scenes.update;

import java.nio.file.Path;
import java.util.function.Consumer;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.TextArea;
import javafx.scene.text.Text;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.client.gui.helper.LookupHelper;
import pro.gravit.launcher.client.gui.scenes.AbstractScene;
import pro.gravit.launcher.client.gui.scenes.update.VisualDownloader;
import pro.gravit.launcher.hasher.FileNameMatcher;
import pro.gravit.launcher.hasher.HashedDir;
import pro.gravit.launcher.profiles.optional.OptionalView;
import pro.gravit.utils.helper.LogHelper;

public class UpdateScene
extends AbstractScene {
    private ProgressBar progressBar;
    private Text speed;
    private Label volume;
    private TextArea logOutput;
    private Text currentStatus;
    private Button reload;
    private Button cancel;
    private Text speedtext;
    private Text speederr;
    private VisualDownloader downloader;

    public UpdateScene(JavaFXApplication javaFXApplication) {
        super("scenes/update/update.fxml", javaFXApplication);
    }

    @Override
    protected void doInit() {
        this.progressBar = (ProgressBar)LookupHelper.lookup((Node)this.layout, "#progress");
        this.speed = (Text)LookupHelper.lookup((Node)this.layout, "#speed");
        this.speederr = (Text)LookupHelper.lookup((Node)this.layout, "#speedErr");
        this.speedtext = (Text)LookupHelper.lookup((Node)this.layout, "#speed-text");
        this.reload = (Button)LookupHelper.lookup((Node)this.layout, "#reload");
        this.cancel = (Button)LookupHelper.lookup((Node)this.layout, "#cancel");
        this.volume = (Label)LookupHelper.lookup((Node)this.layout, "#volume");
        this.logOutput = (TextArea)LookupHelper.lookup((Node)this.layout, "#outputUpdate");
        this.currentStatus = (Text)LookupHelper.lookup((Node)this.layout, "#headingUpdate");
        this.logOutput.setText("");
        this.downloader = new VisualDownloader(this.application, this.progressBar, this.speed, this.volume, this::errorHandle, string -> this.contextHelper.runInFxThread(() -> this.addLog((String)string)));
        ((ButtonBase)LookupHelper.lookup((Node)this.layout, "#reload")).setOnAction(actionEvent -> this.reset());
        ((ButtonBase)LookupHelper.lookup((Node)this.layout, "#cancel")).setOnAction(actionEvent -> {
            if (this.downloader.isDownload()) {
                this.downloader.cancel();
            } else {
                try {
                    this.switchScene(this.application.gui.serverInfoScene);
                }
                catch (Exception exception) {
                    this.errorHandle(exception);
                }
            }
        });
    }

    public void sendUpdateAssetRequest(String string, Path path, FileNameMatcher fileNameMatcher, boolean bl, String string2, Consumer<HashedDir> consumer) {
        this.downloader.sendUpdateAssetRequest(string, path, fileNameMatcher, bl, string2, consumer);
    }

    public void sendUpdateRequest(String string, Path path, FileNameMatcher fileNameMatcher, boolean bl, OptionalView optionalView, boolean bl2, Consumer<HashedDir> consumer) {
        this.downloader.sendUpdateRequest(string, path, fileNameMatcher, bl, optionalView, bl2, consumer);
    }

    public void addLog(String string) {
        LogHelper.dev("Update event %s", string);
        this.logOutput.appendText(string.concat("\n"));
    }

    @Override
    public void reset() {
        this.progressBar.progressProperty().setValue((Number)0);
        this.logOutput.clear();
        this.volume.setText("");
        this.speed.setText("0");
        this.cancel.setDisable(false);
        this.cancel.setStyle("-fx-opacity: 1");
        this.progressBar.getStyleClass().removeAll((Object[])new String[]{"progress"});
        this.speed.getStyleClass().removeAll((Object[])new String[]{"speedError"});
        this.speed.setStyle("-fx-opacity: 1");
        this.speedtext.setStyle("-fx-opacity: 1");
        this.speederr.setStyle("-fx-opacity: 0");
    }

    @Override
    public void errorHandle(Throwable throwable) {
        this.addLog(String.format("Exception %s: %s", throwable.getClass(), throwable.getMessage() == null ? "" : throwable.getMessage()));
        this.progressBar.getStyleClass().add((Object)"progressError");
        this.speed.setStyle("-fx-opacity: 0");
        this.speedtext.setStyle("-fx-opacity: 0");
        this.speederr.setStyle("-fx-opacity: 1");
        LogHelper.error(throwable);
        this.cancel.setDisable(true);
        this.cancel.setStyle("-fx-opacity: 0");
    }

    @Override
    public String getName() {
        return "update";
    }
}

