/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.scenes.servermenu;

import java.net.URL;
import java.util.concurrent.atomic.AtomicLong;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Labeled;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.shape.Rectangle;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.client.gui.helper.LookupHelper;
import pro.gravit.launcher.client.gui.impl.AbstractVisualComponent;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.utils.helper.LogHelper;

public class ServerButtonComponent
extends AbstractVisualComponent {
    private static final String SERVER_BUTTON_FXML = "components/serverButton.fxml";
    private static final String SERVER_BUTTON_CUSTOM_FXML = "components/serverButton/%s.fxml";
    public ClientProfile profile;
    private Button saveButton;
    private Button resetButton;

    protected ServerButtonComponent(JavaFXApplication javaFXApplication, ClientProfile clientProfile) {
        super(ServerButtonComponent.getFXMLPath(javaFXApplication, clientProfile), javaFXApplication);
        this.profile = clientProfile;
    }

    private static String getFXMLPath(JavaFXApplication javaFXApplication, ClientProfile clientProfile) {
        String string = String.format(SERVER_BUTTON_CUSTOM_FXML, clientProfile.getUUID());
        URL uRL = javaFXApplication.tryResource(string);
        if (uRL != null) {
            return string;
        }
        return SERVER_BUTTON_FXML;
    }

    @Override
    public String getName() {
        return "serverButton";
    }

    @Override
    protected void doInit() throws Exception {
        ((Labeled)LookupHelper.lookup((Node)this.layout, "#nameServer")).setText(this.profile.getTitle());
        ((Labeled)LookupHelper.lookup((Node)this.layout, "#genreServer")).setText(this.profile.getVersion().toString());
        LookupHelper.lookupIfPossible((Node)this.layout, "#serverLogo").ifPresent(imageView -> {
            try {
                Rectangle rectangle = new Rectangle(imageView.getFitWidth(), imageView.getFitHeight());
                rectangle.setArcWidth(20.0);
                rectangle.setArcHeight(20.0);
                imageView.setClip((Node)rectangle);
            }
            catch (Throwable throwable) {
                LogHelper.error(throwable);
            }
        });
        AtomicLong atomicLong = new AtomicLong(0L);
        AtomicLong atomicLong2 = new AtomicLong(0L);
        Runnable runnable = () -> this.contextHelper.runInFxThread(() -> {
            if (atomicLong.get() == 0L && atomicLong2.get() == 0L) {
                ((Labeled)LookupHelper.lookup((Node)this.layout, "#online")).setText("?");
            } else {
                ((Labeled)LookupHelper.lookup((Node)this.layout, "#online")).setText(String.valueOf(atomicLong.get()));
            }
        });
        for (ClientProfile.ServerProfile serverProfile : this.profile.getServers()) {
            this.application.pingService.getPingReport(serverProfile.name).thenAccept(pingServerReport -> {
                if (pingServerReport != null) {
                    atomicLong.addAndGet(pingServerReport.playersOnline);
                    atomicLong2.addAndGet(pingServerReport.maxPlayers);
                }
                runnable.run();
            });
        }
        this.saveButton = (Button)LookupHelper.lookup((Node)this.layout, "#save");
        this.resetButton = (Button)LookupHelper.lookup((Node)this.layout, "#reset");
    }

    public void setOnMouseClicked(EventHandler<? super MouseEvent> eventHandler) {
        this.layout.setOnMouseClicked(eventHandler);
    }

    public void enableSaveButton(String string, EventHandler<ActionEvent> eventHandler) {
        this.saveButton.setVisible(true);
        if (string != null) {
            this.saveButton.setText(string);
        }
        this.saveButton.setOnAction(eventHandler);
    }

    public void enableResetButton(String string, EventHandler<ActionEvent> eventHandler) {
        this.resetButton.setVisible(true);
        if (string != null) {
            this.resetButton.setText(string);
        }
        this.resetButton.setOnAction(eventHandler);
    }

    public void addTo(Pane pane) {
        if (!this.isInit()) {
            try {
                this.init();
            }
            catch (Exception exception) {
                LogHelper.error(exception);
            }
        }
        pane.getChildren().add((Object)this.layout);
    }

    public void addTo(Pane pane, int n) {
        if (!this.isInit()) {
            try {
                this.init();
            }
            catch (Exception exception) {
                LogHelper.error(exception);
            }
        }
        pane.getChildren().add(n, (Object)this.layout);
    }

    @Override
    public void reset() {
    }

    @Override
    public void disable() {
    }

    @Override
    public void enable() {
    }
}

