/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.scenes.serverinfo;

import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Consumer;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Pane;
import javafx.scene.shape.Rectangle;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.LauncherEngine;
import pro.gravit.launcher.client.ClientLauncherProcess;
import pro.gravit.launcher.client.DirBridge;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.client.gui.config.RuntimeSettings;
import pro.gravit.launcher.client.gui.helper.LookupHelper;
import pro.gravit.launcher.client.gui.impl.ContextHelper;
import pro.gravit.launcher.client.gui.scenes.AbstractScene;
import pro.gravit.launcher.client.gui.scenes.debug.DebugScene;
import pro.gravit.launcher.client.gui.scenes.servermenu.ServerButtonComponent;
import pro.gravit.launcher.client.gui.scenes.servermenu.ServerMenuScene;
import pro.gravit.launcher.hasher.HashedDir;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.launcher.profiles.ClientProfileVersions;
import pro.gravit.launcher.profiles.optional.OptionalView;
import pro.gravit.launcher.request.auth.SetProfileRequest;
import pro.gravit.utils.helper.CommonHelper;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.JavaHelper;
import pro.gravit.utils.helper.LogHelper;

public class ServerInfoScene
extends AbstractScene {
    private ImageView avatar;
    private Image originalAvatarImage;
    private ServerButtonComponent serverButton;

    public ServerInfoScene(JavaFXApplication javaFXApplication) {
        super("scenes/serverinfo/serverinfo.fxml", javaFXApplication);
    }

    @Override
    protected void doInit() throws Exception {
        this.avatar = (ImageView)LookupHelper.lookup((Node)this.layout, "#avatar");
        this.originalAvatarImage = this.avatar.getImage();
        LookupHelper.lookupIfPossible((Node)this.layout, "#avatar").ifPresent(imageView -> {
            try {
                Rectangle rectangle = new Rectangle(imageView.getFitWidth(), imageView.getFitHeight());
                rectangle.setArcWidth(imageView.getFitWidth());
                rectangle.setArcHeight(imageView.getFitHeight());
                imageView.setClip((Node)rectangle);
                imageView.setImage(this.originalAvatarImage);
            }
            catch (Throwable throwable) {
                LogHelper.warning("Skin head error");
            }
        });
        ((Button)LookupHelper.lookup((Node)this.header, "#back")).setOnAction(actionEvent -> {
            try {
                this.switchScene(this.application.gui.serverMenuScene);
            }
            catch (Exception exception) {
                this.errorHandle(exception);
            }
        });
        ((ButtonBase)LookupHelper.lookup((Node)this.header, "#controls", "#clientSettings")).setOnAction(actionEvent -> {
            try {
                if (this.application.stateService.getProfile() == null) {
                    return;
                }
                this.switchScene(this.application.gui.optionsScene);
                this.application.gui.optionsScene.reset();
                this.application.gui.optionsScene.addProfileOptionals(this.application.stateService.getOptionalView());
            }
            catch (Exception exception) {
                this.errorHandle(exception);
            }
        });
        ((ButtonBase)LookupHelper.lookup((Node)this.header, "#controls", "#settings")).setOnAction(actionEvent -> {
            try {
                this.switchScene(this.application.gui.settingsScene);
                this.application.gui.settingsScene.reset();
            }
            catch (Exception exception) {
                this.errorHandle(exception);
            }
        });
        this.reset();
    }

    @Override
    public void reset() {
        this.avatar.setImage(this.originalAvatarImage);
        ClientProfile clientProfile = this.application.stateService.getProfile();
        LookupHelper.lookupIfPossible((Node)this.layout, "#serverName").ifPresent(label -> label.setText(clientProfile.getTitle()));
        LookupHelper.lookupIfPossible((Node)this.layout, "#serverDescription").ifPresent(label -> label.setText(clientProfile.getInfo()));
        LookupHelper.lookupIfPossible((Node)this.layout, "#nickname").ifPresent(label -> label.setText(this.application.stateService.getUsername()));
        Pane pane = (Pane)LookupHelper.lookup((Node)this.layout, "#serverButton");
        pane.getChildren().clear();
        this.serverButton = ServerMenuScene.getServerButton(this.application, clientProfile);
        this.serverButton.addTo(pane);
        this.serverButton.enableSaveButton(this.application.getTranslation("runtime.scenes.serverinfo.serverButton.game"), (EventHandler<ActionEvent>)((EventHandler)actionEvent -> this.launchClient()));
        ServerMenuScene.putAvatarToImageView(this.application, this.application.stateService.getUsername(), this.avatar);
    }

    @Override
    public String getName() {
        return null;
    }

    private void downloadClients(ClientProfile clientProfile, JavaHelper.JavaVersion javaVersion, HashedDir hashedDir) {
        Path path = DirBridge.dirUpdates.resolve(clientProfile.getAssetDir());
        LogHelper.info("Start update to %s", path.toString());
        Consumer<HashedDir> consumer = hashedDir2 -> {
            Path path2 = DirBridge.dirUpdates.resolve(clientProfile.getDir());
            LogHelper.info("Start update to %s", path2.toString());
            this.application.gui.updateScene.sendUpdateRequest(clientProfile.getDir(), path2, clientProfile.getClientUpdateMatcher(), true, this.application.stateService.getOptionalView(), true, hashedDir3 -> {
                LogHelper.info("Success update");
                try {
                    this.doLaunchClient(path, (HashedDir)hashedDir2, path2, (HashedDir)hashedDir3, clientProfile, this.application.stateService.getOptionalView(), javaVersion, hashedDir);
                }
                catch (Throwable throwable) {
                    LogHelper.error(throwable);
                    ContextHelper.runInFxThreadStatic(() -> this.application.gui.updateScene.addLog(String.format("launchClient error %s:%s", throwable.getClass().getName(), throwable.getMessage())));
                }
            });
        };
        if (clientProfile.getVersion().compareTo(ClientProfileVersions.MINECRAFT_1_6_4) <= 0) {
            this.application.gui.updateScene.sendUpdateRequest(clientProfile.getAssetDir(), path, clientProfile.getAssetUpdateMatcher(), true, null, false, consumer);
        } else {
            this.application.gui.updateScene.sendUpdateAssetRequest(clientProfile.getAssetDir(), path, clientProfile.getAssetUpdateMatcher(), true, clientProfile.getAssetIndex(), consumer);
        }
    }

    private void doLaunchClient(Path path, HashedDir hashedDir, Path path2, HashedDir hashedDir2, ClientProfile clientProfile, OptionalView optionalView, JavaHelper.JavaVersion javaVersion, HashedDir hashedDir3) {
        RuntimeSettings.ProfileSettings profileSettings = this.application.getProfileSettings();
        if (javaVersion == null) {
            javaVersion = this.application.javaService.getRecommendJavaVersion(clientProfile);
        }
        if (javaVersion == null) {
            javaVersion = JavaHelper.JavaVersion.getCurrentJavaVersion();
        }
        ClientLauncherProcess clientLauncherProcess = new ClientLauncherProcess(path2, path, javaVersion, path2.resolve("resourcepacks"), clientProfile, this.application.stateService.getPlayerProfile(), optionalView, this.application.stateService.getAccessToken(), hashedDir2, hashedDir, hashedDir3);
        clientLauncherProcess.params.ram = profileSettings.ram;
        clientLauncherProcess.params.offlineMode = this.application.offlineService.isOfflineMode();
        if (clientLauncherProcess.params.ram > 0) {
            clientLauncherProcess.jvmArgs.add("-Xms" + clientLauncherProcess.params.ram + 'M');
            clientLauncherProcess.jvmArgs.add("-Xmx" + clientLauncherProcess.params.ram + 'M');
        }
        clientLauncherProcess.params.fullScreen = profileSettings.fullScreen;
        clientLauncherProcess.params.autoEnter = profileSettings.autoEnter;
        this.contextHelper.runCallback(() -> {
            Thread thread = CommonHelper.newThread("Client Params Writer Thread", true, () -> {
                block3: {
                    try {
                        clientLauncherProcess.runWriteParams(new InetSocketAddress("127.0.0.1", Launcher.getConfig().clientPort));
                        if (!profileSettings.debug) {
                            LogHelper.debug("Params writted successful. Exit...");
                            LauncherEngine.exitLauncher(0);
                        }
                    }
                    catch (Throwable throwable) {
                        LogHelper.error(throwable);
                        if (!(this.getCurrentStage().getVisualComponent() instanceof DebugScene)) break block3;
                        DebugScene debugScene = (DebugScene)this.getCurrentStage().getVisualComponent();
                        debugScene.append(String.format("Launcher fatal error(Write Params Thread): %s: %s", throwable.getClass().getName(), throwable.getMessage()));
                        if (debugScene.currentProcess == null || !debugScene.currentProcess.isAlive()) break block3;
                        debugScene.currentProcess.destroy();
                    }
                }
            });
            thread.start();
            this.application.gui.debugScene.writeParametersThread = thread;
            clientLauncherProcess.start(true);
            this.contextHelper.runInFxThread(() -> {
                this.switchScene(this.application.gui.debugScene);
                this.application.gui.debugScene.onProcess(clientLauncherProcess.getProcess());
            });
        });
    }

    private String getJavaDirName(Path path) {
        String string = DirBridge.dirUpdates.toAbsolutePath().toString();
        if (path == null || !path.startsWith(string)) {
            return null;
        }
        Path path2 = DirBridge.dirUpdates.relativize(path);
        return path2.toString();
    }

    private void showJavaAlert(ClientProfile clientProfile) {
        if ((JVMHelper.ARCH_TYPE == JVMHelper.ARCH.ARM32 || JVMHelper.ARCH_TYPE == JVMHelper.ARCH.ARM64) && clientProfile.getVersion().compareTo(ClientProfileVersions.MINECRAFT_1_12_2) <= 0) {
            this.application.messageManager.showDialog(this.application.getTranslation("runtime.scenes.serverinfo.javaalert.lwjgl2.header"), String.format(this.application.getTranslation("runtime.scenes.serverinfo.javaalert.lwjgl2.description"), clientProfile.getRecommendJavaVersion()), () -> {}, () -> {}, true);
        } else {
            this.application.messageManager.showDialog(this.application.getTranslation("runtime.scenes.serverinfo.javaalert.header"), String.format(this.application.getTranslation("runtime.scenes.serverinfo.javaalert.description"), clientProfile.getRecommendJavaVersion()), () -> {}, () -> {}, true);
        }
    }

    private void launchClient() {
        ClientProfile clientProfile = this.application.stateService.getProfile();
        if (clientProfile == null) {
            return;
        }
        this.processRequest(this.application.getTranslation("runtime.overlay.processing.text.setprofile"), new SetProfileRequest(clientProfile), setProfileRequestEvent -> this.contextHelper.runInFxThread(() -> this.hideOverlay(0.0, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> {
            RuntimeSettings.ProfileSettings profileSettings = this.application.getProfileSettings();
            JavaHelper.JavaVersion javaVersion = null;
            for (JavaHelper.JavaVersion javaVersion2 : this.application.javaService.javaVersions) {
                if (!javaVersion2.jvmDir.toAbsolutePath().toString().equals(profileSettings.javaPath)) continue;
                javaVersion = javaVersion2;
            }
            if (javaVersion == null && profileSettings.javaPath != null && !this.application.guiModuleConfig.forceDownloadJava) {
                try {
                    javaVersion = JavaHelper.JavaVersion.getByPath(Paths.get(profileSettings.javaPath, new String[0]));
                }
                catch (Throwable throwable) {
                    if (LogHelper.isDevEnabled()) {
                        LogHelper.error(throwable);
                    }
                    LogHelper.warning("Incorrect java path %s", profileSettings.javaPath);
                }
            }
            if (javaVersion == null || this.application.javaService.isIncompatibleJava(javaVersion, clientProfile)) {
                javaVersion = this.application.javaService.getRecommendJavaVersion(clientProfile);
            }
            if (javaVersion == null) {
                this.showJavaAlert(clientProfile);
                return;
            }
            String string = this.getJavaDirName(javaVersion.jvmDir);
            if (string != null) {
                JavaHelper.JavaVersion javaVersion2;
                javaVersion2 = javaVersion;
                try {
                    this.switchScene(this.application.gui.updateScene);
                }
                catch (Exception exception) {
                    this.errorHandle(exception);
                }
                this.application.gui.updateScene.sendUpdateRequest(string, javaVersion.jvmDir, null, true, this.application.stateService.getOptionalView(), false, hashedDir -> {
                    Path path;
                    if ((JVMHelper.OS_TYPE == JVMHelper.OS.LINUX || JVMHelper.OS_TYPE == JVMHelper.OS.MACOSX) && Files.exists(path = javaVersion.jvmDir.resolve("bin").resolve("java"), new LinkOption[0]) && !path.toFile().setExecutable(true)) {
                        LogHelper.warning("Set permission for %s unsuccessful", path.toString());
                    }
                    this.downloadClients(clientProfile, javaVersion2, (HashedDir)hashedDir);
                });
            } else {
                try {
                    this.switchScene(this.application.gui.updateScene);
                }
                catch (Exception exception) {
                    this.errorHandle(exception);
                }
                this.downloadClients(clientProfile, javaVersion, null);
            }
        }))), null);
    }
}

