/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.scenes.login.methods;

import java.util.concurrent.CompletableFuture;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.TextField;
import javafx.scene.layout.Pane;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.client.gui.helper.LookupHelper;
import pro.gravit.launcher.client.gui.overlays.AbstractOverlay;
import pro.gravit.launcher.client.gui.scenes.login.LoginScene;
import pro.gravit.launcher.client.gui.scenes.login.methods.AbstractAuthMethod;
import pro.gravit.launcher.request.auth.details.AuthTotpDetails;
import pro.gravit.launcher.request.auth.password.AuthTOTPPassword;

public class TotpAuthMethod
extends AbstractAuthMethod<AuthTotpDetails> {
    private final TotpOverlay overlay;
    private final JavaFXApplication application;
    private final LoginScene.LoginSceneAccessor accessor;

    public TotpAuthMethod(LoginScene.LoginSceneAccessor loginSceneAccessor) {
        this.accessor = loginSceneAccessor;
        this.application = loginSceneAccessor.getApplication();
        this.overlay = this.application.gui.registerOverlay(TotpOverlay.class);
        this.overlay.accessor = loginSceneAccessor;
    }

    @Override
    public void prepare() {
    }

    @Override
    public void reset() {
    }

    @Override
    public CompletableFuture<Void> show(AuthTotpDetails authTotpDetails) {
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        try {
            this.accessor.showOverlay(this.overlay, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> {
                this.overlay.requestFocus();
                completableFuture.complete(null);
            }));
        }
        catch (Exception exception) {
            this.accessor.errorHandle(exception);
        }
        return completableFuture;
    }

    @Override
    public CompletableFuture<LoginScene.LoginAndPasswordResult> auth(AuthTotpDetails authTotpDetails) {
        this.overlay.future = new CompletableFuture();
        return this.overlay.future;
    }

    @Override
    public CompletableFuture<Void> hide() {
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        this.accessor.hideOverlay(0.0, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> completableFuture.complete(null)));
        return completableFuture;
    }

    @Override
    public boolean isSavable() {
        return false;
    }

    public static class TotpOverlay
    extends AbstractOverlay {
        private static final AbstractAuthMethod.UserAuthCanceledException USER_AUTH_CANCELED_EXCEPTION = new AbstractAuthMethod.UserAuthCanceledException();
        private TextField[] textFields;
        private CompletableFuture<LoginScene.LoginAndPasswordResult> future;
        private LoginScene.LoginSceneAccessor accessor;

        public TotpOverlay(JavaFXApplication javaFXApplication) {
            super("scenes/login/logintotp.fxml", javaFXApplication);
        }

        @Override
        public String getName() {
            return "totp";
        }

        @Override
        protected void doInit() {
            ((ButtonBase)LookupHelper.lookup((Node)this.layout, "#header", "#controls", "#exit")).setOnAction(actionEvent -> {
                this.accessor.hideOverlay(0.0, null);
                this.future.completeExceptionally(USER_AUTH_CANCELED_EXCEPTION);
            });
            Pane pane = (Pane)((Button)LookupHelper.lookup((Node)this.layout, "#auth2fa", "#authButton")).getGraphic();
            this.textFields = new TextField[6];
            for (int i = 0; i < 6; ++i) {
                this.textFields[i] = (TextField)LookupHelper.lookup((Node)pane, "#" + (i + 1) + "st");
                if (i != 5) {
                    TextField textField = this.textFields[i];
                    int n = i;
                    textField.textProperty().addListener(observable -> {
                        if (textField.getText().length() == 1) {
                            this.textFields[n + 1].requestFocus();
                        }
                    });
                    continue;
                }
                this.textFields[i].textProperty().addListener(observable -> {
                    AuthTOTPPassword authTOTPPassword = new AuthTOTPPassword();
                    authTOTPPassword.totp = this.getCode();
                    this.future.complete(new LoginScene.LoginAndPasswordResult(null, authTOTPPassword));
                });
            }
        }

        public void requestFocus() {
            this.textFields[0].requestFocus();
        }

        public String getCode() {
            StringBuilder stringBuilder = new StringBuilder();
            for (TextField textField : this.textFields) {
                stringBuilder.append(textField.getText());
            }
            return stringBuilder.toString();
        }

        @Override
        public void reset() {
            for (TextField textField : this.textFields) {
                textField.setText("");
            }
        }
    }
}

