/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.scenes.login;

import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.Pane;
import javafx.scene.shape.SVGPath;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.client.gui.helper.LookupHelper;

public class LoginAuthButtonComponent {
    private final JavaFXApplication application;
    private final Pane layout;
    private final Pane authUnActive;
    private final Pane authActive;
    private final SVGPath authBorder;
    private final Button button;
    private final Node authsvg;
    private boolean isDisabled;

    public LoginAuthButtonComponent(Pane pane, JavaFXApplication javaFXApplication, EventHandler<ActionEvent> eventHandler) {
        this.application = javaFXApplication;
        this.layout = pane;
        this.authUnActive = (Pane)LookupHelper.lookup((Node)this.layout, "#authUnactive");
        this.authActive = (Pane)LookupHelper.lookup((Node)this.layout, "#authActive");
        this.authBorder = (SVGPath)LookupHelper.lookup((Node)this.authActive, "#authBorder");
        this.button = (Button)LookupHelper.lookup((Node)this.authActive, "#authButton");
        this.authsvg = (Node)((Pane)this.button.getGraphic()).getChildren().get(0);
        this.button.setOnMouseEntered(mouseEvent -> this.authBorder.setVisible(true));
        this.button.setOnMouseExited(mouseEvent -> this.authBorder.setVisible(false));
        this.button.setOnAction(eventHandler);
    }

    public void setActive(boolean bl) {
        this.authUnActive.setVisible(!bl);
        this.authActive.setVisible(bl);
    }

    public void disable() {
        this.isDisabled = true;
        this.button.setDisable(true);
    }

    public void enable() {
        this.isDisabled = false;
        this.button.setDisable(false);
    }

    public Pane getLayout() {
        return this.layout;
    }

    public String getText() {
        return this.button.getText();
    }

    public void setText(String string) {
        this.button.setText(string);
    }

    public void setError() {
        this.authBorder.setStyle("-fx-fill: -fx-redTr");
        this.authsvg.getStyleClass().removeAll((Object[])new String[]{"auth"});
        this.authsvg.getStyleClass().add((Object)"authButtonError");
    }

    public void unsetError() {
        this.authBorder.setStyle("-fx-fill: -fx-greenTr");
        this.authsvg.getStyleClass().removeAll((Object[])new String[]{"authButtonError"});
        this.authsvg.getStyleClass().add((Object)"auth");
    }
}

