/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.scenes.debug;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javafx.scene.Node;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.TextArea;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.LauncherNetworkAPI;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.client.gui.helper.LookupHelper;
import pro.gravit.launcher.client.gui.impl.ContextHelper;
import pro.gravit.launcher.client.gui.scenes.AbstractScene;
import pro.gravit.launcher.client.gui.scenes.console.ConsoleScene;
import pro.gravit.utils.helper.CommonHelper;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;

public class DebugScene
extends AbstractScene {
    private static final long MAX_LENGTH = 32768L;
    private static final int REMOVE_LENGTH = 4096;
    public Process currentProcess;
    public Thread writeParametersThread;
    private Thread readThread;
    private TextArea output;
    private final Object syncObject = new Object();
    private String appendString = "";
    private boolean isOutputRunned;

    public DebugScene(JavaFXApplication javaFXApplication) {
        super("scenes/debug/debug.fxml", javaFXApplication);
        this.isResetOnShow = true;
    }

    @Override
    protected void doInit() {
        this.output = (TextArea)LookupHelper.lookup((Node)this.layout, "#output");
        LookupHelper.lookupIfPossible((Node)this.header, "#controls", "#kill").ifPresent(buttonBase -> buttonBase.setOnAction(actionEvent -> {
            if (this.currentProcess != null && this.currentProcess.isAlive()) {
                this.currentProcess.destroyForcibly();
            }
        }));
        LookupHelper.lookupIfPossible((Node)this.layout, "#version").ifPresent(label -> label.setText(ConsoleScene.getMiniLauncherInfo()));
        LookupHelper.lookupIfPossible((Node)this.header, "#controls", "#copy").ifPresent(buttonBase -> buttonBase.setOnAction(actionEvent -> {
            ClipboardContent clipboardContent = new ClipboardContent();
            clipboardContent.putString(this.output.getText());
            Clipboard clipboard = Clipboard.getSystemClipboard();
            clipboard.setContent((Map)clipboardContent);
        }));
        LookupHelper.lookupIfPossible((Node)this.header, "#controls", "#hastebin").ifPresent(buttonBase -> buttonBase.setOnAction(actionEvent -> {
            String string = null;
            try {
                string = this.hastebin(this.output.getText());
            }
            catch (IOException iOException) {
                this.application.messageManager.createNotification(this.application.getTranslation("runtime.overlay.debug.hastebin.fail.header"), this.application.getTranslation("runtime.overlay.debug.hastebin.fail.description"));
                LogHelper.error(iOException);
            }
            if (string == null) {
                return;
            }
            ClipboardContent clipboardContent = new ClipboardContent();
            clipboardContent.putString(string);
            Clipboard clipboard = Clipboard.getSystemClipboard();
            clipboard.setContent((Map)clipboardContent);
            this.application.openURL(string);
        }));
        ((ButtonBase)LookupHelper.lookup((Node)this.header, "#controls", "#back")).setOnAction(actionEvent -> {
            if (this.writeParametersThread != null && this.writeParametersThread.isAlive()) {
                this.writeParametersThread.interrupt();
            }
            if (this.currentProcess != null && this.currentProcess.isAlive()) {
                Process process = this.currentProcess;
                this.currentProcess = null;
                this.readThread.interrupt();
                this.writeParametersThread = null;
                this.readThread = null;
                try {
                    process.getErrorStream().close();
                    process.getInputStream().close();
                    process.getOutputStream().close();
                }
                catch (IOException iOException) {
                    this.errorHandle(iOException);
                }
            }
            try {
                this.switchScene(this.application.gui.serverInfoScene);
            }
            catch (Exception exception) {
                this.errorHandle(exception);
            }
        });
    }

    @Override
    public void reset() {
        this.output.clear();
    }

    public void onProcess(Process process) {
        if (this.readThread != null && this.readThread.isAlive()) {
            this.readThread.interrupt();
            try {
                this.readThread.join(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.currentProcess != null && this.currentProcess.isAlive()) {
            this.currentProcess.destroyForcibly();
        }
        this.readThread = CommonHelper.newThread("Client Process Console Reader", true, () -> {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(process.getInputStream());
            byte[] byArray = IOHelper.newBuffer();
            try {
                int n = ((InputStream)bufferedInputStream).read(byArray);
                while (n >= 0) {
                    this.append(new String(byArray, 0, n));
                    n = ((InputStream)bufferedInputStream).read(byArray);
                }
                if (this.currentProcess.isAlive()) {
                    this.currentProcess.waitFor();
                }
                this.onProcessExit(this.currentProcess.exitValue());
            }
            catch (IOException iOException) {
                this.errorHandle(iOException);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        this.readThread.start();
        this.currentProcess = process;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(String string) {
        boolean bl = false;
        Object object = this.syncObject;
        synchronized (object) {
            this.appendString = (long)this.appendString.length() > 32768L ? "<logs buffer overflow>\n".concat(string) : this.appendString.concat(string);
            if (!this.isOutputRunned) {
                bl = true;
                this.isOutputRunned = true;
            }
        }
        if (bl) {
            ContextHelper.runInFxThreadStatic(() -> {
                Object object = this.syncObject;
                synchronized (object) {
                    if ((long)this.output.lengthProperty().get() > 32768L) {
                        this.output.deleteText(0, 4096);
                    }
                    this.output.appendText(this.appendString);
                    this.appendString = "";
                    this.isOutputRunned = false;
                }
            });
        }
    }

    @Override
    public void errorHandle(Throwable throwable) {
        if (!(throwable instanceof EOFException) && LogHelper.isDebugEnabled()) {
            this.append(throwable.toString());
        }
        if (this.currentProcess != null && !this.currentProcess.isAlive()) {
            this.onProcessExit(this.currentProcess.exitValue());
        }
    }

    @Override
    public String getName() {
        return "debug";
    }

    private void onProcessExit(int n) {
        this.append(String.format("Process exit code %d", n));
        if (this.writeParametersThread != null) {
            this.writeParametersThread.interrupt();
        }
    }

    public String hastebin(String string) throws IOException {
        if (this.application.guiModuleConfig.hastebinServer == null) {
            throw new NullPointerException("Regenerate the config \"JavaRuntime.json\"");
        }
        URL uRL = new URL(this.application.guiModuleConfig.hastebinServer + "/documents");
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setDoInput(true);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setRequestProperty("Content-Type", "text/plain; charset=UTF-8");
        httpURLConnection.setRequestProperty("Accept", "application/json");
        httpURLConnection.addRequestProperty("User-Agent", "Mozilla/4.76");
        httpURLConnection.setConnectTimeout(10000);
        try (Closeable closeable = new OutputStreamWriter(httpURLConnection.getOutputStream(), StandardCharsets.UTF_8);){
            closeable.write(string);
            closeable.flush();
        }
        int n = httpURLConnection.getResponseCode();
        closeable = 200 <= n && n < 300 ? new InputStreamReader(httpURLConnection.getInputStream(), StandardCharsets.UTF_8) : new InputStreamReader(httpURLConnection.getErrorStream(), StandardCharsets.UTF_8);
        try {
            HasteResponse hasteResponse = Launcher.gsonManager.gson.fromJson((Reader)closeable, HasteResponse.class);
            this.application.messageManager.createNotification(this.application.getTranslation("runtime.overlay.debug.hastebin.success.header"), this.application.getTranslation("runtime.overlay.debug.hastebin.success.description"));
            return this.application.guiModuleConfig.hastebinServer + "/" + hasteResponse.key;
        }
        catch (Exception exception) {
            if (200 > n || n > 300) {
                this.application.messageManager.createNotification(this.application.getTranslation("runtime.overlay.debug.hastebin.fail.header"), this.application.getTranslation("runtime.overlay.debug.hastebin.fail.description"));
                LogHelper.error("JsonRequest failed. Server response code %d", n);
                throw new IOException(exception);
            }
            return null;
        }
    }

    public static class HasteResponse {
        @LauncherNetworkAPI
        public String key;
    }
}

