/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.helper;

import java.util.Optional;
import javafx.scene.Node;
import javafx.scene.Parent;

public class LookupHelper {
    public static <T extends Node> T lookup(Node node, String ... stringArray) {
        Node node2 = node;
        if (node2 == null) {
            throw new NullPointerException();
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if ((node2 = node2.lookup(stringArray[i])) != null) continue;
            throw new LookupException(stringArray, i);
        }
        return (T)node2;
    }

    public static <T extends Node> Optional<T> lookupIfPossible(Node node, String ... stringArray) {
        Node node2 = node;
        if (node2 == null) {
            return Optional.empty();
        }
        for (String string : stringArray) {
            if ((node2 = node2.lookup(string)) != null) continue;
            return Optional.empty();
        }
        return Optional.of(node2);
    }

    public static <T extends Node> Point2D getAbsoluteCords(Node node, Node node2) {
        Point2D point2D = new Point2D(0.0, 0.0);
        Parent parent = (Parent)node;
        while (parent != node2) {
            point2D.x += parent.getLayoutX();
            point2D.y += parent.getLayoutY();
            if ((parent = parent.getParent()) != null) continue;
            break;
        }
        return point2D;
    }

    public static class LookupException
    extends RuntimeException {
        public LookupException(String[] stringArray, int n) {
            super(LookupException.buildStack(stringArray, n));
        }

        private static String buildStack(String[] stringArray, int n) {
            StringBuilder stringBuilder = new StringBuilder("Lookup failed ");
            boolean bl = true;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!bl) {
                    stringBuilder.append("->");
                }
                stringBuilder.append(stringArray[i]);
                if (i == n) {
                    stringBuilder.append("(E)");
                }
                bl = false;
            }
            return stringBuilder.toString();
        }
    }

    public static class Point2D {
        public double x;
        public double y;

        public Point2D(double d, double d2) {
            this.x = d;
            this.y = d2;
        }
    }
}

