/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.dialogs;

import java.util.function.Consumer;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.client.gui.dialogs.AbstractDialog;
import pro.gravit.launcher.client.gui.helper.LookupHelper;

public class TextDialog
extends AbstractDialog {
    private String header;
    private String text;
    private final Consumer<String> onAccept;
    private final Runnable onClose;
    private Label textHeader;
    private Label textDescription;
    private TextField textField;

    public TextDialog(JavaFXApplication javaFXApplication, String string, String string2, Consumer<String> consumer, Runnable runnable) {
        super("dialogs/text/dialog.fxml", javaFXApplication);
        this.header = string;
        this.text = string2;
        this.onAccept = consumer;
        this.onClose = runnable;
    }

    public void setHeader(String string) {
        this.header = string;
        if (this.isInit()) {
            this.textDescription.setText(this.text);
        }
    }

    public void setText(String string) {
        this.text = string;
        if (this.isInit()) {
            this.textHeader.setText(this.header);
        }
    }

    @Override
    public String getName() {
        return "text";
    }

    @Override
    protected void doInit() throws Exception {
        this.textHeader = (Label)LookupHelper.lookup((Node)this.layout, "#dialogHeader");
        this.textDescription = (Label)LookupHelper.lookup((Node)this.layout, "#dialogDescription");
        this.textField = (TextField)LookupHelper.lookup((Node)this.layout, "#dialogInput");
        this.textHeader.setText(this.header);
        this.textDescription.setText(this.text);
        ((Button)LookupHelper.lookup((Node)this.layout, "#exit")).setOnAction(actionEvent -> {
            try {
                this.close();
            }
            catch (Throwable throwable) {
                this.errorHandle(throwable);
            }
            this.onClose.run();
        });
        ((Button)LookupHelper.lookup((Node)this.layout, "#dialogSend")).setOnAction(actionEvent -> {
            try {
                this.close();
            }
            catch (Throwable throwable) {
                this.errorHandle(throwable);
            }
            this.onAccept.accept(this.textField.getText());
        });
    }
}

