/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.commands.runtime;

import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.client.gui.impl.ContextHelper;
import pro.gravit.launcher.client.gui.overlays.AbstractOverlay;
import pro.gravit.launcher.client.gui.scenes.AbstractScene;
import pro.gravit.launcher.client.gui.stage.PrimaryStage;
import pro.gravit.utils.command.Command;

public class WarpCommand
extends Command {
    private JavaFXApplication application;

    public WarpCommand(JavaFXApplication javaFXApplication) {
        this.application = javaFXApplication;
    }

    @Override
    public String getArgsDescription() {
        return "[scene/overlay] [name]";
    }

    @Override
    public String getUsageDescription() {
        return "warp to any scene/overlay";
    }

    @Override
    public void invoke(String ... stringArray) throws Exception {
        this.verifyArgs(stringArray, 2);
        if (this.application == null) {
            this.application = JavaFXApplication.getInstance();
        }
        if (stringArray[0].equals("scene")) {
            AbstractScene abstractScene = this.application.gui.getSceneByName(stringArray[1]);
            if (abstractScene == null) {
                throw new IllegalArgumentException(String.format("Scene %s not found", stringArray[1]));
            }
            PrimaryStage primaryStage = this.application.getMainStage();
            ContextHelper.runInFxThreadStatic(() -> {
                primaryStage.setScene(abstractScene);
                if (!primaryStage.isShowing()) {
                    primaryStage.show();
                }
            });
        } else if (stringArray[0].equals("overlay")) {
            AbstractOverlay abstractOverlay = this.application.gui.getOverlayByName(stringArray[1]);
            if (abstractOverlay == null) {
                throw new IllegalArgumentException(String.format("Overlay %s not found", stringArray[1]));
            }
            PrimaryStage primaryStage = this.application.getMainStage();
            if (primaryStage.isNullScene()) {
                throw new IllegalStateException("Please wrap to scene before");
            }
            AbstractScene abstractScene = (AbstractScene)primaryStage.getVisualComponent();
            ContextHelper.runInFxThreadStatic(() -> abstractScene.showOverlay(abstractOverlay, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> {})));
        } else {
            throw new IllegalArgumentException(String.format("%s not found", stringArray[0]));
        }
    }
}

