/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client;

import java.lang.reflect.Method;
import java.util.Base64;
import javafx.stage.Stage;
import javax.swing.JOptionPane;
import pro.gravit.launcher.LauncherEngine;
import pro.gravit.launcher.client.StdJavaRuntimeProvider;
import pro.gravit.launcher.client.events.ClientEngineInitPhase;
import pro.gravit.launcher.client.events.ClientExitPhase;
import pro.gravit.launcher.client.events.ClientPreGuiPhase;
import pro.gravit.launcher.client.events.ClientUnlockConsoleEvent;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.client.gui.service.OfflineService;
import pro.gravit.launcher.gui.RuntimeProvider;
import pro.gravit.launcher.modules.LauncherInitContext;
import pro.gravit.launcher.modules.LauncherModule;
import pro.gravit.launcher.modules.LauncherModuleInfo;
import pro.gravit.launcher.modules.events.OfflineModeEvent;
import pro.gravit.launcher.request.websockets.OfflineRequestService;
import pro.gravit.utils.Version;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.LogHelper;

public class JavaRuntimeModule
extends LauncherModule {
    public static final String RUNTIME_NAME = "stdruntime";
    static LauncherEngine engine;
    private RuntimeProvider provider;

    public JavaRuntimeModule() {
        super(new LauncherModuleInfo("StdJavaRuntime", new Version(2, 2, 2, 1, Version.Type.STABLE), 0, new String[0], new String[]{"runtime"}));
    }

    private static void noJavaFxAlert() {
        String string = String.format("\u0411\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0438 JavaFX \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b. \u0423 \u0432\u0430\u0441 %s(x%d) \u041e\u0421 %s(x%d). Java %s. \u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 Java \u0441 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u043a\u043e\u0439 JavaFX, \u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440 OracleJRE 8 x%d \u0441 \u043e\u0444\u0438\u0446\u0438\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0441\u0430\u0439\u0442\u0430.\n%s\n\u0415\u0441\u043b\u0438 \u0432\u044b \u043d\u0435 \u043c\u043e\u0436\u0435\u0442\u0435 \u0440\u0435\u0448\u0438\u0442\u044c \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0443 \u0441\u0430\u043c\u043e\u0441\u0442\u043e\u044f\u0442\u0435\u043b\u044c\u043d\u043e \u043e\u0431\u0440\u0430\u0442\u0438\u0442\u0435\u0441\u044c \u043a \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0441\u0432\u043e\u0435\u0433\u043e \u043f\u0440\u043e\u0435\u043a\u0442\u0430", JVMHelper.RUNTIME_MXBEAN.getVmName(), JVMHelper.JVM_BITS, JVMHelper.OS_TYPE.name, JVMHelper.OS_BITS, JVMHelper.RUNTIME_MXBEAN.getSpecVersion(), JVMHelper.OS_BITS, JVMHelper.OS_TYPE == JVMHelper.OS.MUSTDIE ? "\u0423\u0431\u0435\u0434\u0438\u0442\u0435\u0441\u044c \u0447\u0442\u043e \u0432\u044b \u0437\u0430\u043f\u0443\u0441\u043a\u0430\u0435\u0442\u0435 \u0441 \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e\u0439 Java(\u041f\u041a\u041c->\u041e\u0442\u043a\u0440\u044b\u0442\u044c \u0441 \u043f\u043e\u043c\u043e\u0449\u044c\u044e->Java 8)" : "\u0423\u0431\u0435\u0434\u0438\u0442\u0435\u0441\u044c, \u0447\u0442\u043e \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e \u0441\u0442\u043e\u0438\u0442 \u0437\u0430\u043f\u0443\u0441\u043a \u0441 \u043f\u043e\u0434\u0445\u043e\u0434\u044f\u0448\u0435\u0439 Java \u0438 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d openjfx \u0442\u043e\u0439 \u0436\u0435 \u0432\u0435\u0440\u0441\u0438\u0438");
        JOptionPane.showMessageDialog(null, string, "GravitLauncher", 0);
    }

    private static void noInitMethodAlert() {
        String string = "JavaFX \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u0441\u043e\u0431\u0440\u0430\u043d\u043e \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e. \u041e\u0431\u0440\u0430\u0442\u0438\u0442\u0435\u0441\u044c \u043a \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0443 \u043f\u0440\u043e\u0435\u043a\u0442\u0430 \u0441 \u0441\u043a\u0440\u0438\u043d\u0448\u043e\u0442\u043e\u043c \u044d\u0442\u043e\u0433\u043e \u043e\u043a\u043d\u0430\n\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435:\n\u041f\u0440\u0438 \u0441\u0431\u043e\u0440\u043a\u0435 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u043e\u0432\u0430\u043b\u0438 \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0438 JavaFX. \u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 Java \u0441 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u043a\u043e\u0439 JavaFX \u043d\u0430 \u0441\u0442\u043e\u0440\u043e\u043d\u0435 \u043b\u0430\u0443\u043d\u0447\u0441\u0435\u0440\u0432\u0435\u0440\u0430 \u0438 \u043f\u043e\u0432\u0442\u043e\u0440\u0438\u0442\u0435 \u0441\u0431\u043e\u0440\u043a\u0443 \u043b\u0430\u0443\u043d\u0447\u0435\u0440\u0430";
        JOptionPane.showMessageDialog(null, string, "GravitLauncher", 0);
    }

    public static void noLocaleAlert(String string) {
        String string2 = String.format("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0444\u0430\u0439\u043b \u044f\u0437\u044b\u043a\u0430 '%s' \u043f\u0440\u0438 \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 GUI. \u0414\u0430\u043b\u044c\u043d\u0435\u0439\u0448\u0430\u044f \u0440\u0430\u0431\u043e\u0442\u0430 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u0430.\n\u0423\u0431\u0435\u0434\u0438\u0442\u0435\u0441\u044c \u0447\u0442\u043e \u0432\u0441\u0435 \u0444\u0430\u0439\u043b\u044b \u0434\u0438\u0437\u0430\u0439\u043d\u0430 \u043b\u0430\u0443\u043d\u0447\u0435\u0440\u0430 \u043f\u0440\u0438\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u0432 \u043f\u0430\u043f\u043a\u0435 runtime \u043f\u0440\u0438 \u0441\u0431\u043e\u0440\u043a\u0435 \u043b\u0430\u0443\u043d\u0447\u0435\u0440\u0430", string);
        JOptionPane.showMessageDialog(null, string2, "GravitLauncher", 0);
    }

    public static void noEnFSAlert() {
        String string = "\u0417\u0430\u043f\u0443\u0441\u043a \u043b\u0430\u0443\u043d\u0447\u0435\u0440\u0430 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u0435\u043d \u0438\u0437 \u0437\u0430 \u043e\u0448\u0438\u0431\u043a\u0438 \u0440\u0430\u0441\u0448\u0438\u0444\u0440\u043e\u0432\u043a\u0438 \u0440\u0430\u043d\u0442\u0430\u0439\u043c\u0430\n\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 Java 11 \u0441 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u043a\u043e\u0439 JavaFX \u0434\u043b\u044f \u0438\u0441\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u044d\u0442\u043e\u0439 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u044b";
        JOptionPane.showMessageDialog(null, string, "GravitLauncher", 0);
    }

    public static void errorHandleAlert(Throwable throwable) {
        String string = String.format("\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u0441\u0435\u0440\u044c\u0435\u0437\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430 \u043b\u0430\u0443\u043d\u0447\u0435\u0440\u0430.\n\u0414\u043b\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u0439:\n\u041e\u0431\u0440\u0430\u0442\u0438\u0442\u0435\u0441\u044c \u043a \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0441\u0432\u043e\u0435\u0433\u043e \u043f\u0440\u043e\u0435\u043a\u0442\u0430 \u0441 \u0441\u043a\u0440\u0438\u043d\u0448\u043e\u0442\u043e\u043c \u044d\u0442\u043e\u0433\u043e \u043e\u043a\u043d\u0430\nJava %d (x%d) \u041e\u0448\u0438\u0431\u043a\u0430 %s\n\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435: %s\n\u0411\u043e\u043b\u0435\u0435 \u043f\u043e\u0434\u0440\u043e\u0431\u043d\u0443\u044e \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044e \u043c\u043e\u0436\u043d\u043e \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0438\u0437 \u043b\u043e\u0433\u0430", JVMHelper.JVM_VERSION, JVMHelper.JVM_BITS, throwable.getClass().getName(), throwable.getMessage() == null ? "null" : throwable.getMessage());
        JOptionPane.showMessageDialog(null, string, "GravitLauncher", 0);
    }

    @Override
    public void init(LauncherInitContext launcherInitContext) {
        this.registerEvent(this::preGuiPhase, ClientPreGuiPhase.class);
        this.registerEvent(this::engineInitPhase, ClientEngineInitPhase.class);
        this.registerEvent(this::exitPhase, ClientExitPhase.class);
        this.registerEvent(this::consoleUnlock, ClientUnlockConsoleEvent.class);
        this.registerEvent(this::offlineMode, OfflineModeEvent.class);
    }

    private void preGuiPhase(ClientPreGuiPhase clientPreGuiPhase) {
        try {
            Class.forName("javafx.application.Application");
        }
        catch (ClassNotFoundException classNotFoundException) {
            JavaRuntimeModule.noJavaFxAlert();
            LauncherEngine.exitLauncher(0);
        }
        try {
            Method method = JavaFXApplication.class.getMethod(new String(Base64.getDecoder().decode("c3RhcnQ=")), Stage.class);
            if (method.getDeclaringClass() != JavaFXApplication.class) {
                throw new RuntimeException("Method start not override");
            }
        }
        catch (Throwable throwable) {
            LogHelper.error(throwable);
            JavaRuntimeModule.noInitMethodAlert();
            LauncherEngine.exitLauncher(0);
        }
        clientPreGuiPhase.runtimeProvider = this.provider = new StdJavaRuntimeProvider();
    }

    private void consoleUnlock(ClientUnlockConsoleEvent clientUnlockConsoleEvent) {
        if (JavaRuntimeModule.engine.runtimeProvider instanceof StdJavaRuntimeProvider) {
            ((StdJavaRuntimeProvider)JavaRuntimeModule.engine.runtimeProvider).registerPrivateCommands();
        }
    }

    private void offlineMode(OfflineModeEvent offlineModeEvent) {
        OfflineService.applyRuntimeProcessors((OfflineRequestService)offlineModeEvent.service);
    }

    private void engineInitPhase(ClientEngineInitPhase clientEngineInitPhase) {
        engine = clientEngineInitPhase.engine;
    }

    private void exitPhase(ClientExitPhase clientExitPhase) {
        if (this.provider != null && this.provider instanceof StdJavaRuntimeProvider) {
            try {
                ((StdJavaRuntimeProvider)this.provider).getApplication().saveSettings();
            }
            catch (Throwable throwable) {
                LogHelper.error(throwable);
            }
        }
    }
}

