/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.COM.WbemcliUtil;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.VersionHelpers;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinReg;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.driver.windows.LogicalProcessorInformation;
import oshi.driver.windows.perfmon.LoadAverage;
import oshi.driver.windows.perfmon.ProcessorInformation;
import oshi.driver.windows.perfmon.SystemInformation;
import oshi.driver.windows.wmi.Win32Processor;
import oshi.hardware.CentralProcessor;
import oshi.hardware.common.AbstractCentralProcessor;
import oshi.jna.Struct;
import oshi.jna.platform.windows.PowrProf;
import oshi.util.GlobalConfig;
import oshi.util.Memoizer;
import oshi.util.ParseUtil;
import oshi.util.platform.windows.WmiUtil;
import oshi.util.tuples.Pair;
import oshi.util.tuples.Triplet;

@ThreadSafe
final class WindowsCentralProcessor
extends AbstractCentralProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(WindowsCentralProcessor.class);
    private Map<String, Integer> numaNodeProcToLogicalProcMap;
    private static final boolean USE_LOAD_AVERAGE = GlobalConfig.get("oshi.os.windows.loadaverage", false);
    private static final boolean USE_CPU_UTILITY;
    private final Supplier<Pair<List<String>, Map<ProcessorInformation.ProcessorUtilityTickCountProperty, List<Long>>>> processorUtilityCounters = USE_CPU_UTILITY ? Memoizer.memoize(WindowsCentralProcessor::queryProcessorUtilityCounters, TimeUnit.MILLISECONDS.toNanos(300L)) : null;
    private Map<ProcessorInformation.ProcessorUtilityTickCountProperty, List<Long>> initialUtilityCounters = USE_CPU_UTILITY ? this.processorUtilityCounters.get().getB() : null;
    private Long utilityBaseMultiplier = null;

    WindowsCentralProcessor() {
    }

    @Override
    protected CentralProcessor.ProcessorIdentifier queryProcessorId() {
        String string;
        WbemcliUtil.WmiResult<Win32Processor.ProcessorIdProperty> wmiResult;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        long l = 0L;
        boolean bl = false;
        String string8 = "HARDWARE\\DESCRIPTION\\System\\CentralProcessor\\";
        String[] stringArray = Advapi32Util.registryGetKeys(WinReg.HKEY_LOCAL_MACHINE, "HARDWARE\\DESCRIPTION\\System\\CentralProcessor\\");
        if (stringArray.length > 0) {
            wmiResult = "HARDWARE\\DESCRIPTION\\System\\CentralProcessor\\" + stringArray[0];
            string2 = Advapi32Util.registryGetStringValue(WinReg.HKEY_LOCAL_MACHINE, (String)((Object)wmiResult), "VendorIdentifier");
            string3 = Advapi32Util.registryGetStringValue(WinReg.HKEY_LOCAL_MACHINE, (String)((Object)wmiResult), "ProcessorNameString");
            string4 = Advapi32Util.registryGetStringValue(WinReg.HKEY_LOCAL_MACHINE, (String)((Object)wmiResult), "Identifier");
            try {
                l = (long)Advapi32Util.registryGetIntValue(WinReg.HKEY_LOCAL_MACHINE, wmiResult, "~MHz") * 1000000L;
            }
            catch (Win32Exception win32Exception) {
                // empty catch block
            }
        }
        if (!string4.isEmpty()) {
            string5 = WindowsCentralProcessor.parseIdentifier(string4, "Family");
            string6 = WindowsCentralProcessor.parseIdentifier(string4, "Model");
            string7 = WindowsCentralProcessor.parseIdentifier(string4, "Stepping");
        }
        wmiResult = new Struct.CloseableSystemInfo();
        try {
            Kernel32.INSTANCE.GetNativeSystemInfo((WinBase.SYSTEM_INFO)((Object)wmiResult));
            int n = ((Struct.CloseableSystemInfo)((Object)wmiResult)).processorArchitecture.pi.wProcessorArchitecture.intValue();
            if (n == 9 || n == 12 || n == 6) {
                bl = true;
            }
        }
        finally {
            ((Struct.CloseableSystemInfo)((Object)wmiResult)).close();
        }
        wmiResult = Win32Processor.queryProcessorId();
        if (wmiResult.getResultCount() > 0) {
            string = WmiUtil.getString(wmiResult, Win32Processor.ProcessorIdProperty.PROCESSORID, 0);
        } else {
            String[] stringArray2;
            if (bl) {
                String[] stringArray3 = new String[1];
                stringArray2 = stringArray3;
                stringArray3[0] = "ia64";
            } else {
                stringArray2 = new String[]{};
            }
            string = WindowsCentralProcessor.createProcessorID(string7, string6, string5, stringArray2);
        }
        return new CentralProcessor.ProcessorIdentifier(string2, string3, string5, string6, string7, string, bl, l);
    }

    private static String parseIdentifier(String string, String string2) {
        String[] stringArray = ParseUtil.whitespaces.split(string);
        boolean bl = false;
        for (String string3 : stringArray) {
            if (bl) {
                return string3;
            }
            bl = string3.equals(string2);
        }
        return "";
    }

    @Override
    protected Triplet<List<CentralProcessor.LogicalProcessor>, List<CentralProcessor.PhysicalProcessor>, List<CentralProcessor.ProcessorCache>> initProcessorCounts() {
        if (VersionHelpers.IsWindows7OrGreater()) {
            Triplet<List<CentralProcessor.LogicalProcessor>, List<CentralProcessor.PhysicalProcessor>, List<CentralProcessor.ProcessorCache>> triplet = LogicalProcessorInformation.getLogicalProcessorInformationEx();
            int n = -1;
            int n2 = 0;
            int n3 = 0;
            this.numaNodeProcToLogicalProcMap = new HashMap<String, Integer>();
            for (CentralProcessor.LogicalProcessor logicalProcessor : triplet.getA()) {
                int n4 = logicalProcessor.getNumaNode();
                if (n4 != n) {
                    n = n4;
                    n2 = 0;
                }
                this.numaNodeProcToLogicalProcMap.put(String.format("%d,%d", logicalProcessor.getNumaNode(), n2++), n3++);
            }
            return triplet;
        }
        return LogicalProcessorInformation.getLogicalProcessorInformation();
    }

    @Override
    public long[] querySystemCpuLoadTicks() {
        long[] lArray = new long[CentralProcessor.TickType.values().length];
        long[][] lArray2 = this.getProcessorCpuLoadTicks();
        for (int i = 0; i < lArray.length; ++i) {
            for (long[] lArray3 : lArray2) {
                int n = i;
                lArray[n] = lArray[n] + lArray3[i];
            }
        }
        return lArray;
    }

    @Override
    public long[] queryCurrentFreq() {
        if (VersionHelpers.IsWindows7OrGreater()) {
            Pair<List<String>, Map<ProcessorInformation.ProcessorFrequencyProperty, List<Long>>> pair = ProcessorInformation.queryFrequencyCounters();
            List<String> list = pair.getA();
            Map<ProcessorInformation.ProcessorFrequencyProperty, List<Long>> map = pair.getB();
            List<Long> list2 = map.get(ProcessorInformation.ProcessorFrequencyProperty.PERCENTOFMAXIMUMFREQUENCY);
            if (!list.isEmpty()) {
                long l = this.getMaxFreq();
                long[] lArray = new long[this.getLogicalProcessorCount()];
                for (String string : list) {
                    int n;
                    int n2 = n = string.contains(",") ? this.numaNodeProcToLogicalProcMap.getOrDefault(string, 0) : ParseUtil.parseIntOrDefault(string, 0);
                    if (n >= this.getLogicalProcessorCount()) continue;
                    lArray[n] = list2.get(n) * l / 100L;
                }
                return lArray;
            }
        }
        return this.queryNTPower(2);
    }

    @Override
    public long queryMaxFreq() {
        long[] lArray = this.queryNTPower(1);
        return Arrays.stream(lArray).max().orElse(-1L);
    }

    private long[] queryNTPower(int n) {
        PowrProf.ProcessorPowerInformation processorPowerInformation = new PowrProf.ProcessorPowerInformation();
        PowrProf.ProcessorPowerInformation[] processorPowerInformationArray = (PowrProf.ProcessorPowerInformation[])processorPowerInformation.toArray(this.getLogicalProcessorCount());
        long[] lArray = new long[this.getLogicalProcessorCount()];
        if (0 != PowrProf.INSTANCE.CallNtPowerInformation(11, null, 0, processorPowerInformationArray[0].getPointer(), processorPowerInformation.size() * processorPowerInformationArray.length)) {
            LOG.error("Unable to get Processor Information");
            Arrays.fill(lArray, -1L);
            return lArray;
        }
        for (int i = 0; i < lArray.length; ++i) {
            lArray[i] = n == 1 ? (long)processorPowerInformationArray[i].maxMhz * 1000000L : (n == 2 ? (long)processorPowerInformationArray[i].currentMhz * 1000000L : -1L);
        }
        return lArray;
    }

    @Override
    public double[] getSystemLoadAverage(int n) {
        if (n < 1 || n > 3) {
            throw new IllegalArgumentException("Must include from one to three elements.");
        }
        return LoadAverage.queryLoadAverage(n);
    }

    @Override
    public long[][] queryProcessorCpuLoadTicks() {
        List<Long> list;
        List<Long> list2;
        List<Long> list3;
        List<Long> list4;
        List<Long> list5;
        Object object;
        List<String> list6;
        Pair<List<String>, Map<Enum, List<Long>>> pair;
        List<Long> list7 = null;
        List list8 = null;
        List list9 = null;
        List list10 = null;
        List<Long> list11 = null;
        List<Long> list12 = null;
        List<Long> list13 = null;
        List<Long> list14 = null;
        List<Long> list15 = null;
        List<Long> list16 = null;
        if (USE_CPU_UTILITY) {
            pair = this.processorUtilityCounters.get();
            list6 = pair.getA();
            object = pair.getB();
            list5 = object.get(ProcessorInformation.ProcessorUtilityTickCountProperty.PERCENTPRIVILEGEDTIME);
            list4 = object.get(ProcessorInformation.ProcessorUtilityTickCountProperty.PERCENTUSERTIME);
            list3 = object.get(ProcessorInformation.ProcessorUtilityTickCountProperty.PERCENTINTERRUPTTIME);
            list2 = object.get(ProcessorInformation.ProcessorUtilityTickCountProperty.PERCENTDPCTIME);
            list = object.get(ProcessorInformation.ProcessorUtilityTickCountProperty.PERCENTPROCESSORTIME);
            list7 = object.get(ProcessorInformation.ProcessorUtilityTickCountProperty.TIMESTAMP_SYS100NS);
            list8 = (List)object.get(ProcessorInformation.ProcessorUtilityTickCountProperty.PERCENTPRIVILEGEDUTILITY);
            list9 = (List)object.get(ProcessorInformation.ProcessorUtilityTickCountProperty.PERCENTPROCESSORUTILITY);
            list10 = (List)object.get(ProcessorInformation.ProcessorUtilityTickCountProperty.PERCENTPROCESSORUTILITY_BASE);
            list11 = this.initialUtilityCounters.get(ProcessorInformation.ProcessorUtilityTickCountProperty.PERCENTPRIVILEGEDTIME);
            list12 = this.initialUtilityCounters.get(ProcessorInformation.ProcessorUtilityTickCountProperty.PERCENTUSERTIME);
            list13 = this.initialUtilityCounters.get(ProcessorInformation.ProcessorUtilityTickCountProperty.TIMESTAMP_SYS100NS);
            list14 = this.initialUtilityCounters.get(ProcessorInformation.ProcessorUtilityTickCountProperty.PERCENTPRIVILEGEDUTILITY);
            list15 = this.initialUtilityCounters.get(ProcessorInformation.ProcessorUtilityTickCountProperty.PERCENTPROCESSORUTILITY);
            list16 = this.initialUtilityCounters.get(ProcessorInformation.ProcessorUtilityTickCountProperty.PERCENTPROCESSORUTILITY_BASE);
        } else {
            pair = ProcessorInformation.queryProcessorCounters();
            list6 = pair.getA();
            object = pair.getB();
            list5 = object.get(ProcessorInformation.ProcessorTickCountProperty.PERCENTPRIVILEGEDTIME);
            list4 = object.get(ProcessorInformation.ProcessorTickCountProperty.PERCENTUSERTIME);
            list3 = object.get(ProcessorInformation.ProcessorTickCountProperty.PERCENTINTERRUPTTIME);
            list2 = object.get(ProcessorInformation.ProcessorTickCountProperty.PERCENTDPCTIME);
            list = object.get(ProcessorInformation.ProcessorTickCountProperty.PERCENTPROCESSORTIME);
        }
        int n = this.getLogicalProcessorCount();
        object = new long[n][CentralProcessor.TickType.values().length];
        if (list6.isEmpty() || list5 == null || list4 == null || list3 == null || list2 == null || list == null || USE_CPU_UTILITY && (list7 == null || list8 == null || list9 == null || list10 == null || list11 == null || list12 == null || list13 == null || list14 == null || list15 == null || list16 == null)) {
            return object;
        }
        for (String string : list6) {
            long l;
            long l2;
            long l3;
            int n2;
            int n3 = n2 = string.contains(",") ? this.numaNodeProcToLogicalProcMap.getOrDefault(string, 0) : ParseUtil.parseIntOrDefault(string, 0);
            if (n2 >= n) continue;
            object[n2][CentralProcessor.TickType.SYSTEM.getIndex()] = list5.get(n2);
            object[n2][CentralProcessor.TickType.USER.getIndex()] = list4.get(n2);
            object[n2][CentralProcessor.TickType.IRQ.getIndex()] = list3.get(n2);
            object[n2][CentralProcessor.TickType.SOFTIRQ.getIndex()] = list2.get(n2);
            object[n2][CentralProcessor.TickType.IDLE.getIndex()] = list.get(n2);
            if (USE_CPU_UTILITY && (l3 = list7.get(n2) - list13.get(n2)) > 0L && (l2 = this.lazilyCalculateMultiplier(l = (Long)list10.get(n2) - list16.get(n2), l3)) > 0L) {
                long l4 = (Long)list9.get(n2) - list15.get(n2);
                long l5 = (Long)list8.get(n2) - list14.get(n2);
                long l6 = list12.get(n2) + l2 * (l4 - l5) / 100L;
                long l7 = list11.get(n2) + l2 * l5 / 100L;
                long l8 = l6 - object[n2][CentralProcessor.TickType.USER.getIndex()];
                object[n2][CentralProcessor.TickType.USER.getIndex()] = l6;
                object[n2][CentralProcessor.TickType.SYSTEM.getIndex()] = l7;
                Object object2 = object[n2];
                int n4 = CentralProcessor.TickType.IDLE.getIndex();
                object2[n4] = object2[n4] - (l8 += l7 - object[n2][CentralProcessor.TickType.SYSTEM.getIndex()]);
            }
            Object object3 = object[n2];
            int n5 = CentralProcessor.TickType.SYSTEM.getIndex();
            object3[n5] = object3[n5] - (object[n2][CentralProcessor.TickType.IRQ.getIndex()] + object[n2][CentralProcessor.TickType.SOFTIRQ.getIndex()]);
            Object object4 = object[n2];
            int n6 = CentralProcessor.TickType.SYSTEM.getIndex();
            object4[n6] = object4[n6] / 10000L;
            Object object5 = object[n2];
            int n7 = CentralProcessor.TickType.USER.getIndex();
            object5[n7] = object5[n7] / 10000L;
            Object object6 = object[n2];
            int n8 = CentralProcessor.TickType.IRQ.getIndex();
            object6[n8] = object6[n8] / 10000L;
            Object object7 = object[n2];
            int n9 = CentralProcessor.TickType.SOFTIRQ.getIndex();
            object7[n9] = object7[n9] / 10000L;
            Object object8 = object[n2];
            int n10 = CentralProcessor.TickType.IDLE.getIndex();
            object8[n10] = object8[n10] / 10000L;
        }
        return object;
    }

    private synchronized long lazilyCalculateMultiplier(long l, long l2) {
        if (this.utilityBaseMultiplier == null) {
            if (l2 >> 32 > 0L) {
                this.initialUtilityCounters = this.processorUtilityCounters.get().getB();
                return 0L;
            }
            if (l <= 0L) {
                l += 0x100000000L;
            }
            long l3 = Math.round((double)l2 / (double)l);
            if (l2 < 50000000L) {
                return l3;
            }
            this.utilityBaseMultiplier = l3;
        }
        return this.utilityBaseMultiplier;
    }

    private static Pair<List<String>, Map<ProcessorInformation.ProcessorUtilityTickCountProperty, List<Long>>> queryProcessorUtilityCounters() {
        return ProcessorInformation.queryProcessorCapacityCounters();
    }

    @Override
    public long queryContextSwitches() {
        return SystemInformation.queryContextSwitchCounters().getOrDefault(SystemInformation.ContextSwitchProperty.CONTEXTSWITCHESPERSEC, 0L);
    }

    @Override
    public long queryInterrupts() {
        return ProcessorInformation.queryInterruptCounters().getOrDefault(ProcessorInformation.InterruptsProperty.INTERRUPTSPERSEC, 0L);
    }

    static {
        if (USE_LOAD_AVERAGE) {
            LoadAverage.startDaemon();
        }
        USE_CPU_UTILITY = VersionHelpers.IsWindows8OrGreater() && GlobalConfig.get("oshi.os.windows.cpu.utility", false);
    }
}

