/*
 * Decompiled with CFR 0.152.
 */
package de.jcm.discordgamesdk.voice;

import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class VoiceInputMode {
    private InputModeType type;
    private String shortcut;

    VoiceInputMode(int n, String string) {
        this(InputModeType.javaValue(n), string);
    }

    public VoiceInputMode(InputModeType inputModeType, String string) {
        this.type = inputModeType;
        this.shortcut = string;
    }

    public InputModeType getType() {
        return this.type;
    }

    public void setType(InputModeType inputModeType) {
        this.type = inputModeType;
    }

    public String getShortcut() {
        return this.shortcut;
    }

    public void setShortcut(String string) {
        if (string.getBytes(StandardCharsets.UTF_8).length >= 256) {
            throw new IllegalArgumentException("max shortcut length is 255");
        }
        this.shortcut = string;
    }

    public String toString() {
        return "VoiceInputMode{type=" + (Object)((Object)this.type) + ", shortcut='" + this.shortcut + '\'' + '}';
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        VoiceInputMode voiceInputMode = (VoiceInputMode)object;
        return this.type == voiceInputMode.type && Objects.equals(this.shortcut, voiceInputMode.shortcut);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.shortcut});
    }

    int getNativeType() {
        return this.getType().nativeValue();
    }

    public static enum InputModeType {
        VOICE_ACTIVITY,
        PUSH_TO_TALK;

        private static final int OFFSET = 0;

        private int nativeValue() {
            return this.ordinal() + 0;
        }

        private static InputModeType javaValue(int n) {
            return InputModeType.values()[n - 0];
        }
    }
}

