/*
 * Decompiled with CFR 0.152.
 */
package de.jcm.discordgamesdk;

import de.jcm.discordgamesdk.Core;
import de.jcm.discordgamesdk.GameSDKException;
import de.jcm.discordgamesdk.Result;
import de.jcm.discordgamesdk.activity.ActivityType;
import de.jcm.discordgamesdk.user.OnlineStatus;
import de.jcm.discordgamesdk.user.Relationship;
import de.jcm.discordgamesdk.user.RelationshipType;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class RelationshipManager {
    public static final Predicate<Relationship> NO_FILTER = relationship -> true;
    public static final Predicate<Relationship> FRIEND_FILTER = relationship -> relationship.getType() == RelationshipType.FRIEND;
    public static final Predicate<Relationship> ONLINE_FILTER = relationship -> relationship.getPresence().getStatus() == OnlineStatus.ONLINE;
    public static final Predicate<Relationship> OFFLINE_FILTER = relationship -> relationship.getPresence().getStatus() == OnlineStatus.OFFLINE;
    public static final Predicate<Relationship> SPECIAL_FILTER = relationship -> relationship.getPresence().getActivity().getType() == ActivityType.PLAYING && relationship.getPresence().getActivity().getApplicationId() != 0L || relationship.getPresence().getActivity().getType() != ActivityType.PLAYING;
    private final long pointer;
    private final Core core;

    RelationshipManager(long l, Core core) {
        this.pointer = l;
        this.core = core;
    }

    public Relationship getWith(long l) {
        Object object = this.core.execute(() -> this.get(this.pointer, l));
        if (object instanceof Result) {
            throw new GameSDKException((Result)((Object)object));
        }
        return (Relationship)object;
    }

    public void filter(Predicate<Relationship> predicate) {
        this.core.execute(() -> this.filter(this.pointer, Objects.requireNonNull(predicate)));
    }

    public int count() {
        Object object = this.core.execute(() -> this.count(this.pointer));
        if (object instanceof Result) {
            throw new GameSDKException((Result)((Object)object));
        }
        return (Integer)object;
    }

    public Relationship getAt(int n) {
        Object object = this.core.execute(() -> this.getAt(this.pointer, n));
        if (object instanceof Result) {
            throw new GameSDKException((Result)((Object)object));
        }
        return (Relationship)object;
    }

    public List<Relationship> asList() {
        int n = this.count();
        Relationship[] relationshipArray = new Relationship[n];
        for (int i = 0; i < relationshipArray.length; ++i) {
            relationshipArray[i] = this.getAt(i);
        }
        return Arrays.asList(relationshipArray);
    }

    private native void filter(long var1, Predicate<Relationship> var3);

    private native Object count(long var1);

    private native Object get(long var1, long var3);

    private native Object getAt(long var1, int var3);
}

