/*
 * Decompiled with CFR 0.152.
 */
package de.jcm.discordgamesdk;

import de.jcm.discordgamesdk.ActivityManager;
import de.jcm.discordgamesdk.CoreClosedException;
import de.jcm.discordgamesdk.CreateParams;
import de.jcm.discordgamesdk.GameSDKException;
import de.jcm.discordgamesdk.ImageManager;
import de.jcm.discordgamesdk.LobbyManager;
import de.jcm.discordgamesdk.LogLevel;
import de.jcm.discordgamesdk.NetworkManager;
import de.jcm.discordgamesdk.OverlayManager;
import de.jcm.discordgamesdk.RelationshipManager;
import de.jcm.discordgamesdk.Result;
import de.jcm.discordgamesdk.UserManager;
import de.jcm.discordgamesdk.VoiceManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class Core
implements AutoCloseable {
    public static final Consumer<Result> DEFAULT_CALLBACK = result -> {
        if (result != Result.OK) {
            throw new GameSDKException((Result)((Object)result));
        }
    };
    public static final BiConsumer<LogLevel, String> DEFAULT_LOG_HOOK = (logLevel, string) -> System.out.printf("[%s] %s\n", logLevel, string);
    private final long pointer;
    private final CreateParams createParams;
    private final AtomicBoolean open = new AtomicBoolean(true);
    private final ReentrantLock lock = new ReentrantLock();
    private final ActivityManager activityManager;
    private final UserManager userManager;
    private final OverlayManager overlayManager;
    private final RelationshipManager relationshipManager;
    private final ImageManager imageManager;
    private final LobbyManager lobbyManager;
    private final NetworkManager networkManager;
    private final VoiceManager voiceManager;

    public static void init(File file) {
        File file2 = new File(System.getProperty("java.io.tmpdir"), "java-discord-game-sdk-" + System.nanoTime());
        if (!(file2.exists() && file2.isDirectory() || file2.mkdir())) {
            throw new RuntimeException(new IOException("Cannot create temporary directory"));
        }
        file2.deleteOnExit();
        Core.init(file, file2);
    }

    public static void init(File file, File file2) {
        String string;
        InputStream inputStream;
        String string2;
        String string3 = "discord_game_sdk_jni";
        String string4 = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        String string5 = System.getProperty("os.arch").toLowerCase(Locale.ROOT);
        if (string4.contains("windows")) {
            string4 = "windows";
            string2 = string3 + ".dll";
            System.load(file.getAbsolutePath());
        } else if (string4.contains("linux")) {
            string4 = "linux";
            string2 = "lib" + string3 + ".so";
        } else if (string4.contains("mac os")) {
            string4 = "macos";
            string2 = "lib" + string3 + ".dylib";
        } else {
            throw new RuntimeException("cannot determine OS type: " + string4);
        }
        if (string5.equals("x86_64")) {
            string5 = "amd64";
        }
        if ((inputStream = Core.class.getResourceAsStream(string = "/native/" + string4 + "/" + string5 + "/" + string2)) == null) {
            throw new RuntimeException(new FileNotFoundException("cannot find native library at " + string));
        }
        File file3 = new File(file2, string2);
        file3.deleteOnExit();
        try {
            Files.copy(inputStream, file3.toPath(), new CopyOption[0]);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        System.load(file3.getAbsolutePath());
        Core.initDiscordNative(file.getAbsolutePath());
    }

    public static void init(URL uRL) {
        String string = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        String string2 = uRL.getProtocol();
        if (string2.equalsIgnoreCase("file") && (!string.contains("windows") || uRL.getFile().endsWith("discord_game_sdk.dll"))) {
            try {
                File file = new File(uRL.toURI());
                Core.init(file);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new RuntimeException(uRISyntaxException);
            }
        }
        try {
            String string3;
            InputStream inputStream = uRL.openStream();
            if (string.contains("windows")) {
                string3 = "discord_game_sdk.dll";
            } else if (string.contains("mac os")) {
                string3 = "discord_game_sdk.dylib";
            } else if (string.contains("linux")) {
                string3 = "discord_game_sdk.so";
            } else {
                throw new RuntimeException("cannot determine OS type: " + string);
            }
            File file = new File(System.getProperty("java.io.tmpdir"), "java-discord-game-sdk-" + System.nanoTime());
            if (!(file.exists() && file.isDirectory() || file.mkdir())) {
                throw new RuntimeException(new IOException("Cannot create temporary directory"));
            }
            File file2 = new File(file, string3);
            file2.deleteOnExit();
            Files.copy(inputStream, file2.toPath(), new CopyOption[0]);
            inputStream.close();
            Core.init(file2, file);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static void initFromClasspath() {
        String string;
        String string2 = "discord_game_sdk";
        String string3 = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        String string4 = System.getProperty("os.arch").toLowerCase(Locale.ROOT);
        if (string3.contains("windows")) {
            string = ".dll";
        } else if (string3.contains("linux")) {
            string = ".so";
        } else if (string3.contains("mac os")) {
            string = ".dylib";
        } else {
            throw new RuntimeException("cannot determine OS type: " + string3);
        }
        if (string4.equals("amd64")) {
            string4 = "x86_64";
        }
        String string5 = "/lib/" + string4 + "/" + string2 + string;
        Core.init(Objects.requireNonNull(Core.class.getResource(string5)));
    }

    private static File downloadDiscordLibrary() throws IOException {
        ZipEntry zipEntry;
        String string;
        String string2 = "discord_game_sdk";
        String string3 = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        String string4 = System.getProperty("os.arch").toLowerCase(Locale.ROOT);
        if (string3.contains("windows")) {
            string = ".dll";
        } else if (string3.contains("linux")) {
            string = ".so";
        } else if (string3.contains("mac os")) {
            string = ".dylib";
        } else {
            throw new RuntimeException("cannot determine OS type: " + string3);
        }
        if (string4.equals("amd64")) {
            string4 = "x86_64";
        }
        String string5 = "lib/" + string4 + "/" + string2 + string;
        URL uRL = new URL("https://dl-game-sdk.discordapp.net/2.5.6/discord_game_sdk.zip");
        ZipInputStream zipInputStream = new ZipInputStream(uRL.openStream());
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            if (zipEntry.getName().equals(string5)) {
                File file = new File(System.getProperty("java.io.tmpdir"), "java-" + string2 + System.nanoTime());
                if (!file.mkdir()) {
                    throw new IOException("Cannot create temporary directory");
                }
                file.deleteOnExit();
                File file2 = new File(file, string2 + string);
                file2.deleteOnExit();
                Files.copy(zipInputStream, file2.toPath(), new CopyOption[0]);
                zipInputStream.close();
                return file2;
            }
            zipInputStream.closeEntry();
        }
        zipInputStream.close();
        return null;
    }

    public static void initDownload() throws IOException {
        File file = Core.downloadDiscordLibrary();
        if (file == null) {
            throw new FileNotFoundException("cannot find native library in downloaded zip file");
        }
        Core.init(file);
    }

    public static native void initDiscordNative(String var0);

    public Core(CreateParams createParams) {
        this.createParams = createParams;
        Object object = this.create(createParams.getPointer());
        if (object instanceof Result) {
            throw new GameSDKException((Result)((Object)object));
        }
        this.pointer = (Long)object;
        this.setLogHook(LogLevel.DEBUG, DEFAULT_LOG_HOOK);
        this.activityManager = new ActivityManager(this.getActivityManager(this.pointer), this);
        this.userManager = new UserManager(this.getUserManager(this.pointer), this);
        this.overlayManager = new OverlayManager(this.getOverlayManager(this.pointer), this);
        this.relationshipManager = new RelationshipManager(this.getRelationshipManager(this.pointer), this);
        this.imageManager = new ImageManager(this.getImageManager(this.pointer), this);
        this.lobbyManager = new LobbyManager(this.getLobbyManager(this.pointer), this);
        this.networkManager = new NetworkManager(this.getNetworkManager(this.pointer), this);
        this.voiceManager = new VoiceManager(this.getVoiceManager(this.pointer), this);
    }

    private native Object create(long var1);

    private native void destroy(long var1);

    private native long getActivityManager(long var1);

    private native long getUserManager(long var1);

    private native long getOverlayManager(long var1);

    private native long getRelationshipManager(long var1);

    private native long getImageManager(long var1);

    private native long getLobbyManager(long var1);

    private native long getNetworkManager(long var1);

    private native long getVoiceManager(long var1);

    private native void runCallbacks(long var1);

    private native void setLogHook(long var1, int var3, BiConsumer<LogLevel, String> var4);

    public ActivityManager activityManager() {
        return this.activityManager;
    }

    public UserManager userManager() {
        return this.userManager;
    }

    public OverlayManager overlayManager() {
        return this.overlayManager;
    }

    public RelationshipManager relationshipManager() {
        return this.relationshipManager;
    }

    public ImageManager imageManager() {
        return this.imageManager;
    }

    public LobbyManager lobbyManager() {
        return this.lobbyManager;
    }

    public NetworkManager networkManager() {
        return this.networkManager;
    }

    public VoiceManager voiceManager() {
        return this.voiceManager;
    }

    public void runCallbacks() {
        this.execute(() -> this.runCallbacks(this.pointer));
    }

    public void setLogHook(LogLevel logLevel, BiConsumer<LogLevel, String> biConsumer) {
        this.execute(() -> this.setLogHook(this.pointer, logLevel.ordinal(), Objects.requireNonNull(biConsumer)));
    }

    public boolean isOpen() {
        return this.open.get();
    }

    @Override
    public void close() {
        if (this.open.compareAndSet(true, false)) {
            this.lock.lock();
            try {
                this.destroy(this.pointer);
            }
            finally {
                this.lock.unlock();
            }
            this.createParams.close();
        }
    }

    public long getPointer() {
        return this.pointer;
    }

    void execute(Runnable runnable) {
        this.execute(() -> {
            runnable.run();
            return null;
        });
    }

    <T> T execute(Supplier<T> supplier) {
        if (!this.isOpen()) {
            throw new CoreClosedException();
        }
        this.lock.lock();
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }
}

