/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.utils;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import pro.gravit.launcher.AsyncDownloader;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class Downloader {
    private static boolean isCertificatePinning = false;
    private static boolean isNoHttp2;
    protected final HttpClient client;
    protected final ExecutorService executor;
    protected final Queue<DownloadTask> tasks = new ConcurrentLinkedDeque<DownloadTask>();
    protected CompletableFuture<Void> future;

    protected Downloader(HttpClient httpClient, ExecutorService executorService) {
        this.client = httpClient;
        this.executor = executorService;
    }

    public static Downloader downloadList(List<AsyncDownloader.SizedFile> list, String string, Path path, DownloadCallback downloadCallback, ExecutorService executorService, int n) throws Exception {
        boolean bl = false;
        LogHelper.info("Download with Java 11+ HttpClient");
        if (executorService == null) {
            executorService = Executors.newWorkStealingPool(Math.min(3, n));
            bl = true;
        }
        Downloader downloader = Downloader.newDownloader(executorService);
        downloader.future = downloader.downloadFiles(list, string, path, downloadCallback, executorService, n);
        if (bl) {
            ExecutorService executorService2 = executorService;
            downloader.future = downloader.future.thenAccept(void_ -> executorService2.shutdownNow());
        }
        return downloader;
    }

    public static Downloader newDownloader(ExecutorService executorService) {
        if (executorService == null) {
            throw new NullPointerException();
        }
        HttpClient.Builder builder = HttpClient.newBuilder().version(isNoHttp2 ? HttpClient.Version.HTTP_1_1 : HttpClient.Version.HTTP_2).followRedirects(HttpClient.Redirect.NORMAL).executor(executorService);
        if (isCertificatePinning) {
            try {
                builder.sslContext(AsyncDownloader.makeSSLContext());
            }
            catch (Exception exception) {
                throw new SecurityException(exception);
            }
        }
        HttpClient httpClient = builder.build();
        return new Downloader(httpClient, executorService);
    }

    public void cancel() {
        for (DownloadTask downloadTask : this.tasks) {
            if (downloadTask.isCompleted()) continue;
            downloadTask.cancel();
        }
        this.tasks.clear();
        this.executor.shutdownNow();
    }

    public boolean isCanceled() {
        return this.executor.isTerminated();
    }

    public CompletableFuture<Void> getFuture() {
        return this.future;
    }

    public CompletableFuture<Void> downloadFiles(List<AsyncDownloader.SizedFile> list, String string, Path path, DownloadCallback downloadCallback, ExecutorService executorService, int n) throws Exception {
        URI uRI = new URI(string);
        Collections.shuffle(list);
        ConcurrentLinkedDeque<AsyncDownloader.SizedFile> concurrentLinkedDeque = new ConcurrentLinkedDeque<AsyncDownloader.SizedFile>(list);
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        AtomicInteger atomicInteger = new AtomicInteger(n);
        ConsumerObject consumerObject = new ConsumerObject();
        Consumer<HttpResponse> consumer = httpResponse -> {
            AsyncDownloader.SizedFile sizedFile;
            if (downloadCallback != null && httpResponse != null) {
                downloadCallback.onComplete((Path)httpResponse.body());
            }
            if ((sizedFile = (AsyncDownloader.SizedFile)concurrentLinkedDeque.poll()) == null) {
                if (atomicInteger.decrementAndGet() == 0) {
                    completableFuture.complete(null);
                }
                return;
            }
            try {
                DownloadTask downloadTask = this.sendAsync(sizedFile, uRI, path, downloadCallback);
                ((CompletableFuture)downloadTask.completableFuture.thenAccept((Consumer)consumerObject.next)).exceptionally(throwable -> {
                    completableFuture.completeExceptionally((Throwable)throwable);
                    return null;
                });
            }
            catch (Exception exception) {
                LogHelper.error(exception);
                completableFuture.completeExceptionally(exception);
            }
        };
        consumerObject.next = consumer;
        for (int i = 0; i < n; ++i) {
            consumer.accept(null);
        }
        return completableFuture;
    }

    protected DownloadTask sendAsync(AsyncDownloader.SizedFile sizedFile, URI uRI, Path path, DownloadCallback downloadCallback) throws Exception {
        IOHelper.createParentDirs(path.resolve(sizedFile.filePath));
        ProgressTrackingBodyHandler<Path> progressTrackingBodyHandler = this.makeBodyHandler(path.resolve(sizedFile.filePath), downloadCallback);
        CompletableFuture<HttpResponse<Path>> completableFuture = this.client.sendAsync(this.makeHttpRequest(uRI, sizedFile.urlPath), progressTrackingBodyHandler);
        AtomicReference<Object> atomicReference = new AtomicReference<Object>(null);
        atomicReference.set(new DownloadTask(progressTrackingBodyHandler, null));
        this.tasks.add(atomicReference.get());
        ((DownloadTask)atomicReference.get()).completableFuture = completableFuture.thenApply(httpResponse -> {
            this.tasks.remove(atomicReference.get());
            return httpResponse;
        });
        return atomicReference.get();
    }

    protected HttpRequest makeHttpRequest(URI uRI, String string) throws URISyntaxException {
        String string2 = uRI.getScheme();
        Object object = uRI.getHost();
        int n = uRI.getPort();
        if (n != -1) {
            object = (String)object + ":" + n;
        }
        String string3 = uRI.getPath();
        return HttpRequest.newBuilder().GET().uri(new URI(string2, (String)object, string3 + string, "", "")).header("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/45.0.2454.85 Safari/537.36").build();
    }

    protected ProgressTrackingBodyHandler<Path> makeBodyHandler(Path path, DownloadCallback downloadCallback) {
        return new ProgressTrackingBodyHandler<Path>(HttpResponse.BodyHandlers.ofFile(path, StandardOpenOption.CREATE, StandardOpenOption.WRITE), downloadCallback);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface DownloadCallback {
        public void apply(long var1);

        public void onComplete(Path var1);
    }

    public static class DownloadTask {
        public final ProgressTrackingBodyHandler<Path> bodyHandler;
        public CompletableFuture<HttpResponse<Path>> completableFuture;

        public DownloadTask(ProgressTrackingBodyHandler<Path> progressTrackingBodyHandler, CompletableFuture<HttpResponse<Path>> completableFuture) {
            this.bodyHandler = progressTrackingBodyHandler;
            this.completableFuture = completableFuture;
        }

        public boolean isCompleted() {
            return this.completableFuture.isDone() | this.completableFuture.isCompletedExceptionally();
        }

        public void cancel() {
            this.bodyHandler.cancel();
        }
    }

    private static class ConsumerObject {
        Consumer<HttpResponse<Path>> next = null;

        private ConsumerObject() {
        }
    }

    public static class ProgressTrackingBodyHandler<T>
    implements HttpResponse.BodyHandler<T> {
        private final HttpResponse.BodyHandler<T> delegate;
        private final DownloadCallback callback;
        private ProgressTrackingBodySubscriber subscriber;
        private boolean isCanceled = false;

        public ProgressTrackingBodyHandler(HttpResponse.BodyHandler<T> bodyHandler, DownloadCallback downloadCallback) {
            this.delegate = bodyHandler;
            this.callback = downloadCallback;
        }

        @Override
        public HttpResponse.BodySubscriber<T> apply(HttpResponse.ResponseInfo responseInfo) {
            this.subscriber = new ProgressTrackingBodySubscriber(this.delegate.apply(responseInfo));
            if (this.isCanceled) {
                this.subscriber.cancel();
            }
            return this.subscriber;
        }

        public void cancel() {
            this.isCanceled = true;
            if (this.subscriber != null) {
                this.subscriber.cancel();
            }
        }

        private class ProgressTrackingBodySubscriber
        implements HttpResponse.BodySubscriber<T> {
            private final HttpResponse.BodySubscriber<T> delegate;
            private Flow.Subscription subscription;
            private boolean isCanceled = false;

            public ProgressTrackingBodySubscriber(HttpResponse.BodySubscriber<T> bodySubscriber) {
                this.delegate = bodySubscriber;
            }

            @Override
            public CompletionStage<T> getBody() {
                return this.delegate.getBody();
            }

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                this.subscription = subscription;
                if (this.isCanceled) {
                    subscription.cancel();
                }
                this.delegate.onSubscribe(subscription);
            }

            @Override
            public void onNext(List<ByteBuffer> list) {
                long l = 0L;
                for (ByteBuffer byteBuffer : list) {
                    l += (long)byteBuffer.remaining();
                }
                if (ProgressTrackingBodyHandler.this.callback != null) {
                    ProgressTrackingBodyHandler.this.callback.apply(l);
                }
                this.delegate.onNext(list);
            }

            @Override
            public void onError(Throwable throwable) {
                this.delegate.onError(throwable);
            }

            @Override
            public void onComplete() {
                this.delegate.onComplete();
            }

            public void cancel() {
                this.isCanceled = true;
                if (this.subscription != null) {
                    this.subscription.cancel();
                }
            }
        }
    }
}

