/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.vanilla.provider;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IModInfo;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.IWailaConfig;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.api.component.ItemComponent;
import mcp.mobius.waila.plugin.vanilla.config.EnchantmentDisplayMode;
import mcp.mobius.waila.plugin.vanilla.config.Options;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3544;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9302;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import net.minecraft.class_9636;
import org.jetbrains.annotations.Nullable;

public enum ItemEntityProvider implements IEntityComponentProvider
{
    INSTANCE;

    private static final class_2960 AUTHOR;
    private static final class_2960 GENERATION;
    private static long lastEnchantmentTime;
    private static int enchantmentIndex;
    private static int curseIndex;

    @Override
    @Nullable
    public class_1297 getOverride(IEntityAccessor accessor, IPluginConfig config) {
        return !config.getBoolean(Options.ENTITY_ITEM_ENTITY) ? EMPTY_ENTITY : null;
    }

    @Override
    public ITooltipComponent getIcon(IEntityAccessor accessor, IPluginConfig config) {
        return new ItemComponent(((class_1542)accessor.getEntity()).method_6983());
    }

    @Override
    public void appendHead(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
        IWailaConfig.Formatter formatter = IWailaConfig.get().getFormatter();
        class_1799 stack = ((class_1542)accessor.getEntity()).method_6983();
        tooltip.setLine(WailaConstants.OBJECT_NAME_TAG, formatter.entityName(stack.method_7964().getString()));
        if (config.getBoolean(WailaConstants.CONFIG_SHOW_REGISTRY)) {
            tooltip.setLine(WailaConstants.REGISTRY_NAME_TAG, formatter.registryName(class_7923.field_41178.method_10221((Object)stack.method_7909())));
        }
    }

    @Override
    public void appendBody(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
        class_1799 stack = ((class_1542)accessor.getEntity()).method_6983();
        ItemEntityProvider.appendBookProperties(tooltip, stack, config);
    }

    @Override
    public void appendTail(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
        if (config.getBoolean(WailaConstants.CONFIG_SHOW_MOD_NAME)) {
            String mod = IModInfo.get(((class_1542)accessor.getEntity()).method_6983()).getName();
            tooltip.setLine(WailaConstants.MOD_NAME_TAG, IWailaConfig.get().getFormatter().modName(mod));
        }
    }

    public static void appendBookProperties(ITooltip tooltip, class_1799 stack, IPluginConfig config) {
        if (stack.method_31574(class_1802.field_8598)) {
            EnchantmentDisplayMode mode = (EnchantmentDisplayMode)((Object)config.getEnum(Options.BOOK_ENCHANTMENT_DISPLAY_MODE));
            if (mode == EnchantmentDisplayMode.DISABLED) {
                return;
            }
            if (mode == EnchantmentDisplayMode.CYCLE) {
                class_1889 instance;
                int enchantmentTiming = config.getInt(Options.BOOK_ENCHANTMENT_CYCLE_TIMING);
                class_9304 enchantmentsComponent = (class_9304)stack.method_58695(class_9334.field_49643, (Object)class_9304.field_49385);
                long now = System.currentTimeMillis();
                ArrayList<class_1889> enchantments = new ArrayList<class_1889>();
                ArrayList<class_1889> curses = new ArrayList<class_1889>();
                for (Object2IntMap.Entry entry : enchantmentsComponent.method_57539()) {
                    class_6880 enchantment = (class_6880)entry.getKey();
                    int level = entry.getIntValue();
                    class_1889 instance2 = new class_1889(enchantment, level);
                    if (enchantment.method_40220(class_9636.field_51551)) {
                        curses.add(instance2);
                        continue;
                    }
                    enchantments.add(instance2);
                }
                if (now - lastEnchantmentTime >= (long)enchantmentTiming) {
                    lastEnchantmentTime = now;
                    ++curseIndex;
                    if (++enchantmentIndex > enchantments.size() - 1) {
                        enchantmentIndex = 0;
                    }
                    if (curseIndex > curses.size() - 1) {
                        curseIndex = 0;
                    }
                }
                Object text = null;
                if (!enchantments.isEmpty()) {
                    instance = (class_1889)enchantments.get(enchantmentIndex);
                    text = class_1887.method_8179((class_6880)instance.comp_3486(), (int)instance.comp_3487());
                }
                if (!curses.isEmpty()) {
                    instance = (class_1889)curses.get(curseIndex);
                    class_2561 curse = class_1887.method_8179((class_6880)instance.comp_3486(), (int)instance.comp_3487());
                    text = text == null ? curse : text.method_27661().method_10852(class_5244.field_33849).method_10852(curse);
                }
                if (text != null) {
                    tooltip.setLine(Options.BOOK_ENCHANTMENT_DISPLAY_MODE, (class_2561)text);
                }
            } else {
                class_9304 enchantments = (class_9304)stack.method_58695(class_9334.field_49643, (Object)class_9304.field_49385);
                class_5250 text = null;
                if (mode == EnchantmentDisplayMode.COMBINED) {
                    class_5250 enchantmentLine = null;
                    class_5250 curseLine = null;
                    for (Object2IntMap.Entry entry : enchantments.method_57539()) {
                        class_6880 enchantment = (class_6880)entry.getKey();
                        int level = entry.getIntValue();
                        class_2561 name = class_1887.method_8179((class_6880)enchantment, (int)level);
                        if (enchantment.method_40220(class_9636.field_51551)) {
                            if (curseLine == null) {
                                curseLine = class_2561.method_43473().method_10852(name);
                                continue;
                            }
                            curseLine.method_10852((class_2561)class_2561.method_43470((String)", ")).method_10852(name);
                            continue;
                        }
                        if (enchantmentLine == null) {
                            enchantmentLine = class_2561.method_43473().method_10852(name);
                            continue;
                        }
                        enchantmentLine.method_10852((class_2561)class_2561.method_43470((String)", ")).method_10852(name);
                    }
                    if (enchantmentLine != null) {
                        text = enchantmentLine;
                    }
                    if (curseLine != null) {
                        if (text == null) {
                            text = curseLine;
                        } else {
                            text.method_10852(class_5244.field_33849).method_10852(curseLine);
                        }
                    }
                } else {
                    for (Object2IntMap.Entry entry : enchantments.method_57539()) {
                        class_2561 name = class_1887.method_8179((class_6880)((class_6880)entry.getKey()), (int)entry.getIntValue());
                        if (text == null) {
                            text = class_2561.method_43473().method_10852(name);
                            continue;
                        }
                        text.method_10852(class_5244.field_33849).method_10852(name);
                    }
                }
                if (text != null) {
                    tooltip.setLine(Options.BOOK_ENCHANTMENT_DISPLAY_MODE, (class_2561)text);
                }
            }
        } else if (stack.method_31574(class_1802.field_8360)) {
            if (!config.getBoolean(Options.BOOK_WRITTEN)) {
                return;
            }
            class_9302 tag = (class_9302)stack.method_58694(class_9334.field_49606);
            if (tag == null) {
                return;
            }
            if (!class_3544.method_15438((String)tag.comp_2420())) {
                tooltip.setLine(AUTHOR, (class_2561)class_2561.method_43469((String)"book.byAuthor", (Object[])new Object[]{tag.comp_2420()}));
            }
            tooltip.setLine(GENERATION, (class_2561)class_2561.method_43471((String)("book.generation." + tag.comp_2421())));
        }
    }

    static {
        AUTHOR = Options.BOOK_WRITTEN.method_48331(".author");
        GENERATION = Options.BOOK_WRITTEN.method_48331(".generation");
        lastEnchantmentTime = 0L;
        enchantmentIndex = 0;
        curseIndex = 0;
    }
}

