/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.impl.color;

import com.google.common.base.Preconditions;
import com.misterpemodder.shulkerboxtooltip.ShulkerBoxTooltip;
import com.misterpemodder.shulkerboxtooltip.api.color.ColorKey;
import com.misterpemodder.shulkerboxtooltip.api.color.ColorRegistry;
import com.misterpemodder.shulkerboxtooltip.impl.util.ShulkerBoxTooltipUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;

@Environment(value=EnvType.CLIENT)
public final class ColorRegistryImpl
implements ColorRegistry {
    private final Map<class_2960, Category> categories = new HashMap<class_2960, Category>();
    private final Map<class_2960, Category> emptyCategories = new HashMap<class_2960, Category>();
    private final Map<class_2960, ColorRegistry.Category> categoriesView = Collections.unmodifiableMap(this.categories);
    private boolean locked = true;
    private int registeredKeysCount = 0;
    public static final ColorRegistryImpl INSTANCE = new ColorRegistryImpl();

    @Override
    @Nonnull
    public Category category(class_2960 categoryId) {
        Category category = this.categories.get(categoryId);
        if (category == null) {
            return this.emptyCategories.computeIfAbsent(categoryId, x$0 -> new Category((class_2960)x$0));
        }
        return category;
    }

    @Override
    @Nonnull
    public ColorRegistry.Category defaultCategory() {
        return this.category(ShulkerBoxTooltipUtil.id("default"));
    }

    @Override
    @Nonnull
    public Map<class_2960, ColorRegistry.Category> categories() {
        return this.categoriesView;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public void resetRegisteredKeysCount() {
        this.registeredKeysCount = 0;
    }

    public int registeredKeysCount() {
        return this.registeredKeysCount;
    }

    public final class Category
    implements ColorRegistry.Category {
        private final class_2960 id;
        private Map<String, ColorKey> keys = null;
        private Map<ColorKey, String> unlocalizedNames = Collections.emptyMap();
        private Map<String, ColorKey> keysView = Collections.emptyMap();
        private Map<String, Integer> lateKeyValues = null;

        public Category(class_2960 id) {
            this.id = id;
        }

        @Override
        @Nullable
        public ColorKey key(String colorId) {
            return this.keysView.get(colorId);
        }

        public void setRgbKeyLater(String colorId, int rgb) {
            if (this.lateKeyValues == null) {
                this.lateKeyValues = new HashMap<String, Integer>();
            }
            this.lateKeyValues.put(colorId, rgb);
        }

        @Override
        @Nullable
        public String keyUnlocalizedName(ColorKey key) {
            return this.unlocalizedNames.get(key);
        }

        @Override
        public ColorRegistry.Category register(ColorKey key, String colorId, @Nullable String unlocalizedName) {
            Preconditions.checkNotNull((Object)key, (Object)"cannot register null color key");
            Preconditions.checkNotNull((Object)colorId, (Object)"cannot register null color ID");
            if (ColorRegistryImpl.this.locked) {
                throw new IllegalStateException("Cannot register color keys outside the scope of ShulkerBoxTooltipApi.registerColors()");
            }
            this.registerSelf();
            this.registerKey(key, colorId, unlocalizedName);
            this.setLateKeyValue(key, colorId);
            return this;
        }

        private void registerSelf() {
            if (this.keys != null) {
                return;
            }
            this.keys = new LinkedHashMap<String, ColorKey>();
            this.unlocalizedNames = new HashMap<ColorKey, String>();
            this.keysView = Collections.unmodifiableMap(this.keys);
            ColorRegistryImpl.this.categories.put(this.id, this);
            ColorRegistryImpl.this.emptyCategories.remove(this.id);
        }

        private void registerKey(ColorKey key, String colorId, @Nullable String unlocalizedName) {
            if (this.keys.containsKey(colorId)) {
                ShulkerBoxTooltip.LOGGER.warn("Overriding color key " + colorId + " for category " + String.valueOf(this.id));
            }
            if (unlocalizedName == null) {
                unlocalizedName = "shulkerboxtooltip.colors." + this.id.method_12836() + "." + this.id.method_12832() + "." + colorId;
            }
            this.keys.put(colorId, key);
            this.unlocalizedNames.put(key, (String)unlocalizedName);
            ++ColorRegistryImpl.this.registeredKeysCount;
        }

        private void setLateKeyValue(ColorKey key, String colorId) {
            if (this.lateKeyValues != null && this.lateKeyValues.containsKey(colorId)) {
                key.setRgb(this.lateKeyValues.get(colorId));
                this.lateKeyValues.remove(colorId);
            }
        }

        @Override
        public Map<String, ColorKey> keys() {
            return this.keysView;
        }
    }
}

