/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.waypoint;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import journeymap.api.v2.common.waypoint.Waypoint;
import journeymap.api.v2.common.waypoint.WaypointGroup;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.waypoint.ClientWaypointImpl;
import journeymap.client.waypoint.WaypointHandler;
import journeymap.common.Journeymap;
import journeymap.common.nbt.waypoint.WaypointDAO;
import journeymap.common.waypoint.WaypointGroupImpl;
import journeymap.common.waypoint.WaypointStore;
import journeymap.common.waypoint.predefined.AllWaypointsGroup;
import journeymap.common.waypoint.predefined.DeathWaypointGroup;
import journeymap.common.waypoint.predefined.LockedGroup;

@ParametersAreNonnullByDefault
public class WaypointGroupStore {
    private static WaypointGroupStore INSTANCE;
    public static final WaypointGroup DEFAULT;
    public static final WaypointGroup DEATH;
    public static final WaypointGroup TEMP;
    public static final WaypointGroup ALL;
    private final Map<String, WaypointGroup> groupMap = new LinkedHashMap<String, WaypointGroup>();

    public static WaypointGroupStore getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new WaypointGroupStore();
        }
        return INSTANCE;
    }

    public static String getDisplaySetting(String key, String defaultValue) {
        return WaypointGroupStore.getInstance().get(ALL.getGuid()).getSettings().getDisplaySetting(key, defaultValue);
    }

    public static String setDisplaySetting(String key, String value) {
        return WaypointGroupStore.getInstance().get(ALL.getGuid()).getSettings().setDisplaySetting(key, value);
    }

    public WaypointGroupImpl get(String guid) {
        return (WaypointGroupImpl)(this.groupMap.get(guid) == null ? this.groupMap.get(DEFAULT.getGuid()) : this.groupMap.get(guid));
    }

    public WaypointGroupImpl getNullable(String guid) {
        return (WaypointGroupImpl)this.groupMap.get(guid);
    }

    public List<Waypoint> getWaypoints(WaypointGroup group) {
        ArrayList<Waypoint> waypoints = new ArrayList<Waypoint>();
        WaypointStore.getInstance().getAll().forEach(wp -> {
            if (wp.getGroupId().equals(group.getGuid())) {
                waypoints.add((Waypoint)wp);
            }
        });
        return waypoints;
    }

    public void put(WaypointGroup waypointGroup) {
        WaypointDAO dao = WaypointHandler.getInstance().getDao();
        this.groupMap.put(waypointGroup.getGuid(), waypointGroup);
        if (waypointGroup.isPersistent()) {
            dao.addGroup(waypointGroup);
        }
        this.bulkSave();
    }

    public void remove(WaypointGroup waypointGroup) {
        WaypointDAO dao = WaypointHandler.getInstance().getDao();
        List<Waypoint> waypointsInGroup = this.getWaypoints(waypointGroup);
        this.groupMap.remove(waypointGroup.getGuid());
        dao.deleteGroup(waypointGroup);
        waypointsInGroup.forEach(wp -> WaypointStore.getInstance().remove((ClientWaypointImpl)wp, false));
        dao.save(true);
    }

    public void reset() {
        this.groupMap.clear();
        if (JourneymapClient.getInstance().getWaypointProperties().managerEnabled.get().booleanValue()) {
            this.load();
        }
    }

    public boolean transferWaypoint(WaypointGroup to, String waypointId) {
        if (this.groupMap.get(to.getGuid()) == null) {
            WaypointGroup group;
            if (!"journeymap".equals(to.getModId()) && (group = (WaypointGroup)this.groupMap.values().stream().filter(grp -> grp.getName().equals(to.getName()) && grp.getModId().equals(to.getModId())).findFirst().orElse(null)) != null) {
                return this.transfer(group, waypointId);
            }
            this.put(to);
        }
        return this.transfer(to, waypointId);
    }

    private boolean transfer(WaypointGroup to, String waypointId) {
        ClientWaypointImpl waypoint = WaypointStore.getInstance().get(waypointId);
        if (this.canTransferWaypoint(to, waypoint)) {
            waypoint.setGroupId(to.getGuid());
            WaypointStore.getInstance().save(waypoint, false);
            return true;
        }
        return false;
    }

    public boolean canTransferWaypoint(WaypointGroup to, Waypoint waypoint) {
        WaypointGroupImpl from = this.get(waypoint.getGroupId());
        return !(from == null || this.isLockedGroup(to) && !TEMP.getGuid().equals(to.getGuid()) || this.isLockedGroup(from) && !TEMP.getGuid().equals(from.getGuid()) || ALL.getGuid().equals(to.getGuid()) || from.getGuid().equals(to.getGuid()));
    }

    private boolean isLockedGroup(WaypointGroup group) {
        return DEATH.getGuid().equals(group.getGuid()) || TEMP.getGuid().equals(group.getGuid()) || group.isLocked();
    }

    private void load() {
        WaypointDAO dao = WaypointHandler.getInstance().getDao();
        this.groupMap.putAll(dao.getGroups());
        Journeymap.getLogger().info("Loaded {} waypoint groups from disk.", (Object)this.groupMap.size());
        if (this.groupMap.isEmpty()) {
            this.put(ALL);
            this.put(DEFAULT);
            this.put(DEATH);
            this.put(TEMP);
        } else {
            if (this.groupMap.get(ALL.getGuid()) == null || !this.groupMap.get(ALL.getGuid()).getName().equals(ALL.getName())) {
                this.put(ALL);
            }
            if (this.groupMap.get(DEFAULT.getGuid()) == null || !this.groupMap.get(DEFAULT.getGuid()).getName().equals(DEFAULT.getName())) {
                this.put(DEFAULT);
            }
            if (this.groupMap.get(DEATH.getGuid()) == null || !this.groupMap.get(DEATH.getGuid()).getName().equals(DEATH.getName())) {
                this.put(DEATH);
            }
            if (this.groupMap.get(TEMP.getGuid()) == null || !this.groupMap.get(TEMP.getGuid()).getName().equals(TEMP.getName())) {
                this.put(TEMP);
            }
        }
    }

    public void bulkSave() {
        WaypointDAO dao = WaypointHandler.getInstance().getDao();
        for (WaypointGroup group : this.groupMap.values()) {
            WaypointGroupImpl impl = (WaypointGroupImpl)group;
            if (!impl.isDirty() || !group.isPersistent()) continue;
            impl.setDirty(false);
            dao.addGroup(impl);
        }
        dao.save(true);
    }

    public List<WaypointGroup> getAll() {
        return this.groupMap.values().stream().toList();
    }

    public List<WaypointGroup> getForMod(String modId) {
        return this.groupMap.values().stream().filter(group -> modId.equals(group.getModId())).toList();
    }

    public List<String> getWaypointsIds(WaypointGroupImpl waypointGroup) {
        return this.getWaypoints(waypointGroup).stream().map(Waypoint::getGuid).toList();
    }

    public void remove(WaypointGroup group, Boolean deleteWaypoints) {
        if (deleteWaypoints.booleanValue()) {
            WaypointStore.getInstance().remove(group);
        } else {
            group.getWaypointIds().forEach(id -> this.transferWaypoint(DEFAULT, (String)id));
        }
        this.remove(group);
    }

    public void removeAll(String modId, boolean deleteWaypoints) {
        this.getForMod(modId).forEach(g -> this.remove((WaypointGroup)g, deleteWaypoints));
    }

    public static boolean isNative(WaypointGroup group) {
        return ALL.getGuid().equals(group.getGuid()) || TEMP.getGuid().equals(group.getGuid()) || DEFAULT.getGuid().equals(group.getGuid()) || DEATH.getGuid().equals(group.getGuid());
    }

    static {
        DEFAULT = new WaypointGroupImpl("journeymap", Constants.getString("jm.waypoint.groups.default.name"), "journeymap_default");
        DEATH = new DeathWaypointGroup("journeymap", Constants.getString("jm.waypoint.groups.death.name"), "journeymap_death");
        TEMP = new LockedGroup("journeymap", Constants.getString("jm.waypoint.groups.temp.name"), "journeymap_temp");
        ALL = new AllWaypointsGroup("journeymap", Constants.getString("jm.waypoint.groups.all.name"), "journeymap_all");
    }
}

