/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.util;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_3193;
import net.minecraft.class_3194;
import org.jetbrains.annotations.Nullable;

public class LoadedChunksToPoints {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PolygonData recalculateChunks(Iterable<class_3193> chunks) {
        HashMap<class_3194, HashMultimap> statusMap = new HashMap<class_3194, HashMultimap>();
        statusMap.put(class_3194.field_44855, HashMultimap.create());
        statusMap.put(class_3194.field_44856, HashMultimap.create());
        statusMap.put(class_3194.field_13877, HashMultimap.create());
        statusMap.put(class_3194.field_19334, HashMultimap.create());
        Iterable<class_3193> iterable = chunks;
        synchronized (iterable) {
            for (class_3193 holder : chunks) {
                class_1923 chunk = holder.method_60473();
                class_3194 status = holder.method_60474();
                Multimap edges = (Multimap)statusMap.get(status);
                LoadedChunksToPoints.addNewEdge((Multimap<class_1923, class_1923>)edges, new class_1923(chunk.field_9181, chunk.field_9180), new class_1923(chunk.field_9181 + 1, chunk.field_9180));
                LoadedChunksToPoints.addNewEdge((Multimap<class_1923, class_1923>)edges, new class_1923(chunk.field_9181 + 1, chunk.field_9180), new class_1923(chunk.field_9181 + 1, chunk.field_9180 + 1));
                LoadedChunksToPoints.addNewEdge((Multimap<class_1923, class_1923>)edges, new class_1923(chunk.field_9181 + 1, chunk.field_9180 + 1), new class_1923(chunk.field_9181, chunk.field_9180 + 1));
                LoadedChunksToPoints.addNewEdge((Multimap<class_1923, class_1923>)edges, new class_1923(chunk.field_9181, chunk.field_9180 + 1), new class_1923(chunk.field_9181, chunk.field_9180));
            }
        }
        List<Polygon> full = LoadedChunksToPoints.buildPolygon((Multimap<class_1923, class_1923>)((Multimap)statusMap.get(class_3194.field_44855)));
        List<Polygon> block = LoadedChunksToPoints.buildPolygon((Multimap<class_1923, class_1923>)((Multimap)statusMap.get(class_3194.field_44856)));
        List<Polygon> entity = LoadedChunksToPoints.buildPolygon((Multimap<class_1923, class_1923>)((Multimap)statusMap.get(class_3194.field_13877)));
        List<Polygon> inaccessible = LoadedChunksToPoints.buildPolygon((Multimap<class_1923, class_1923>)((Multimap)statusMap.get(class_3194.field_19334)));
        return new PolygonData(full, entity, block, inaccessible);
    }

    private static List<Polygon> buildPolygon(Multimap<class_1923, class_1923> edges) {
        ArrayList<Polygon> polygonOverlays = new ArrayList<Polygon>();
        ArrayList outerPolygons = new ArrayList();
        HashMultimap holesPolygons = HashMultimap.create();
        while (!edges.isEmpty()) {
            boolean clockwise;
            class_1923 edge2;
            class_1923 starting = (class_1923)Collections.min(edges.keySet(), (e1, e2) -> e1.field_9181 == e2.field_9181 ? e1.field_9180 - e2.field_9180 : e1.field_9181 - e2.field_9181);
            ArrayList<class_1923> arrayList = new ArrayList<class_1923>();
            Object edge = starting;
            int direction = 1;
            do {
                arrayList.add((class_1923)edge);
                Iterator it = edges.get(edge).iterator();
                edge2 = (class_1923)it.next();
                while (it.hasNext() && Integer.signum(direction) == Integer.signum(edge2.field_9181 - ((class_1923)edge).field_9181 + ((class_1923)edge).field_9180 - edge2.field_9180)) {
                    edge2 = (class_1923)it.next();
                }
                edges.remove(edge, (Object)edge2);
                direction = edge2.field_9181 - ((class_1923)edge).field_9181 + edge2.field_9180 - ((class_1923)edge).field_9180;
            } while (!(edge = edge2).equals((Object)starting));
            boolean bl = clockwise = ((class_1923)arrayList.get((int)0)).field_9181 != ((class_1923)arrayList.get((int)1)).field_9181;
            if (clockwise) {
                outerPolygons.add(arrayList);
                continue;
            }
            class_1923 ray = (class_1923)arrayList.getFirst();
            class_1923 outerFound = null;
            for (int i = 0; i < 999; ++i) {
                for (List list : outerPolygons) {
                    class_1923 outerStart = (class_1923)list.getFirst();
                    if (list.contains(ray)) {
                        outerFound = outerStart;
                        break;
                    }
                    for (List hole : holesPolygons.get((Object)outerStart)) {
                        if (!hole.contains(ray)) continue;
                        outerFound = outerStart;
                        break;
                    }
                    if (outerFound == null) continue;
                    break;
                }
                if (outerFound != null) break;
                ray = new class_1923(ray.field_9181 - 1, ray.field_9180);
            }
            if (outerFound == null) continue;
            holesPolygons.put(outerFound, arrayList);
        }
        for (List list : outerPolygons) {
            LoadedChunksToPoints.removeCollinear(list);
            for (List hole : holesPolygons.get((Object)((class_1923)list.getFirst()))) {
                LoadedChunksToPoints.removeCollinear(hole);
            }
        }
        for (List list : outerPolygons) {
            Points polygon = new Points(list.stream().map(c -> new class_2338(c.method_8326(), 70, c.method_8328()).method_10063()).toList());
            ArrayList<Points> polygonHoles = null;
            if (holesPolygons.containsKey(list.getFirst())) {
                polygonHoles = new ArrayList<Points>();
                for (List hole : holesPolygons.get((Object)((class_1923)list.getFirst()))) {
                    polygonHoles.add(new Points(hole.stream().map(c -> new class_2338(c.method_8326(), 70, c.method_8328()).method_10063()).toList()));
                }
            }
            polygonOverlays.add(new Polygon(polygon, polygonHoles));
        }
        return polygonOverlays;
    }

    private static void removeCollinear(List<class_1923> chunks) {
        if (chunks.size() <= 4) {
            return;
        }
        class_1923 prev = chunks.getFirst();
        for (int i = chunks.size() - 1; i > 0; --i) {
            class_1923 next = chunks.get(i - 1);
            if (prev.field_9181 == next.field_9181 || prev.field_9180 == next.field_9180) {
                chunks.remove(i);
            }
            if (i >= chunks.size()) continue;
            prev = chunks.get(i);
        }
    }

    private static void addNewEdge(Multimap<class_1923, class_1923> edges, class_1923 from, class_1923 to) {
        if (!edges.remove((Object)to, (Object)from)) {
            edges.put((Object)from, (Object)to);
        }
    }

    public record PolygonData(List<Polygon> full, List<Polygon> entity, List<Polygon> block, List<Polygon> inaccessible) {
        public static final Gson GSON = new GsonBuilder().create();

        public String toJsonString() {
            return GSON.toJson((Object)this);
        }
    }

    record Points(List<Long> points) {
    }

    record Polygon(Points outerArea, @Nullable List<Points> holes) {
    }
}

