/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.waypointmanager.waypoint;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.ui.component.Slot;
import journeymap.client.ui.component.buttons.CheckBox;
import journeymap.client.ui.component.widgets.StringWidget;
import journeymap.client.ui.option.SlotMetadata;
import journeymap.client.ui.waypointmanager.ManagerSlot;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_5481;
import net.minecraft.class_7843;
import net.minecraft.class_7847;
import net.minecraft.class_8021;
import net.minecraft.class_8030;
import net.minecraft.class_8133;
import net.minecraft.class_8667;
import org.jetbrains.annotations.NotNull;

public class DimensionSlot
extends ManagerSlot {
    private final String dimName;
    private final String dimId;
    private class_2561 enabledText;
    private class_2561 disabledText;
    private StringWidget nameWidget;
    private CheckBox checkBox;
    private boolean enabled;
    private boolean primary;
    private ManagerSlot.ToolTipMeta tooltip;
    private class_8667 layout = class_8667.method_52742();

    public DimensionSlot(String dimId, String dimName, boolean enabled, boolean primary) {
        this.dimId = dimId;
        this.dimName = dimName;
        this.enabled = enabled;
        this.primary = primary;
        this.enabledText = class_2561.method_43470((String)dimName);
        this.disabledText = class_2561.method_43470((String)dimName).method_27692(class_124.field_1080).method_27692(class_124.field_1055);
        this.tooltip = new ManagerSlot.ToolTipMeta(new ArrayList<class_5481>(Collections.singleton(class_5481.method_30747((String)this.dimId, (class_2583)class_2583.field_24360))));
    }

    @Override
    public void repositionElements() {
        this.layout.method_48222();
        class_7843.method_48634((class_8021)this.layout, (class_8030)this.method_48202());
    }

    @Override
    public void init() {
        class_327 font = class_310.method_1551().field_1772;
        this.nameWidget = (StringWidget)this.layout.method_52738((class_8021)new StringWidget(this.enabled ? this.enabledText : this.disabledText, 85, font).alignLeft(), class_7847::method_46474);
        this.checkBox = (CheckBox)this.layout.method_52738((class_8021)new CheckBox("", this.primary, this::onPrimaryCheck), class_7847::method_46470);
        this.checkBox.setDrawText(false);
        this.repositionElements();
    }

    private void onPrimaryCheck(class_4185 button) {
        this.primary = ((CheckBox)button).getToggled();
    }

    @Override
    public class_8133 getLayout() {
        return this.layout;
    }

    @Override
    public void setEnabled(boolean selected) {
        this.enabled = selected;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public void setPrimary(boolean primary) {
        this.primary = primary;
        this.checkBox.setToggled(primary);
    }

    public void method_25343(class_332 graphics, int slotIndex, int y, int x, int rowWidth, int itemHeight, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
        this.layout.method_46421(x + 3);
        this.layout.method_46419(y + 2);
        Integer color = isMouseOver ? backgroundHover : background;
        float alpha = isMouseOver ? 1.0f : 0.4f;
        DrawUtil.drawRectangle(graphics, x, y, rowWidth - 8, itemHeight, color, alpha);
        this.layout.method_48206(widget -> widget.method_25394(graphics, mouseX, mouseY, partialTicks));
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        boolean clicked = super.method_25402(mouseX, mouseY, button);
        if (!this.checkBox.method_25405(mouseX, mouseY)) {
            this.enabled = !this.enabled;
            this.nameWidget.method_25355(this.enabled ? this.enabledText : this.disabledText);
        }
        return clicked;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getDimId() {
        return this.dimId;
    }

    @Override
    public int compareTo(@NotNull ManagerSlot o) {
        return 0;
    }

    @Override
    public Collection<SlotMetadata> getMetadata() {
        return null;
    }

    @Override
    public List<? extends Slot> getChildSlots(int listWidth, int columnWidth) {
        return null;
    }

    @Override
    public SlotMetadata getLastPressed() {
        return null;
    }

    @Override
    public SlotMetadata getCurrentTooltip() {
        AtomicBoolean showTooltip = new AtomicBoolean(true);
        this.layout.method_48206(widget -> {
            class_4185 button;
            if (widget instanceof class_4185 && (button = (class_4185)widget).method_49606()) {
                showTooltip.set(false);
            }
        });
        return showTooltip.get() ? this.tooltip : null;
    }

    @Override
    public int getColumnWidth() {
        return 0;
    }

    @Override
    public boolean contains(SlotMetadata slotMetadata) {
        return false;
    }
}

