/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.dialog.import_export;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import journeymap.client.ui.dialog.import_export.ImportPopup;

public class ImportZipPopup
extends ImportPopup {
    protected ImportZipPopup(File zipFileToImport) {
        super(zipFileToImport);
    }

    @Override
    protected Set<String> scanForFolders() throws IOException {
        return this.scanZipForFolders(this.sourceFile);
    }

    @Override
    protected void importFolders(Set<String> selectedFolders) throws IOException {
        if (!this.sourceFile.isFile() || !this.sourceFile.getName().toLowerCase().endsWith(".zip")) {
            throw new IOException("Selected source is not a zip file.");
        }
        this.extractZipFile(this.sourceFile, this.jmWorldDir, selectedFolders);
    }

    private Set<String> scanZipForFolders(File zipFile) throws IOException {
        TreeSet<String> topLevelFolders = new TreeSet<String>();
        try (ZipInputStream zipIn = new ZipInputStream(new FileInputStream(zipFile));){
            ZipEntry entry = zipIn.getNextEntry();
            while (entry != null) {
                String path = entry.getName();
                int firstSlashIndex = path.indexOf(47);
                if (firstSlashIndex > 0) {
                    String topLevelFolder = path.substring(0, firstSlashIndex);
                    topLevelFolders.add(topLevelFolder);
                }
                zipIn.closeEntry();
                entry = zipIn.getNextEntry();
            }
        }
        return topLevelFolders;
    }

    private void extractZipFile(File zipFile, File destDir, Set<String> selectedFolders) throws IOException {
        try (ZipInputStream zipIn = new ZipInputStream(new FileInputStream(zipFile));){
            ZipEntry entry = zipIn.getNextEntry();
            while (entry != null) {
                String filePath = entry.getName();
                boolean shouldExtract = false;
                for (String folder : selectedFolders) {
                    if (!filePath.startsWith(folder + "/") && !filePath.equals(folder + "/")) continue;
                    shouldExtract = true;
                    break;
                }
                if (shouldExtract) {
                    File newFile = new File(destDir, filePath);
                    if (entry.isDirectory()) {
                        newFile.mkdirs();
                    } else {
                        new File(newFile.getParent()).mkdirs();
                        try (FileOutputStream fos = new FileOutputStream(newFile);){
                            int len;
                            byte[] buffer = new byte[1024];
                            while ((len = zipIn.read(buffer)) > 0) {
                                fos.write(buffer, 0, len);
                            }
                        }
                    }
                }
                zipIn.closeEntry();
                entry = zipIn.getNextEntry();
            }
        }
    }
}

