/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.common.network.objects;

import com.zigythebird.playeranimcore.animation.Animation;
import com.zigythebird.playeranimcore.network.AnimationBinary;
import io.github.kosmx.emotes.common.network.objects.AbstractNetworkPacket;
import io.github.kosmx.emotes.common.network.objects.NetData;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.nio.ByteBuffer;

public class NewAnimPacket
extends AbstractNetworkPacket {
    @Override
    public byte getID() {
        return -103;
    }

    @Override
    public byte getVer() {
        return 1;
    }

    @Override
    public void read(ByteBuffer buf, NetData config, int version) throws IOException {
        config.tick = buf.getFloat();
        config.emoteData = AnimationBinary.read((ByteBuf)Unpooled.wrappedBuffer((ByteBuffer)buf));
        config.valid = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(ByteBuffer buf, NetData config) throws IOException {
        assert (config.emoteData != null);
        buf.putFloat(config.tick);
        ByteBuf tempNettyBuf = Unpooled.buffer();
        try {
            AnimationBinary.write((ByteBuf)tempNettyBuf, (Animation)config.emoteData);
            buf.put(tempNettyBuf.array(), 0, tempNettyBuf.readableBytes());
        }
        finally {
            tempNettyBuf.release();
        }
    }

    @Override
    public boolean doWrite(NetData data) {
        return data.emoteData != null && data.stopEmoteID == null && data.versions.containsKey((byte)-103);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int calculateSize(NetData config) {
        if (config.emoteData == null || !config.versions.containsKey((byte)-103)) {
            return 0;
        }
        ByteBuf byteBuf = Unpooled.buffer();
        try {
            AnimationBinary.write((ByteBuf)byteBuf, (Animation)config.emoteData);
            int n = byteBuf.readableBytes() + 4;
            return n;
        }
        finally {
            byteBuf.release();
        }
    }
}

