/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.clickthrough.helpers;

import cc.cassian.clickthrough.ClickThrough;
import cc.cassian.clickthrough.compat.FastItemFramesCompat;
import cc.cassian.clickthrough.config.ModConfig;
import cc.cassian.clickthrough.config.ModLists;
import cc.cassian.clickthrough.helpers.fabric.ModHelpersImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.lang.reflect.Field;
import java.util.function.Consumer;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1533;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2546;
import net.minecraft.class_2551;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2624;
import net.minecraft.class_2625;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_638;
import net.minecraft.class_746;

public class ModHelpers {
    public static ModConfig config = ModConfig.get();

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isLoaded(String mod) {
        return ModHelpersImpl.isLoaded(mod);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean clothConfigInstalled() {
        return ModHelpersImpl.clothConfigInstalled();
    }

    public static boolean architecturyInstalled() {
        return ModHelpers.isLoaded("architectury");
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerKeybind() {
        ModHelpersImpl.registerKeybind();
    }

    public static String getSignRowText(class_2625 sign, int row) {
        StringBuilder builder = new StringBuilder();
        return sign.method_49853().method_49859(row, true).getString();
    }

    public static class_2561 fieldName(Field field) {
        return class_2561.method_43471((String)("clickthrough.config." + field.getName()));
    }

    public static <T> T fieldGet(Object instance, Field field) {
        try {
            return (T)field.get(instance);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> Consumer<T> fieldSetter(Object instance, Field field) {
        return t -> {
            try {
                field.set(instance, t);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        };
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isTaggedAsContainer(class_2680 state) {
        return ModHelpersImpl.isTaggedAsContainer(state);
    }

    public static boolean isClickableBlockAt(class_2338 pos, class_638 world) {
        if (!ModConfig.get().onlycontainers) {
            return true;
        }
        class_2586 entity = world.method_8321(pos);
        class_2680 state = world.method_8320(pos);
        if (entity instanceof class_2624) {
            return true;
        }
        return ModHelpers.isTaggedAsContainer(state) || ModLists.containers.contains(state.method_26204());
    }

    public static class_239 switchCrosshairTarget(class_239 crosshairTarget, class_746 player, class_638 world) {
        if (!ModConfig.get().isActive) {
            return crosshairTarget;
        }
        ClickThrough.isDyeOnSign = false;
        if (crosshairTarget != null) {
            class_1297 class_12972;
            if (crosshairTarget.method_17783() == class_239.class_240.field_1331 && (class_12972 = ((class_3966)crosshairTarget).method_17782()) instanceof class_1533) {
                class_1533 itemFrame = (class_1533)class_12972;
                class_2338 attachedPos = itemFrame.method_59940().method_10093(itemFrame.method_5735().method_10153());
                if (!player.method_5715() && ModHelpers.isClickableBlockAt(attachedPos, world)) {
                    return new class_3965(crosshairTarget.method_17784(), itemFrame.method_5735(), attachedPos, false);
                }
            } else if (crosshairTarget instanceof class_3965) {
                class_3965 blockHitResult = (class_3965)crosshairTarget;
                class_2338 blockPos = blockHitResult.method_17777();
                class_2680 state = world.method_8320(blockPos);
                class_2248 block = state.method_26204();
                if (block instanceof class_2551) {
                    class_2338 attachedPos = blockPos.method_10093(((class_2350)state.method_11654((class_2769)class_2551.field_11726)).method_10153());
                    if (!ModHelpers.isClickableBlockAt(attachedPos, world)) {
                        return crosshairTarget;
                    }
                    class_2586 entity = world.method_8321(blockPos);
                    if (!(entity instanceof class_2625)) {
                        return crosshairTarget;
                    }
                    class_1792 item = player.method_5998(class_1268.field_5808).method_7909();
                    if (item instanceof class_1769 || item == class_1802.field_28410) {
                        if (ModConfig.get().sneaktodye) {
                            ClickThrough.isDyeOnSign = true;
                            if (!player.method_5715()) {
                                return new class_3965(crosshairTarget.method_17784(), blockHitResult.method_17780(), attachedPos, false);
                            }
                        }
                    } else if (!player.method_5715()) {
                        return new class_3965(crosshairTarget.method_17784(), blockHitResult.method_17780(), attachedPos, false);
                    }
                } else if (block instanceof class_2546) {
                    class_2338 attachedPos = blockPos.method_10093(((class_2350)state.method_11654((class_2769)class_2546.field_11722)).method_10153());
                    if (ModHelpers.isClickableBlockAt(attachedPos, world)) {
                        return new class_3965(crosshairTarget.method_17784(), blockHitResult.method_17780(), attachedPos, false);
                    }
                } else if (ModHelpers.isLoaded("fastitemframes")) {
                    return FastItemFramesCompat.passthrough(block, state, blockPos, world, crosshairTarget, player);
                }
            }
        }
        return crosshairTarget;
    }
}

