/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.worldeditcui.render.shapes;

import com.mojang.blaze3d.opengl.GlStateManager;
import net.minecraft.class_3532;
import org.enginehub.worldeditcui.event.listeners.CUIRenderContext;
import org.enginehub.worldeditcui.render.LineStyle;
import org.enginehub.worldeditcui.render.RenderStyle;
import org.enginehub.worldeditcui.render.shapes.RenderRegion;
import org.enginehub.worldeditcui.util.BoundingBox;
import org.enginehub.worldeditcui.util.Observable;
import org.enginehub.worldeditcui.util.Vector3;

public class Render3DGrid
extends RenderRegion {
    private static final float CULL_RANGE = 128.0f;
    private static final double SKIP_THRESHOLD = 0.25;
    public static final double MIN_SPACING = 1.0;
    private Vector3 first;
    private Vector3 second;
    private double spacing = 1.0;

    public static Render3DGrid region3dGrid(RenderStyle style, BoundingBox region) {
        Render3DGrid render = new Render3DGrid(style, region.getMin(), region.getMax());
        if (region.isDynamic()) {
            region.addObserver(render);
        }
        return render;
    }

    public Render3DGrid(RenderStyle style, Vector3 first, Vector3 second) {
        super(style);
        this.first = first;
        this.second = second;
    }

    @Override
    public void notifyChanged(Observable<?> source) {
        this.setPosition((BoundingBox)source);
    }

    public void setPosition(BoundingBox region) {
        this.setPosition(region.getMin(), region.getMax());
    }

    public void setPosition(Vector3 first, Vector3 second) {
        this.first = first;
        this.second = second;
    }

    public Render3DGrid setSpacing(double spacing) {
        this.spacing = spacing;
        return this;
    }

    @Override
    public void render(CUIRenderContext ctx) {
        Vector3 camera = ctx.cameraPos();
        double x1 = this.first.getX() - camera.getX();
        double y1 = this.first.getY() - camera.getY();
        double z1 = this.first.getZ() - camera.getZ();
        double x2 = this.second.getX() - camera.getX();
        double y2 = this.second.getY() - camera.getY();
        double z2 = this.second.getZ() - camera.getZ();
        if (this.spacing != 1.0) {
            GlStateManager._disableCull();
            double[] vertices = new double[]{x1, y1, z1, x2, y1, z1, x2, y1, z2, x1, y1, z2, x1, y2, z1, x2, y2, z1, x2, y2, z2, x1, y2, z2, x1, y1, z1, x1, y1, z2, x1, y2, z2, x1, y2, z1, x2, y1, z1, x2, y2, z1, x2, y2, z2, x2, y1, z2, x1, y1, z1, x1, y2, z1, x2, y2, z1, x2, y1, z1, x1, y1, z2, x2, y1, z2, x2, y2, z2, x1, y2, z2};
            for (LineStyle line : this.style.getLines()) {
                if (!ctx.apply(line, this.style.getRenderType())) continue;
                ctx.color(line, 0.25f).beginQuads();
                for (int i = 0; i < vertices.length; i += 3) {
                    ctx.vertex(vertices[i], vertices[i + 1], vertices[i + 2]);
                }
                ctx.endQuads();
            }
            ctx.flush();
            GlStateManager._enableCull();
        }
        if (this.spacing < 1.0) {
            return;
        }
        double cullAt = 128.0 * this.spacing;
        double cullAtY = cullAt - class_3532.method_15385((double)y1);
        double cullAtX = cullAt - class_3532.method_15385((double)x1);
        double cullAtZ = cullAt - class_3532.method_15385((double)z1);
        for (LineStyle line : this.style.getLines()) {
            if (!ctx.apply(line, this.style.getRenderType())) continue;
            ctx.color(line).beginLines();
            double yEnd = Math.min(y2 + 0.001, cullAtY);
            for (double y = Math.max(y1, -cullAtY) + 0.001; y <= yEnd; y += this.spacing) {
                if (yEnd - y < 0.25) continue;
                ctx.vertex(x1, y, z2).vertex(x2, y, z2).vertex(x1, y, z1).vertex(x2, y, z1).vertex(x1, y, z1).vertex(x1, y, z2).vertex(x2, y, z1).vertex(x2, y, z2);
            }
            double xEnd = Math.min(x2, cullAtX);
            for (double x = Math.max(x1, -cullAtX); x <= xEnd; x += this.spacing) {
                if (xEnd - x < 0.25) continue;
                ctx.vertex(x, y1, z1).vertex(x, y2, z1).vertex(x, y1, z2).vertex(x, y2, z2).vertex(x, y2, z1).vertex(x, y2, z2).vertex(x, y1, z1).vertex(x, y1, z2);
            }
            double zEnd = Math.min(z2, cullAtZ);
            for (double z = Math.max(z1, -cullAtZ); z <= zEnd; z += this.spacing) {
                if (zEnd - z < 0.25) continue;
                ctx.vertex(x1, y1, z).vertex(x2, y1, z).vertex(x1, y2, z).vertex(x2, y2, z).vertex(x2, y1, z).vertex(x2, y2, z).vertex(x1, y1, z).vertex(x1, y2, z);
            }
            ctx.endLines();
        }
    }
}

