/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranimcore.animation.layered.modifier;

import com.zigythebird.playeranimcore.animation.AnimationController;
import com.zigythebird.playeranimcore.animation.AnimationData;
import com.zigythebird.playeranimcore.animation.layered.modifier.AbstractModifier;
import com.zigythebird.playeranimcore.bones.PlayerAnimBone;
import com.zigythebird.playeranimcore.math.Vec3f;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class AdjustmentModifier
extends AbstractModifier {
    public boolean fadeIn = true;
    public boolean fadeOut = true;
    public boolean enabled = true;
    private float tickDelta;
    protected Function<String, Optional<PartModifier>> source;
    protected int instructedFadeout = 0;
    private int remainingFadeout = 0;

    public AdjustmentModifier(Function<String, Optional<PartModifier>> source) {
        this.source = source;
    }

    @Override
    public void tick(AnimationData state) {
        super.tick(state);
        if (this.remainingFadeout > 0) {
            --this.remainingFadeout;
            if (this.remainingFadeout <= 0) {
                this.instructedFadeout = 0;
            }
        }
    }

    @Override
    public void setupAnim(AnimationData state) {
        this.tickDelta = state.getPartialTick();
    }

    public void fadeOut(int fadeOut) {
        this.instructedFadeout = fadeOut;
        this.remainingFadeout = fadeOut + 1;
    }

    protected float getFadeOut(float delta) {
        AnimationController controller;
        AnimationController animationController;
        float fadeOut = 1.0f;
        if (this.remainingFadeout > 0 && this.instructedFadeout > 0) {
            float current = Math.max((float)this.remainingFadeout - delta, 0.0f);
            fadeOut = current / (float)this.instructedFadeout;
            fadeOut = Math.min(fadeOut, 1.0f);
            return fadeOut;
        }
        if (this.fadeOut && (animationController = this.getController()) instanceof AnimationController && (controller = animationController).getCurrentAnimation() != null) {
            float stopTick = controller.getCurrentAnimation().animation().length();
            float endTick = controller.getCurrentAnimation().animation().data().get("endTick").orElse(Float.valueOf(stopTick)).floatValue();
            float position = -1.0f * (controller.getAnimationTicks() - stopTick);
            float length = stopTick - endTick;
            if (length > 0.0f) {
                fadeOut = position / length;
                fadeOut = Math.min(fadeOut, 1.0f);
            }
        }
        return fadeOut;
    }

    protected float getFadeIn() {
        AnimationController controller;
        AnimationController animationController;
        float fadeIn = 1.0f;
        if (this.fadeIn && (animationController = this.getController()) instanceof AnimationController && (controller = animationController).getCurrentAnimation() != null) {
            float beginTick = controller.getCurrentAnimation().animation().data().get("beginTick").orElse(Float.valueOf(0.0f)).floatValue();
            fadeIn = beginTick > 0.0f ? controller.getAnimationTicks() / beginTick : 1.0f;
            fadeIn = Math.min(fadeIn, 1.0f);
        }
        return fadeIn;
    }

    @Override
    public PlayerAnimBone get3DTransform(@NotNull PlayerAnimBone bone) {
        if (!this.enabled) {
            return super.get3DTransform(bone);
        }
        Optional<PartModifier> partModifier = this.source.apply(bone.getName());
        float fade = this.getFadeIn() * this.getFadeOut(this.tickDelta);
        if (partModifier.isPresent()) {
            super.get3DTransform(bone);
            this.transformBone(bone, partModifier.get(), fade);
            return bone;
        }
        return super.get3DTransform(bone);
    }

    protected void transformBone(PlayerAnimBone bone, PartModifier partModifier, float fade) {
        Vec3f pos = partModifier.offset().mul(fade);
        Vec3f rot = partModifier.rotation().mul(fade);
        Vec3f scale = partModifier.scale().mul(fade);
        bone.updatePosition(pos.x() + bone.getPosX(), pos.y() + bone.getPosY(), pos.z() + bone.getPosZ());
        bone.updateRotation(rot.x() + bone.getRotX(), rot.y() + bone.getRotY(), rot.z() + bone.getRotZ());
        bone.updateScale(scale.x() + bone.getScaleX(), scale.y() + bone.getScaleY(), scale.z() + bone.getScaleZ());
    }

    public static final class PartModifier {
        private final Vec3f rotation;
        private final Vec3f scale;
        private final Vec3f offset;

        public PartModifier(Vec3f rotation, Vec3f offset) {
            this(rotation, Vec3f.ZERO, offset);
        }

        public PartModifier(Vec3f rotation, Vec3f scale, Vec3f offset) {
            this.rotation = rotation;
            this.scale = scale;
            this.offset = offset;
        }

        public Vec3f rotation() {
            return this.rotation;
        }

        public Vec3f scale() {
            return this.scale;
        }

        public Vec3f offset() {
            return this.offset;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            PartModifier that = (PartModifier)obj;
            return Objects.equals(this.rotation, that.rotation) && Objects.equals(this.scale, that.scale) && Objects.equals(this.offset, that.offset);
        }

        public int hashCode() {
            return Objects.hash(this.rotation, this.scale, this.offset);
        }

        public String toString() {
            return "PartModifier[rotation=" + String.valueOf(this.rotation) + ", scale=" + String.valueOf(this.scale) + ", offset=" + String.valueOf(this.offset) + "]";
        }
    }
}

