/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranimcore.animation;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;

public record ExtraAnimationData(Map<String, Object> data) {
    public static final String NAME_KEY = "name";
    public static final String UUID_KEY = "uuid";

    public ExtraAnimationData(String key, Object value) {
        this(new HashMap<String, Object>(Collections.singletonMap(key, value)));
    }

    public ExtraAnimationData() {
        this(new HashMap<String, Object>(1));
    }

    @Nullable
    public String name() {
        String name;
        Object data = this.data().get(NAME_KEY);
        if (data instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)data;
            name = jsonObject.get("fallback").getAsString();
        } else {
            name = (String)data;
        }
        return name != null ? name.toLowerCase(Locale.ROOT).replace("\"", "").replace(" ", "_") : null;
    }

    public boolean has(String name) {
        return this.data().containsKey(name);
    }

    public Object getRaw(String name) {
        return this.data().get(name);
    }

    public <T> Optional<T> get(String key) {
        Object obj = this.getRaw(key);
        if (obj == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(obj);
        }
        catch (Throwable throwable) {
            return Optional.empty();
        }
    }

    public void put(String name, Object object) {
        this.data.put(name, object);
    }

    public void fromJson(JsonObject node) {
        for (Map.Entry entry : node.entrySet()) {
            this.data().put((String)entry.getKey(), this.getValue((JsonElement)entry.getValue()));
        }
    }

    public Object getValue(JsonElement element) {
        if (element instanceof JsonPrimitive) {
            JsonPrimitive p = (JsonPrimitive)element;
            if (p.isBoolean()) {
                return p.getAsBoolean();
            }
            if (p.isString()) {
                return p.getAsString();
            }
            if (p.isNumber()) {
                return Float.valueOf(p.getAsFloat());
            }
        }
        if (element instanceof JsonArray) {
            JsonArray array = (JsonArray)element;
            ArrayList<Object> list = new ArrayList<Object>(array.size());
            for (JsonElement element1 : array) {
                list.add(this.getValue(element1));
            }
            return list;
        }
        return element;
    }

    public ExtraAnimationData copy() {
        return new ExtraAnimationData((Map<String, Object>)new HashMap<String, Object>(){
            {
                this.putAll(ExtraAnimationData.this.data());
            }
        });
    }
}

