/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranimcore.animation;

import com.zigythebird.playeranim.lib.mochafloats.MochaEngine;
import com.zigythebird.playeranimcore.animation.Animation;
import com.zigythebird.playeranimcore.animation.AnimationData;
import com.zigythebird.playeranimcore.animation.AnimationProcessor;
import com.zigythebird.playeranimcore.animation.ExtraAnimationData;
import com.zigythebird.playeranimcore.animation.RawAnimation;
import com.zigythebird.playeranimcore.animation.keyframe.AnimationPoint;
import com.zigythebird.playeranimcore.animation.keyframe.BoneAnimation;
import com.zigythebird.playeranimcore.animation.keyframe.BoneAnimationQueue;
import com.zigythebird.playeranimcore.animation.keyframe.Keyframe;
import com.zigythebird.playeranimcore.animation.keyframe.KeyframeLocation;
import com.zigythebird.playeranimcore.animation.keyframe.KeyframeStack;
import com.zigythebird.playeranimcore.animation.keyframe.event.CustomKeyFrameEvents;
import com.zigythebird.playeranimcore.animation.keyframe.event.data.CustomInstructionKeyframeData;
import com.zigythebird.playeranimcore.animation.keyframe.event.data.KeyFrameData;
import com.zigythebird.playeranimcore.animation.keyframe.event.data.ParticleKeyframeData;
import com.zigythebird.playeranimcore.animation.keyframe.event.data.SoundKeyframeData;
import com.zigythebird.playeranimcore.animation.layered.AnimationContainer;
import com.zigythebird.playeranimcore.animation.layered.AnimationSnapshot;
import com.zigythebird.playeranimcore.animation.layered.IAnimation;
import com.zigythebird.playeranimcore.animation.layered.modifier.AbstractFadeModifier;
import com.zigythebird.playeranimcore.animation.layered.modifier.AbstractModifier;
import com.zigythebird.playeranimcore.api.firstPerson.FirstPersonConfiguration;
import com.zigythebird.playeranimcore.api.firstPerson.FirstPersonMode;
import com.zigythebird.playeranimcore.bones.AdvancedBoneSnapshot;
import com.zigythebird.playeranimcore.bones.AdvancedPlayerAnimBone;
import com.zigythebird.playeranimcore.bones.PivotBone;
import com.zigythebird.playeranimcore.bones.PlayerAnimBone;
import com.zigythebird.playeranimcore.easing.EasingType;
import com.zigythebird.playeranimcore.enums.AnimationFormat;
import com.zigythebird.playeranimcore.enums.PlayState;
import com.zigythebird.playeranimcore.enums.State;
import com.zigythebird.playeranimcore.enums.TransformType;
import com.zigythebird.playeranimcore.event.EventResult;
import com.zigythebird.playeranimcore.math.ModMatrix4f;
import com.zigythebird.playeranimcore.math.ModVector4f;
import com.zigythebird.playeranimcore.math.Vec3f;
import com.zigythebird.playeranimcore.molang.MolangLoader;
import com.zigythebird.playeranimcore.util.MatrixUtil;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AnimationController
implements IAnimation {
    public static KeyframeLocation<Keyframe> EMPTY_KEYFRAME_LOCATION = new KeyframeLocation<Keyframe>(new Keyframe(0.0f), 0.0f, 0.0f);
    protected final AnimationStateHandler stateHandler;
    protected final LinkedHashMap<String, BoneAnimationQueue> boneAnimationQueues = new LinkedHashMap();
    protected final Map<String, AdvancedPlayerAnimBone> bones = new Object2ObjectOpenHashMap();
    protected final Map<String, PlayerAnimBone> activeBones = new Object2ObjectOpenHashMap();
    protected final Map<String, PivotBone> pivotBones = new Object2ObjectOpenHashMap();
    protected Queue<AnimationProcessor.QueuedAnimation> animationQueue = new LinkedList<AnimationProcessor.QueuedAnimation>();
    protected final MochaEngine<AnimationController> molangRuntime;
    protected boolean isJustStarting = false;
    protected boolean needsAnimationReload = false;
    protected boolean shouldResetTick = false;
    protected CustomKeyFrameEvents.CustomKeyFrameHandler<SoundKeyframeData> soundKeyframeHandler = null;
    protected CustomKeyFrameEvents.CustomKeyFrameHandler<ParticleKeyframeData> particleKeyframeHandler = null;
    protected CustomKeyFrameEvents.CustomKeyFrameHandler<CustomInstructionKeyframeData> customKeyframeHandler = null;
    protected RawAnimation triggeredAnimation = null;
    protected boolean handlingTriggeredAnimations = false;
    protected RawAnimation currentRawAnimation;
    protected AnimationProcessor.QueuedAnimation currentAnimation;
    protected float animTime;
    protected State animationState = State.STOPPED;
    protected float tickOffset;
    protected float startAnimFrom;
    protected Consumer<Function<String, AdvancedPlayerAnimBone>> postAnimationSetupConsumer = function -> {};
    protected Function<AnimationController, Float> animationSpeedModifier = controller -> Float.valueOf(1.0f);
    protected Function<AnimationController, EasingType> overrideEasingTypeFunction = controller -> null;
    private final Set<KeyFrameData> executedKeyFrames = new ObjectOpenHashSet();
    protected AnimationData animationData;
    protected Function<AnimationController, FirstPersonMode> firstPersonMode = null;
    protected Function<AnimationController, FirstPersonConfiguration> firstPersonConfiguration = null;
    private final List<AbstractModifier> modifiers = new ArrayList<AbstractModifier>();
    private final InternalAnimationAccessor internalAnimationAccessor = new InternalAnimationAccessor(this);

    public AnimationController(AnimationStateHandler animationHandler) {
        this.stateHandler = animationHandler;
        this.molangRuntime = MolangLoader.createNewEngine(this);
        this.registerBones();
    }

    public abstract void registerBones();

    public AnimationController setSoundKeyframeHandler(CustomKeyFrameEvents.CustomKeyFrameHandler<SoundKeyframeData> soundHandler) {
        this.soundKeyframeHandler = soundHandler;
        return this;
    }

    public AnimationController setParticleKeyframeHandler(CustomKeyFrameEvents.CustomKeyFrameHandler<ParticleKeyframeData> particleHandler) {
        this.particleKeyframeHandler = particleHandler;
        return this;
    }

    public AnimationController setCustomInstructionKeyframeHandler(CustomKeyFrameEvents.CustomKeyFrameHandler<CustomInstructionKeyframeData> customInstructionHandler) {
        this.customKeyframeHandler = customInstructionHandler;
        return this;
    }

    public AnimationController setPostAnimationSetupConsumer(Consumer<Function<String, AdvancedPlayerAnimBone>> postAnimationSetupConsumer) {
        this.postAnimationSetupConsumer = postAnimationSetupConsumer;
        return this;
    }

    public AnimationController setAnimationSpeedHandler(Function<AnimationController, Float> speedModFunction) {
        this.animationSpeedModifier = speedModFunction;
        return this;
    }

    public AnimationController setAnimationSpeed(float speed) {
        return this.setAnimationSpeedHandler(animatable -> Float.valueOf(speed));
    }

    public AnimationController setOverrideEasingType(EasingType easingTypeFunction) {
        return this.setOverrideEasingTypeFunction(animatable -> easingTypeFunction);
    }

    public AnimationController setOverrideEasingTypeFunction(Function<AnimationController, EasingType> easingType) {
        this.overrideEasingTypeFunction = easingType;
        return this;
    }

    public AnimationController receiveTriggeredAnimations() {
        this.handlingTriggeredAnimations = true;
        return this;
    }

    @Nullable
    public AnimationProcessor.QueuedAnimation getCurrentAnimation() {
        return this.currentAnimation;
    }

    @Nullable
    public RawAnimation getTriggeredAnimation() {
        return this.triggeredAnimation;
    }

    @NotNull
    public State getAnimationState() {
        return this.animationState;
    }

    @Override
    public boolean isActive() {
        return this.animationState.isActive();
    }

    public AnimationData getAnimationData() {
        return this.animationData;
    }

    public Map<String, BoneAnimationQueue> getBoneAnimationQueues() {
        return this.boneAnimationQueues;
    }

    public float getAnimationSpeed() {
        return this.animationSpeedModifier.apply(this).floatValue();
    }

    public void forceAnimationReset() {
        this.needsAnimationReload = true;
    }

    public void stop() {
        this.animationState = State.STOPPED;
        this.resetEventKeyFrames();
    }

    public boolean hasAnimationFinished() {
        return this.currentRawAnimation != null && this.animationState == State.STOPPED;
    }

    public RawAnimation getCurrentRawAnimation() {
        return this.currentRawAnimation;
    }

    public boolean isPlayingTriggeredAnimation() {
        return this.triggeredAnimation != null && !this.hasAnimationFinished();
    }

    protected void setAnimation(RawAnimation rawAnimation, float startAnimFrom) {
        if (rawAnimation == null || rawAnimation.getAnimationStages().isEmpty()) {
            this.stop();
            return;
        }
        if (this.needsAnimationReload || !rawAnimation.equals(this.currentRawAnimation)) {
            Queue<AnimationProcessor.QueuedAnimation> animations = this.getQueuedAnimations(rawAnimation);
            if (animations != null) {
                this.animationQueue = animations;
                this.currentRawAnimation = rawAnimation;
                this.startAnimFrom = startAnimFrom;
                this.shouldResetTick = true;
                this.animationState = State.RUNNING;
                this.currentAnimation = this.animationQueue.poll();
                this.setupNewAnimation();
                this.needsAnimationReload = false;
                return;
            }
            this.stop();
        }
    }

    protected void setAnimation(RawAnimation rawAnimation) {
        this.setAnimation(rawAnimation, 0.0f);
    }

    protected abstract Queue<AnimationProcessor.QueuedAnimation> getQueuedAnimations(RawAnimation var1);

    public void triggerAnimation(RawAnimation newAnimation, float startAnimFrom) {
        if (newAnimation == null) {
            return;
        }
        this.stop();
        this.triggeredAnimation = newAnimation;
        this.needsAnimationReload = true;
        this.animationState = State.RUNNING;
        this.shouldResetTick = true;
        this.startAnimFrom = startAnimFrom;
    }

    public void triggerAnimation(RawAnimation newAnimation) {
        this.triggerAnimation(newAnimation, 0.0f);
    }

    public void triggerAnimation(Animation newAnimation, float startAnimFrom) {
        this.triggerAnimation(RawAnimation.begin().then(newAnimation, Animation.LoopType.DEFAULT), startAnimFrom);
    }

    public void triggerAnimation(Animation newAnimation) {
        this.triggerAnimation(RawAnimation.begin().then(newAnimation, Animation.LoopType.DEFAULT), 0.0f);
    }

    public void replaceAnimationWithFade(@NotNull AbstractFadeModifier fadeModifier, @Nullable RawAnimation newAnimation) {
        this.replaceAnimationWithFade(fadeModifier, newAnimation, true);
    }

    public void replaceAnimationWithFade(@NotNull AbstractFadeModifier fadeModifier, @Nullable RawAnimation newAnimation, boolean fadeFromNothing) {
        if (fadeFromNothing || this.isActive()) {
            if (this.isActive()) {
                HashMap<String, AdvancedBoneSnapshot> snapshots = new HashMap<String, AdvancedBoneSnapshot>();
                for (PlayerAnimBone bone : this.activeBones.values()) {
                    snapshots.put(bone.getName(), new AdvancedBoneSnapshot(bone));
                }
                fadeModifier.setTransitionAnimation(new AnimationSnapshot(snapshots));
            }
            this.addModifierLast(fadeModifier);
        }
        this.triggerAnimation(newAnimation);
    }

    protected boolean stopTriggeredAnimation() {
        if (this.triggeredAnimation == null) {
            return false;
        }
        if (this.currentRawAnimation == this.triggeredAnimation) {
            this.currentAnimation = null;
            this.currentRawAnimation = null;
        }
        this.triggeredAnimation = null;
        this.needsAnimationReload = true;
        return true;
    }

    protected PlayState handleAnimation(AnimationData state) {
        if (this.triggeredAnimation != null) {
            if (this.currentRawAnimation != this.triggeredAnimation) {
                this.currentAnimation = null;
            }
            this.setAnimation(this.triggeredAnimation, this.startAnimFrom);
            if (!this.hasAnimationFinished() && !this.handlingTriggeredAnimations) {
                return PlayState.CONTINUE;
            }
            this.triggeredAnimation = null;
            this.needsAnimationReload = true;
        }
        return this.stateHandler.handle(this, state, (animation, startTick) -> {
            this.setAnimation(animation, startTick);
            return PlayState.CONTINUE;
        });
    }

    public void process(AnimationData state, float seekTime) {
        float adjustedTick = this.adjustTick(seekTime);
        PlayState playState = this.handleAnimation(state);
        if (playState == PlayState.STOP || this.currentAnimation == null && this.animationQueue.isEmpty()) {
            this.animationState = State.STOPPED;
            return;
        }
        this.boneAnimationQueues.clear();
        if (this.getAnimationState() == State.RUNNING) {
            this.processCurrentAnimation(adjustedTick, seekTime, state);
        }
    }

    private void processCurrentAnimation(float adjustedTick, float seekTime, AnimationData animationData) {
        Animation animation = this.currentAnimation.animation();
        if (adjustedTick >= animation.length()) {
            if (this.currentAnimation.loopType().shouldPlayAgain(animation)) {
                if (this.animationState != State.PAUSED) {
                    this.shouldResetTick = true;
                    this.startAnimFrom = this.currentAnimation.loopType().restartFromTick(animation);
                    adjustedTick = this.adjustTick(seekTime);
                    this.resetEventKeyFrames();
                }
            } else {
                AnimationProcessor.QueuedAnimation nextAnimation = this.animationQueue.peek();
                this.resetEventKeyFrames();
                if (nextAnimation == null) {
                    this.animationState = State.STOPPED;
                    this.currentAnimation = null;
                    for (AdvancedPlayerAnimBone bone : this.bones.values()) {
                        bone.setToInitialPose();
                    }
                    return;
                }
                this.animationState = State.RUNNING;
                this.shouldResetTick = true;
                adjustedTick = this.adjustTick(seekTime);
                this.currentAnimation = this.animationQueue.poll();
                this.setupNewAnimation();
            }
        }
        float finalAdjustedTick = adjustedTick;
        this.animTime = finalAdjustedTick / 20.0f;
        for (Map.Entry<String, BoneAnimation> entry2 : animation.boneAnimations().entrySet()) {
            BoneAnimationQueue boneAnimationQueue = this.boneAnimationQueues.computeIfAbsent(entry2.getKey(), name -> new BoneAnimationQueue(this.bones.containsKey(name) ? (PlayerAnimBone)this.bones.get(name) : (PlayerAnimBone)this.pivotBones.get(name)));
            AdvancedPlayerAnimBone bone = this.bones.get(entry2.getKey());
            BoneAnimation boneAnimation = entry2.getValue();
            KeyframeStack rotationKeyFrames = boneAnimation.rotationKeyFrames();
            KeyframeStack positionKeyFrames = boneAnimation.positionKeyFrames();
            KeyframeStack scaleKeyFrames = boneAnimation.scaleKeyFrames();
            List<Keyframe> bendKeyFrames = boneAnimation.bendKeyFrames();
            if (rotationKeyFrames.hasKeyframes()) {
                boneAnimationQueue.addRotations(this.getAnimationPointAtTick(rotationKeyFrames.xKeyframes(), adjustedTick, TransformType.ROTATION, bone != null ? bone::setRotXTransitionLength : null), this.getAnimationPointAtTick(rotationKeyFrames.yKeyframes(), adjustedTick, TransformType.ROTATION, bone != null ? bone::setRotYTransitionLength : null), this.getAnimationPointAtTick(rotationKeyFrames.zKeyframes(), adjustedTick, TransformType.ROTATION, bone != null ? bone::setRotZTransitionLength : null));
            }
            if (positionKeyFrames.hasKeyframes()) {
                boneAnimationQueue.addPositions(this.getAnimationPointAtTick(positionKeyFrames.xKeyframes(), adjustedTick, TransformType.POSITION, bone != null ? bone::setPositionXTransitionLength : null), this.getAnimationPointAtTick(positionKeyFrames.yKeyframes(), adjustedTick, TransformType.POSITION, bone != null ? bone::setPositionYTransitionLength : null), this.getAnimationPointAtTick(positionKeyFrames.zKeyframes(), adjustedTick, TransformType.POSITION, bone != null ? bone::setPositionZTransitionLength : null));
            }
            if (scaleKeyFrames.hasKeyframes()) {
                boneAnimationQueue.addScales(this.getAnimationPointAtTick(scaleKeyFrames.xKeyframes(), adjustedTick, TransformType.SCALE, bone != null ? bone::setScaleXTransitionLength : null), this.getAnimationPointAtTick(scaleKeyFrames.yKeyframes(), adjustedTick, TransformType.SCALE, bone != null ? bone::setScaleYTransitionLength : null), this.getAnimationPointAtTick(scaleKeyFrames.zKeyframes(), adjustedTick, TransformType.SCALE, bone != null ? bone::setScaleZTransitionLength : null));
            }
            if (bendKeyFrames.isEmpty()) continue;
            boneAnimationQueue.addBend(this.getAnimationPointAtTick(bendKeyFrames, adjustedTick, TransformType.BEND, bone != null ? bone::setBendTransitionLength : null));
        }
        this.boneAnimationQueues.entrySet().stream().sorted((o1, o2) -> {
            boolean isMainBone2;
            boolean isMainBone1 = this.bones.containsKey(o1.getKey());
            if (isMainBone1 == (isMainBone2 = this.bones.containsKey(o2.getKey()))) {
                return 0;
            }
            if (isMainBone1) {
                return 1;
            }
            return -1;
        }).forEach(entry -> this.boneAnimationQueues.putLast((String)entry.getKey(), (BoneAnimationQueue)entry.getValue()));
        this.handleCustomKeyframe(animation.keyFrames().sounds(), this.soundKeyframeHandler, CustomKeyFrameEvents.SOUND_KEYFRAME_EVENT.invoker(), adjustedTick, animationData);
        this.handleCustomKeyframe(animation.keyFrames().particles(), this.particleKeyframeHandler, CustomKeyFrameEvents.PARTICLE_KEYFRAME_EVENT.invoker(), adjustedTick, animationData);
        this.handleCustomKeyframe(animation.keyFrames().customInstructions(), this.customKeyframeHandler, CustomKeyFrameEvents.CUSTOM_INSTRUCTION_KEYFRAME_EVENT.invoker(), adjustedTick, animationData);
    }

    protected <T extends KeyFrameData> void handleCustomKeyframe(T[] keyframes, @Nullable CustomKeyFrameEvents.CustomKeyFrameHandler<T> main, CustomKeyFrameEvents.CustomKeyFrameHandler<T> event, float animationTick, AnimationData animationData) {
        for (T keyframeData : keyframes) {
            EventResult result;
            if (!(animationTick >= ((KeyFrameData)keyframeData).getStartTick()) || !this.executedKeyFrames.add((KeyFrameData)keyframeData)) continue;
            EventResult eventResult = result = main == null ? EventResult.PASS : main.handle(animationTick, this, keyframeData, animationData);
            if (result == EventResult.PASS) {
                result = event.handle(animationTick, this, keyframeData, animationData);
            }
            if (result != EventResult.FAIL) continue;
            return;
        }
    }

    protected float adjustTick(float tick) {
        if (!this.shouldResetTick) {
            return this.animationSpeedModifier.apply(this).floatValue() * Math.max(tick - this.tickOffset, 0.0f) + this.startAnimFrom;
        }
        if (this.getAnimationState() != State.STOPPED) {
            this.tickOffset = tick;
        }
        this.shouldResetTick = false;
        return this.startAnimFrom;
    }

    public float getAnimationTime() {
        return this.animTime;
    }

    public float getAnimationTicks() {
        return this.animTime * 20.0f;
    }

    public boolean hasBeginTick() {
        return this.currentAnimation.animation().data().has("beginTick");
    }

    public boolean hasEndTick() {
        Animation animation = this.currentAnimation.animation();
        return !animation.loopType().shouldPlayAgain(animation) && animation.data().has("endTick");
    }

    public boolean isDisableAxisIfNotModified() {
        if (this.currentAnimation != null) {
            Optional<Boolean> result = this.currentAnimation.animation().data().get("disableAxisIfNotModified");
            return result.orElse(true);
        }
        return false;
    }

    public boolean isAnimationPlayerAnimatorFormat() {
        return this.currentAnimation != null && this.currentAnimation.animation().data().get("format").orElse(null) == AnimationFormat.PLAYER_ANIMATOR;
    }

    protected void setupNewAnimation() {
        if (this.currentAnimation == null) {
            return;
        }
        this.resetEventKeyFrames();
        for (AdvancedPlayerAnimBone advancedPlayerAnimBone : this.bones.values()) {
            advancedPlayerAnimBone.setEnabled(this.currentAnimation.animation().getBone(advancedPlayerAnimBone.getName()) != null);
        }
        for (Map.Entry entry : this.currentAnimation.animation().boneAnimations().entrySet()) {
            if (!this.bones.containsKey(entry.getKey())) continue;
            AdvancedPlayerAnimBone bone = this.bones.get(entry.getKey());
            if (this.isDisableAxisIfNotModified()) {
                BoneAnimation boneAnimation = (BoneAnimation)entry.getValue();
                bone.positionXEnabled = !boneAnimation.positionKeyFrames().xKeyframes().isEmpty();
                bone.positionYEnabled = !boneAnimation.positionKeyFrames().yKeyframes().isEmpty();
                bone.positionZEnabled = !boneAnimation.positionKeyFrames().zKeyframes().isEmpty();
                bone.rotXEnabled = !boneAnimation.rotationKeyFrames().xKeyframes().isEmpty();
                bone.rotYEnabled = !boneAnimation.rotationKeyFrames().yKeyframes().isEmpty();
                bone.rotZEnabled = !boneAnimation.rotationKeyFrames().zKeyframes().isEmpty();
                bone.scaleXEnabled = !boneAnimation.scaleKeyFrames().xKeyframes().isEmpty();
                bone.scaleYEnabled = !boneAnimation.scaleKeyFrames().yKeyframes().isEmpty();
                bone.scaleZEnabled = !boneAnimation.scaleKeyFrames().zKeyframes().isEmpty();
                boolean bl = bone.bendEnabled = !boneAnimation.bendKeyFrames().isEmpty();
                if (this.isAnimationPlayerAnimatorFormat()) continue;
                if (bone.positionXEnabled || bone.positionYEnabled || bone.positionZEnabled) {
                    bone.setPositionEnabled(true);
                }
                if (bone.rotXEnabled || bone.rotYEnabled || bone.rotZEnabled) {
                    bone.setRotEnabled(true);
                }
                if (!bone.scaleXEnabled && !bone.scaleYEnabled && !bone.scaleZEnabled) continue;
                bone.setScaleEnabled(true);
                continue;
            }
            bone.setEnabled(true);
        }
        for (String string : this.currentAnimation.animation().parents().keySet()) {
            if (!this.bones.containsKey(string)) continue;
            this.bones.get(string).setEnabled(true);
        }
        this.pivotBones.clear();
        for (Map.Entry entry : this.currentAnimation.animation().bones().entrySet()) {
            this.pivotBones.put((String)entry.getKey(), new PivotBone((String)entry.getKey(), (Vec3f)entry.getValue()));
        }
        this.postAnimationSetupConsumer.accept(name -> this.bones.getOrDefault(name, null));
    }

    private AnimationPoint getAnimationPointAtTick(List<Keyframe> frames, float tick, TransformType type, Consumer<Float> transitionLengthSetter) {
        Animation animation = this.currentAnimation.animation();
        Animation.LoopType loopType = animation.loopType();
        float endTick = animation.data().get("endTick").orElse(Float.valueOf(animation.length() - 1.0f)).floatValue();
        KeyframeLocation<Keyframe> location = this.getCurrentKeyFrameLocation(frames, tick);
        Keyframe currentFrame = location.keyframe();
        float startValue = this.molangRuntime.eval(currentFrame.startValue());
        float endValue = this.molangRuntime.eval(currentFrame.endValue());
        if (type == TransformType.ROTATION || type == TransformType.BEND) {
            if (!MolangLoader.isConstant(currentFrame.startValue())) {
                startValue = (float)Math.toRadians(startValue);
            }
            if (!MolangLoader.isConstant(currentFrame.endValue())) {
                endValue = (float)Math.toRadians(endValue);
            }
        }
        if (transitionLengthSetter != null) {
            ExtraAnimationData extraData = animation.data();
            if (this.hasBeginTick() && !frames.isEmpty() && currentFrame == frames.getFirst() && ((Float)extraData.get("beginTick").get()).floatValue() > tick) {
                startValue = endValue;
                transitionLengthSetter.accept(Float.valueOf(currentFrame.length()));
            } else if (this.hasEndTick() && !frames.isEmpty() && currentFrame == frames.getLast() && endTick <= tick) {
                transitionLengthSetter.accept(Float.valueOf(animation.length() - endTick));
            } else {
                transitionLengthSetter.accept(null);
            }
        }
        return new AnimationPoint(currentFrame.easingType(), currentFrame.easingArgs(), location.startTick(), currentFrame.length(), startValue, endValue);
    }

    private KeyframeLocation<Keyframe> getCurrentKeyFrameLocation(List<Keyframe> frames, float ageInTicks) {
        if (frames.isEmpty()) {
            return EMPTY_KEYFRAME_LOCATION;
        }
        float totalFrameTime = 0.0f;
        for (Keyframe frame : frames) {
            if (!((totalFrameTime += frame.length()) > ageInTicks)) continue;
            return new KeyframeLocation<Keyframe>(frame, ageInTicks - (totalFrameTime - frame.length()), totalFrameTime);
        }
        return new KeyframeLocation<Keyframe>(frames.getLast(), ageInTicks, totalFrameTime);
    }

    protected void resetEventKeyFrames() {
        if (!this.executedKeyFrames.isEmpty()) {
            CustomKeyFrameEvents.RESET_KEYFRAMES_EVENT.invoker().handle(this, this.executedKeyFrames);
        }
        this.executedKeyFrames.clear();
    }

    public PlayerAnimBone get3DTransformRaw(@NotNull PlayerAnimBone bone) {
        if (this.activeBones.containsKey(bone.getName())) {
            PlayerAnimBone bone1 = this.activeBones.get(bone.getName());
            if (this.currentAnimation != null && bone1 instanceof AdvancedPlayerAnimBone) {
                AdvancedPlayerAnimBone advancedBone = (AdvancedPlayerAnimBone)bone1;
                ExtraAnimationData extraData = this.currentAnimation.animation().data();
                if (this.hasBeginTick() && ((Float)extraData.get("beginTick").get()).floatValue() > this.getAnimationTicks()) {
                    bone.beginOrEndTickLerp(advancedBone, this.getAnimationTicks(), null);
                } else if (this.hasEndTick() && ((Float)extraData.get("endTick").get()).floatValue() <= this.getAnimationTicks()) {
                    bone.beginOrEndTickLerp(advancedBone, this.getAnimationTicks() - ((Float)extraData.get("endTick").get()).floatValue(), this.currentAnimation.animation());
                } else {
                    bone.copyOtherBoneIfNotDisabled(bone1);
                }
            } else {
                bone.copyOtherBoneIfNotDisabled(bone1);
            }
        }
        return bone;
    }

    @Override
    public PlayerAnimBone get3DTransform(@NotNull PlayerAnimBone bone) {
        if (!this.modifiers.isEmpty()) {
            return this.modifiers.getFirst().get3DTransform(bone);
        }
        return this.get3DTransformRaw(bone);
    }

    @Override
    @NotNull
    public FirstPersonMode getFirstPersonMode() {
        if (this.firstPersonMode != null) {
            return this.firstPersonMode.apply(this);
        }
        return FirstPersonMode.NONE;
    }

    @Override
    @NotNull
    public FirstPersonConfiguration getFirstPersonConfiguration() {
        if (this.firstPersonConfiguration != null) {
            return this.firstPersonConfiguration.apply(this);
        }
        return IAnimation.DEFAULT_FIRST_PERSON_CONFIG;
    }

    public void setFirstPersonMode(FirstPersonMode mode) {
        this.firstPersonMode = controller -> mode;
    }

    public void setFirstPersonModeHandler(Function<AnimationController, FirstPersonMode> modeHandler) {
        this.firstPersonMode = modeHandler;
    }

    public void setFirstPersonConfiguration(FirstPersonConfiguration config) {
        this.firstPersonConfiguration = controller -> config;
    }

    public void setFirstPersonConfigurationHandler(Function<AnimationController, FirstPersonConfiguration> configHandler) {
        this.firstPersonConfiguration = configHandler;
    }

    @Override
    public void tick(AnimationData state) {
        for (int i = 0; i < this.modifiers.size(); ++i) {
            if (!this.modifiers.get(i).canRemove()) continue;
            this.removeModifier(i--);
        }
        if (!this.modifiers.isEmpty()) {
            this.modifiers.getFirst().tick(state);
        } else {
            this.internalSetupAnim(state);
        }
    }

    @Override
    public void setupAnim(AnimationData state) {
        this.animationData = state;
        if (!this.modifiers.isEmpty()) {
            this.modifiers.getFirst().setupAnim(state);
        } else {
            this.internalSetupAnim(state);
        }
    }

    protected void internalSetupAnim(AnimationData state) {
        this.activeBones.clear();
        for (BoneAnimationQueue boneAnimation : this.getBoneAnimationQueues().values()) {
            PlayerAnimBone bone = boneAnimation.bone();
            if (bone == null) continue;
            this.activeBones.put(bone.getName(), bone);
            bone.setToInitialPose();
            AnimationPoint animationPoint = (AnimationPoint)boneAnimation.rotationXQueue().poll();
            AnimationPoint rotYPoint = (AnimationPoint)boneAnimation.rotationYQueue().poll();
            AnimationPoint rotZPoint = (AnimationPoint)boneAnimation.rotationZQueue().poll();
            AnimationPoint posXPoint = (AnimationPoint)boneAnimation.positionXQueue().poll();
            AnimationPoint posYPoint = (AnimationPoint)boneAnimation.positionYQueue().poll();
            AnimationPoint posZPoint = (AnimationPoint)boneAnimation.positionZQueue().poll();
            AnimationPoint scaleXPoint = (AnimationPoint)boneAnimation.scaleXQueue().poll();
            AnimationPoint scaleYPoint = (AnimationPoint)boneAnimation.scaleYQueue().poll();
            AnimationPoint scaleZPoint = (AnimationPoint)boneAnimation.scaleZQueue().poll();
            AnimationPoint bendPoint = (AnimationPoint)boneAnimation.bendQueue().poll();
            EasingType easingType = this.overrideEasingTypeFunction.apply(this);
            if (animationPoint != null) {
                bone.setRotX(EasingType.lerpWithOverride(this.molangRuntime, animationPoint, easingType));
                bone.setRotY(EasingType.lerpWithOverride(this.molangRuntime, rotYPoint, easingType));
                bone.setRotZ(EasingType.lerpWithOverride(this.molangRuntime, rotZPoint, easingType));
            }
            if (posXPoint != null) {
                bone.setPosX(EasingType.lerpWithOverride(this.molangRuntime, posXPoint, easingType));
                bone.setPosY(EasingType.lerpWithOverride(this.molangRuntime, posYPoint, easingType));
                bone.setPosZ(EasingType.lerpWithOverride(this.molangRuntime, posZPoint, easingType));
            }
            if (scaleXPoint != null) {
                bone.setScaleX(EasingType.lerpWithOverride(this.molangRuntime, scaleXPoint, easingType));
                bone.setScaleY(EasingType.lerpWithOverride(this.molangRuntime, scaleYPoint, easingType));
                bone.setScaleZ(EasingType.lerpWithOverride(this.molangRuntime, scaleZPoint, easingType));
            }
            if (bendPoint == null) continue;
            bone.setBend(EasingType.lerpWithOverride(this.molangRuntime, bendPoint, easingType));
        }
        if (this.currentAnimation == null) {
            return;
        }
        Map<String, String> parentsMap = this.currentAnimation.animation().parents();
        ArrayList<AdvancedPlayerAnimBone> bones1 = new ArrayList<AdvancedPlayerAnimBone>(this.bones.values());
        for (PlayerAnimBone playerAnimBone : this.pivotBones.values()) {
            if (parentsMap.containsValue(playerAnimBone.getName())) continue;
            bones1.add((AdvancedPlayerAnimBone)playerAnimBone);
        }
        for (PlayerAnimBone playerAnimBone : bones1) {
            if (!parentsMap.containsKey(playerAnimBone.getName())) continue;
            if (!this.boneAnimationQueues.containsKey(playerAnimBone.getName())) {
                playerAnimBone.setToInitialPose();
            }
            this.activeBones.put(playerAnimBone.getName(), playerAnimBone);
            ModMatrix4f matrix = new ModMatrix4f();
            ArrayList<PivotBone> parents = new ArrayList<PivotBone>();
            PivotBone currentParent = this.pivotBones.get(parentsMap.get(playerAnimBone.getName()));
            parents.add(currentParent);
            while (parentsMap.containsKey(currentParent.getName())) {
                currentParent = this.pivotBones.get(parentsMap.get(currentParent.getName()));
                parents.addFirst(currentParent);
            }
            for (PivotBone pivotBone : parents) {
                MatrixUtil.prepMatrixForBone(matrix, pivotBone, pivotBone.getPivot());
            }
            Vec3f defaultPos = this.getBonePosition(playerAnimBone.getName());
            ModVector4f pos = new ModVector4f(defaultPos.x(), defaultPos.y(), defaultPos.z(), 1.0f).mul(matrix);
            playerAnimBone.setPosX(-pos.x + defaultPos.x() + playerAnimBone.getPosX());
            playerAnimBone.setPosY(pos.y - defaultPos.y() + playerAnimBone.getPosY());
            playerAnimBone.setPosZ(-pos.z + defaultPos.z() + playerAnimBone.getPosZ());
            Vec3f rotation = matrix.getEulerRotation();
            playerAnimBone.addRot(rotation.x(), rotation.y(), rotation.z());
            playerAnimBone.mulScale(matrix.getColumnScale(0), matrix.getColumnScale(1), matrix.getColumnScale(2));
        }
    }

    public abstract Vec3f getBonePosition(String var1);

    public AnimationController addModifier(@NotNull AbstractModifier modifier, int idx) {
        modifier.setHost(this);
        this.modifiers.add(idx, modifier);
        this.linkModifiers();
        return this;
    }

    public AnimationController addModifierBefore(@NotNull AbstractModifier modifier) {
        this.addModifier(modifier, 0);
        return this;
    }

    public AnimationController addModifierLast(@NotNull AbstractModifier modifier) {
        this.addModifier(modifier, this.modifiers.size());
        return this;
    }

    public AnimationController removeModifier(int idx) {
        this.modifiers.remove(idx);
        this.linkModifiers();
        return this;
    }

    public AnimationController removeAllModifiers() {
        this.modifiers.clear();
        return this;
    }

    public int getModifierCount() {
        return this.modifiers.size();
    }

    @Nullable
    public AbstractModifier getModifier(int idx) {
        try {
            return this.modifiers.get(idx);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public boolean removeModifierIf(Predicate<? super AbstractModifier> predicate) {
        boolean success = this.modifiers.removeIf(predicate);
        this.linkModifiers();
        return success;
    }

    protected void linkModifiers() {
        Iterator<AbstractModifier> modifierIterator = this.modifiers.iterator();
        if (modifierIterator.hasNext()) {
            AbstractModifier tmp = modifierIterator.next();
            while (modifierIterator.hasNext()) {
                AbstractModifier tmp2 = modifierIterator.next();
                tmp.setAnim(tmp2);
                tmp = tmp2;
            }
            tmp.setAnim(this.internalAnimationAccessor);
        }
    }

    protected void registerPlayerAnimBone(String name) {
        this.registerPlayerAnimBone(new AdvancedPlayerAnimBone(name));
    }

    protected void registerPlayerAnimBone(AdvancedPlayerAnimBone bone) {
        this.bones.put(bone.getName(), bone);
    }

    private static class InternalAnimationAccessor
    extends AnimationContainer<AnimationController> {
        private InternalAnimationAccessor(AnimationController controller) {
            super(controller);
        }

        @Override
        public void tick(AnimationData state) {
            ((AnimationController)this.anim).internalSetupAnim(state);
        }

        @Override
        public void setupAnim(AnimationData state) {
            ((AnimationController)this.anim).internalSetupAnim(state);
        }

        @Override
        public PlayerAnimBone get3DTransform(@NotNull PlayerAnimBone bone) {
            return ((AnimationController)this.anim).get3DTransformRaw(bone);
        }
    }

    @FunctionalInterface
    public static interface AnimationStateHandler {
        public PlayState handle(AnimationController var1, AnimationData var2, AnimationSetter var3);
    }

    @FunctionalInterface
    public static interface AnimationSetter {
        default public PlayState setAnimation(RawAnimation animation) {
            return this.setAnimation(animation, 0);
        }

        public PlayState setAnimation(RawAnimation var1, int var2);
    }
}

