/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranim.lib.mochafloats.runtime.value;

import com.zigythebird.playeranim.lib.mochafloats.runtime.value.ArrayValue;
import com.zigythebird.playeranim.lib.mochafloats.runtime.value.Function;
import com.zigythebird.playeranim.lib.mochafloats.runtime.value.NumberValue;
import com.zigythebird.playeranim.lib.mochafloats.runtime.value.ObjectProperty;
import com.zigythebird.playeranim.lib.mochafloats.runtime.value.ObjectValue;
import com.zigythebird.playeranim.lib.mochafloats.runtime.value.StringValue;
import java.lang.reflect.Array;
import java.util.Map;
import java.util.StringJoiner;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public interface Value {
    @NotNull
    public static Value of(@Nullable Object any) {
        if (any instanceof Value) {
            return (Value)any;
        }
        if (any instanceof Number) {
            return NumberValue.of(((Number)any).floatValue());
        }
        if (any instanceof String) {
            return StringValue.of((String)any);
        }
        if (any instanceof Boolean) {
            return (Boolean)any != false ? NumberValue.one() : NumberValue.zero();
        }
        if (any != null && any.getClass().isArray()) {
            int length = Array.getLength(any);
            Value[] values = new Value[length];
            for (int i = 0; i < length; ++i) {
                values[i] = Value.of(Array.get(any, i));
            }
            return ArrayValue.of(values);
        }
        return NumberValue.zero();
    }

    @NotNull
    public static Value of(boolean bool) {
        return bool ? NumberValue.one() : NumberValue.zero();
    }

    @NotNull
    public static Value of(double _double) {
        return NumberValue.of(_double);
    }

    @NotNull
    public static Value of(float _float) {
        return NumberValue.of(_float);
    }

    @NotNull
    public static Value of(@Nullable String string) {
        return string == null ? Value.nil() : StringValue.of(string);
    }

    @NotNull
    public static Value nil() {
        return NumberValue.zero();
    }

    default public float getAsNumber() {
        if (this instanceof NumberValue) {
            return ((NumberValue)this).value();
        }
        return 0.0f;
    }

    default public boolean getAsBoolean() {
        if (this instanceof NumberValue) {
            return ((NumberValue)this).value() != 0.0f;
        }
        if (this instanceof StringValue) {
            return !((StringValue)this).value().isEmpty();
        }
        if (this instanceof ArrayValue) {
            return ((ArrayValue)this).values().length != 0;
        }
        if (this instanceof ObjectValue) {
            return !((ObjectValue)this).entries().isEmpty();
        }
        return true;
    }

    default public boolean isString() {
        return this instanceof StringValue;
    }

    @NotNull
    default public String getAsString() {
        if (this instanceof StringValue) {
            return ((StringValue)this).value();
        }
        if (this instanceof NumberValue) {
            return Float.toString(((NumberValue)this).value());
        }
        if (this instanceof ArrayValue) {
            Value[] values = ((ArrayValue)this).values();
            StringJoiner joiner = new StringJoiner(", ", "[", "]");
            for (Value value : values) {
                joiner.add(value.getAsString());
            }
            return joiner.toString();
        }
        if (this instanceof ObjectValue) {
            Map<String, ObjectProperty> values = ((ObjectValue)this).entries();
            StringJoiner joiner = new StringJoiner(", ", "{", "}");
            for (Map.Entry<String, ObjectProperty> entry : values.entrySet()) {
                joiner.add(entry.getKey() + ": " + entry.getValue().value().getAsString());
            }
            return joiner.toString();
        }
        if (this instanceof Function) {
            return "Function(" + this + ")";
        }
        throw new IllegalArgumentException("Unknown value type: " + this.getClass().getName());
    }
}

