/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranim.lib.mochafloats.runtime.binding;

import com.zigythebird.playeranim.lib.mochafloats.runtime.ExecutionContext;
import com.zigythebird.playeranim.lib.mochafloats.runtime.JavaTypes;
import com.zigythebird.playeranim.lib.mochafloats.runtime.binding.Entity;
import com.zigythebird.playeranim.lib.mochafloats.runtime.binding.Lazy;
import com.zigythebird.playeranim.lib.mochafloats.runtime.value.ArrayValue;
import com.zigythebird.playeranim.lib.mochafloats.runtime.value.Function;
import com.zigythebird.playeranim.lib.mochafloats.runtime.value.JavaValue;
import com.zigythebird.playeranim.lib.mochafloats.runtime.value.NumberValue;
import com.zigythebird.playeranim.lib.mochafloats.runtime.value.StringValue;
import com.zigythebird.playeranim.lib.mochafloats.runtime.value.Value;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ReflectiveFunction<T>
implements Function<T> {
    private final Object object;
    private final Method method;

    ReflectiveFunction(@Nullable Object object, @NotNull Method method) {
        this.object = object;
        this.method = Objects.requireNonNull(method, "method");
    }

    @NotNull
    static Value of(@Nullable Object any) {
        if (any instanceof Value) {
            return (Value)any;
        }
        if (any instanceof Number) {
            return NumberValue.of(((Number)any).floatValue());
        }
        if (any instanceof String) {
            return StringValue.of((String)any);
        }
        if (any instanceof Boolean) {
            return (Boolean)any != false ? NumberValue.one() : NumberValue.zero();
        }
        if (any != null && any.getClass().isArray()) {
            int length = Array.getLength(any);
            Value[] values = new Value[length];
            for (int i = 0; i < length; ++i) {
                values[i] = ReflectiveFunction.of(Array.get(any, i));
            }
            return ArrayValue.of(values);
        }
        if (any != null) {
            return new JavaValue(any);
        }
        return Value.nil();
    }

    @Override
    @NotNull
    public Value evaluate(@NotNull ExecutionContext<T> context, @NotNull Function.Arguments arguments) {
        Parameter[] parameters = this.method.getParameters();
        Type[] genericParameterTypes = this.method.getGenericParameterTypes();
        Object[] values = new Object[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            Value value;
            Function.Argument argument;
            Parameter parameter = parameters[i];
            Class parameterType = parameter.getType();
            if (i == parameters.length - 1 && this.method.isVarArgs()) {
                Class<?> componentType = parameterType.getComponentType();
                ArrayList<Value> varArgsValues = new ArrayList<Value>();
                while ((argument = arguments.next()).expression() != null) {
                    Value object = argument.eval();
                    if (componentType.isInstance(object)) {
                        varArgsValues.add(object);
                        continue;
                    }
                    varArgsValues.add(null);
                }
                value = ArrayValue.of((Value[])varArgsValues.toArray(size -> (Value[])Array.newInstance(componentType, size)));
            } else if (parameterType == Lazy.class) {
                Type genericParameterType = genericParameterTypes[i];
                if (!(genericParameterType instanceof ParameterizedType)) {
                    throw new IllegalArgumentException("Lazy<T> parameter must be a parameterized type.");
                }
                parameterType = (Class)((ParameterizedType)genericParameterType).getActualTypeArguments()[0];
                if (parameterType == ExecutionContext.class) {
                    value = new JavaValue(() -> context);
                } else {
                    Class argumentType = parameterType;
                    argument = arguments.next();
                    value = new JavaValue(() -> {
                        Value object = argument.eval();
                        if (argumentType.isInstance(object)) {
                            return object;
                        }
                        return null;
                    });
                }
            } else if (parameterType == ExecutionContext.class) {
                value = new JavaValue(context);
            } else if (parameter.isAnnotationPresent(Entity.class)) {
                value = new JavaValue(context.entity());
            } else {
                Function.Argument argument2 = arguments.next();
                value = argument2.eval();
            }
            values[i] = value == null ? JavaTypes.getNullValueForType(parameterType) : (parameter.isAnnotationPresent(Entity.class) ? ((JavaValue)value).value() : JavaTypes.convert(value, parameterType));
        }
        try {
            return ReflectiveFunction.of(this.method.invoke(this.object, values));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

