/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranim.lib.mochafloats.lexer;

import com.zigythebird.playeranim.lib.mochafloats.lexer.TokenKind;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

public final class Token {
    private final TokenKind kind;
    @Nullable
    private final String value;
    private final int start;
    private final int end;

    public Token(@NotNull TokenKind kind, @Nullable String value, int start, int end) {
        this.kind = Objects.requireNonNull(kind, "kind");
        this.value = value;
        this.start = start;
        this.end = end;
        if (kind.hasTag(TokenKind.Tag.HAS_VALUE) && value == null) {
            throw new IllegalArgumentException("A token with kind " + (Object)((Object)kind) + " must have a non-null value");
        }
    }

    @NotNull
    public TokenKind kind() {
        return this.kind;
    }

    public @UnknownNullability String value() {
        return this.value;
    }

    public int start() {
        return this.start;
    }

    public int end() {
        return this.end;
    }

    public String toString() {
        if (this.kind.hasTag(TokenKind.Tag.HAS_VALUE)) {
            return (Object)((Object)this.kind) + "(" + this.value + ")";
        }
        return this.kind.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Token token = (Token)o;
        if (this.start != token.start) {
            return false;
        }
        if (this.end != token.end) {
            return false;
        }
        if (this.kind != token.kind) {
            return false;
        }
        return Objects.equals(this.value, token.value);
    }

    public int hashCode() {
        int result = this.kind.hashCode();
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + this.start;
        result = 31 * result + this.end;
        return result;
    }
}

