/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranim.animation;

import com.zigythebird.playeranim.animation.PlayerAnimationData;
import com.zigythebird.playeranim.util.RenderUtil;
import com.zigythebird.playeranimcore.animation.AnimationController;
import com.zigythebird.playeranimcore.animation.AnimationData;
import com.zigythebird.playeranimcore.animation.AnimationProcessor;
import com.zigythebird.playeranimcore.animation.RawAnimation;
import com.zigythebird.playeranimcore.bones.PivotBone;
import com.zigythebird.playeranimcore.bones.PlayerAnimBone;
import com.zigythebird.playeranimcore.math.Vec3f;
import java.util.Map;
import java.util.Queue;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_742;
import net.minecraft.class_7833;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class PlayerAnimationController
extends AnimationController {
    public static final Map<String, Vec3f> BONE_POSITIONS = Map.of("right_arm", new Vec3f(5.0f, 22.0f, 0.0f), "left_arm", new Vec3f(-5.0f, 22.0f, 0.0f), "left_leg", new Vec3f(-2.0f, 12.0f, 0.0f), "right_leg", new Vec3f(2.0f, 12.0f, 0.0f), "torso", new Vec3f(0.0f, 24.0f, 0.0f), "head", new Vec3f(0.0f, 24.0f, 0.0f), "body", new Vec3f(0.0f, 12.0f, 0.0f));
    protected final class_742 player;

    public PlayerAnimationController(class_742 player, AnimationController.AnimationStateHandler animationHandler) {
        super(animationHandler);
        this.player = player;
    }

    public class_742 getPlayer() {
        return this.player;
    }

    @Nullable
    public class_4587 getBoneWorldPositionPoseStack(String name, float tickDelta, class_243 cameraPos) {
        if (!this.activeBones.containsKey(name)) {
            return null;
        }
        class_4587 poseStack = new class_4587();
        Vec3f pivot = this.getBonePosition(name);
        class_243 position = this.player.method_30950(tickDelta).method_1020(cameraPos).method_1031((double)pivot.x(), (double)pivot.y(), (double)pivot.z());
        poseStack.method_22904(position.method_10216(), position.method_10214(), position.method_10215());
        poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(180.0f - class_3532.method_16439((float)tickDelta, (float)this.player.field_6220, (float)this.player.field_6283)));
        RenderUtil.translateMatrixToBone(poseStack, (PlayerAnimBone)this.activeBones.get(name));
        return poseStack;
    }

    @Override
    public void registerBones() {
        this.registerPlayerAnimBone("body");
        this.registerPlayerAnimBone("right_arm");
        this.registerPlayerAnimBone("left_arm");
        this.registerPlayerAnimBone("right_leg");
        this.registerPlayerAnimBone("left_leg");
        this.registerPlayerAnimBone("head");
        this.registerPlayerAnimBone("torso");
        this.registerPlayerAnimBone("right_item");
        this.registerPlayerAnimBone("left_item");
        this.registerPlayerAnimBone("cape");
        this.registerPlayerAnimBone("elytra");
    }

    @Override
    protected Queue<AnimationProcessor.QueuedAnimation> getQueuedAnimations(RawAnimation rawAnimation) {
        if (this.player == null) {
            return null;
        }
        return this.player.playerAnimLib$getAnimProcessor().buildAnimationQueue(rawAnimation);
    }

    @Override
    protected void internalSetupAnim(AnimationData state) {
        if (state instanceof PlayerAnimationData) {
            PlayerAnimationData playerAnimationData = (PlayerAnimationData)state;
            this.isJustStarting = playerAnimationData.getPlayerAnimManager().isFirstTick();
            this.process(state, playerAnimationData.getPlayer().playerAnimLib$getAnimProcessor().animTime);
        }
        super.internalSetupAnim(state);
    }

    @Override
    public Vec3f getBonePosition(String name) {
        if (BONE_POSITIONS.containsKey(name)) {
            return BONE_POSITIONS.get(name);
        }
        if (this.pivotBones.containsKey(name)) {
            return ((PivotBone)this.pivotBones.get(name)).getPivot();
        }
        return Vec3f.ZERO;
    }
}

