/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.mtd.yacl.category;

import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.utils.OptionUtils;
import net.lopymine.mtd.config.MyTotemDollConfig;
import net.lopymine.mtd.config.rendering.HandRenderingConfig;
import net.lopymine.mtd.config.rendering.RenderingConfig;
import net.lopymine.mtd.extension.SimpleOptionExtension;
import net.lopymine.mtd.yacl.custom.simple.custom.SimpleRenderingCategory;
import net.lopymine.mtd.yacl.custom.simple.main.SimpleGroup;
import net.lopymine.mtd.yacl.custom.simple.main.SimpleOption;

public class RenderingCategory {
    public static ConfigCategory get(MyTotemDollConfig defConfig, MyTotemDollConfig config) {
        return SimpleRenderingCategory.startBuilder().groups(RenderingCategory.getRenderingRightHandGroup(defConfig, config), RenderingCategory.getRenderingLeftHandGroup(defConfig, config)).build();
    }

    private static OptionGroup getRenderingRightHandGroup(MyTotemDollConfig defConfig, MyTotemDollConfig config) {
        return RenderingCategory.getRenderingHandGroup(HandGroup.RIGHT_HAND, defConfig, config);
    }

    private static OptionGroup getRenderingLeftHandGroup(MyTotemDollConfig defConfig, MyTotemDollConfig config) {
        return RenderingCategory.getRenderingHandGroup(HandGroup.LEFT_HAND, defConfig, config);
    }

    private static OptionGroup getRenderingHandGroup(HandGroup handGroup, MyTotemDollConfig defConfig, MyTotemDollConfig config) {
        RenderingConfig defRenderingConfig = defConfig.getRenderingConfig();
        RenderingConfig renderingConfig = config.getRenderingConfig();
        HandRenderingConfig defHandConfig = handGroup.right() ? defRenderingConfig.getRightHandConfig() : defRenderingConfig.getLeftHandConfig();
        HandRenderingConfig handConfig = handGroup.right() ? renderingConfig.getRightHandConfig() : renderingConfig.getLeftHandConfig();
        Option[] optionArray = new Option[8];
        optionArray[0] = SimpleOptionExtension.withController(SimpleOption.startBuilder("scale"), 0.0, 2.0, 0.01).withBinding(defHandConfig.getScale(), handConfig::getScale, handConfig::setScale, true).build();
        optionArray[1] = SimpleOptionExtension.withController(SimpleOption.startBuilder("rotation_x"), -180.0, 180.0, 0.01).withBinding(defHandConfig.getRotationX(), handConfig::getRotationX, handConfig::setRotationX, true).build();
        optionArray[2] = SimpleOptionExtension.withController(SimpleOption.startBuilder("rotation_y"), -180.0, 180.0, 0.01).withBinding(defHandConfig.getRotationY(), handConfig::getRotationY, handConfig::setRotationY, true).build();
        optionArray[3] = SimpleOptionExtension.withController(SimpleOption.startBuilder("rotation_z"), -180.0, 180.0, 0.01).withBinding(defHandConfig.getRotationZ(), handConfig::getRotationZ, handConfig::setRotationZ, true).build();
        optionArray[4] = SimpleOptionExtension.withController(SimpleOption.startBuilder("offset_x"), -500.0, 500.0, 0.01).withBinding(defHandConfig.getOffsetX(), handConfig::getOffsetX, handConfig::setOffsetX, true).build();
        optionArray[5] = SimpleOptionExtension.withController(SimpleOption.startBuilder("offset_y"), -500.0, 500.0, 0.01).withBinding(defHandConfig.getOffsetY(), handConfig::getOffsetY, handConfig::setOffsetY, true).build();
        optionArray[6] = SimpleOptionExtension.withController(SimpleOption.startBuilder("offset_z"), -500.0, 500.0, 0.01).withBinding(defHandConfig.getOffsetZ(), handConfig::getOffsetZ, handConfig::setOffsetZ, true).build();
        optionArray[7] = SimpleOption.startButtonBuilder(handGroup.right() ? "copy_left_hand_settings" : "copy_right_hand_settings", (yaclScreen, buttonOption) -> {
            HandRenderingConfig leftHandConfig = renderingConfig.getLeftHandConfig();
            HandRenderingConfig rightHandConfig = renderingConfig.getRightHandConfig();
            if (handGroup.right()) {
                rightHandConfig.copy(leftHandConfig);
            } else {
                leftHandConfig.copy(rightHandConfig);
            }
            OptionUtils.forEachOptions((YetAnotherConfigLib)yaclScreen.config, Option::forgetPendingValue);
        }).build();
        return SimpleGroup.startBuilder(handGroup.getGroupId()).options(optionArray).build();
    }

    private static enum HandGroup {
        LEFT_HAND("left_hand"),
        RIGHT_HAND("right_hand");

        private final String groupId;

        private HandGroup(String groupId) {
            this.groupId = groupId;
        }

        public boolean right() {
            return this == RIGHT_HAND;
        }

        public String getGroupId() {
            return this.groupId;
        }
    }
}

