/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.mtd.model.bb;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.UUID;
import net.lopymine.mtd.config.other.vector.Vec3f;
import net.lopymine.mtd.utils.CodecUtils;
import net.minecraft.class_4844;
import net.minecraft.class_5603;

public class BBGroup {
    public static final Codec<BBGroup> CODEC = CodecUtils.recursive("BBGroup.Codec", codec -> RecordCodecBuilder.create(inst -> inst.group(CodecUtils.option("name", Codec.STRING, BBGroup::getName), CodecUtils.option("origin", Vec3f.CODEC, BBGroup::getOrigin), CodecUtils.option("rotation", new Vec3f(), Vec3f.CODEC, BBGroup::getRotation), CodecUtils.option("autouv", Codec.INT, BBGroup::getAutoUV), CodecUtils.option("visibility", true, Codec.BOOL, BBGroup::isVisible), CodecUtils.option("uuid", class_4844.field_40825, BBGroup::getUuid), CodecUtils.option("children", Codec.either((Codec)codec, (Codec)class_4844.field_40825).listOf(), BBGroup::getChildren)).apply((Applicative)inst, BBGroup::new)));
    private String name;
    private Vec3f origin;
    private Vec3f rotation;
    private int autoUV;
    private boolean visible;
    private UUID uuid;
    private List<Either<BBGroup, UUID>> children;

    public class_5603 getTransformation() {
        return class_5603.method_32091((float)this.origin.x(), (float)this.origin.y(), (float)this.origin.z(), (float)((float)(-Math.toRadians(this.rotation.x()))), (float)((float)(-Math.toRadians(this.rotation.y()))), (float)((float)Math.toRadians(this.rotation.z())));
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOrigin(Vec3f origin) {
        this.origin = origin;
    }

    public void setRotation(Vec3f rotation) {
        this.rotation = rotation;
    }

    public void setAutoUV(int autoUV) {
        this.autoUV = autoUV;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public void setChildren(List<Either<BBGroup, UUID>> children) {
        this.children = children;
    }

    public String getName() {
        return this.name;
    }

    public Vec3f getOrigin() {
        return this.origin;
    }

    public Vec3f getRotation() {
        return this.rotation;
    }

    public int getAutoUV() {
        return this.autoUV;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public List<Either<BBGroup, UUID>> getChildren() {
        return this.children;
    }

    public BBGroup(String name, Vec3f origin, Vec3f rotation, int autoUV, boolean visible, UUID uuid, List<Either<BBGroup, UUID>> children) {
        this.name = name;
        this.origin = origin;
        this.rotation = rotation;
        this.autoUV = autoUV;
        this.visible = visible;
        this.uuid = uuid;
        this.children = children;
    }
}

