/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.mtd.model.bb;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.lopymine.mtd.config.other.vector.Vec3f;
import net.lopymine.mtd.extension.DilationExtension;
import net.lopymine.mtd.utils.CodecUtils;
import net.minecraft.class_156;
import net.minecraft.class_2350;
import net.minecraft.class_4844;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import org.jetbrains.annotations.NotNull;

public class BBCube {
    public static Codec<class_5605> DILATION_CODEC = Codec.FLOAT.xmap(class_5605::new, dilation -> Float.valueOf(DilationExtension.getRadiusX(dilation)));
    public static final Codec<BBCube> CODEC = RecordCodecBuilder.create(inst -> inst.group(CodecUtils.option("name", Codec.STRING, BBCube::getName), CodecUtils.option("from", Vec3f.CODEC, BBCube::getFrom), CodecUtils.option("to", Vec3f.CODEC, BBCube::getTo), CodecUtils.option("origin", Vec3f.CODEC, BBCube::getOrigin), CodecUtils.option("rotation", new Vec3f(), Vec3f.CODEC, BBCube::getRotation), CodecUtils.option("inflate", class_5605.field_27715, DILATION_CODEC, BBCube::getInflate), CodecUtils.option("autouv", Codec.INT, BBCube::getAutoUV), CodecUtils.option("faces", BBCubeFaces.CODEC, BBCube::getFaces), CodecUtils.option("uuid", class_4844.field_40825, BBCube::getUuid), CodecUtils.option("visibility", true, Codec.BOOL, BBCube::isVisible)).apply((Applicative)inst, BBCube::new));
    private String name;
    private Vec3f from;
    private Vec3f to;
    private Vec3f origin;
    private Vec3f rotation;
    private class_5605 inflate;
    private int autoUV;
    private BBCubeFaces faces;
    private UUID uuid;
    private boolean visible;

    public class_5603 getTransformation() {
        return class_5603.method_32091((float)this.origin.x(), (float)this.origin.y(), (float)this.origin.z(), (float)((float)(-Math.toRadians(this.rotation.x()))), (float)((float)(-Math.toRadians(this.rotation.y()))), (float)((float)Math.toRadians(this.rotation.z())));
    }

    public String getName() {
        return this.name;
    }

    public Vec3f getFrom() {
        return this.from;
    }

    public Vec3f getTo() {
        return this.to;
    }

    public Vec3f getOrigin() {
        return this.origin;
    }

    public Vec3f getRotation() {
        return this.rotation;
    }

    public class_5605 getInflate() {
        return this.inflate;
    }

    public int getAutoUV() {
        return this.autoUV;
    }

    public BBCubeFaces getFaces() {
        return this.faces;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFrom(Vec3f from) {
        this.from = from;
    }

    public void setTo(Vec3f to) {
        this.to = to;
    }

    public void setOrigin(Vec3f origin) {
        this.origin = origin;
    }

    public void setRotation(Vec3f rotation) {
        this.rotation = rotation;
    }

    public void setInflate(class_5605 inflate) {
        this.inflate = inflate;
    }

    public void setAutoUV(int autoUV) {
        this.autoUV = autoUV;
    }

    public void setFaces(BBCubeFaces faces) {
        this.faces = faces;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public BBCube(String name, Vec3f from, Vec3f to, Vec3f origin, Vec3f rotation, class_5605 inflate, int autoUV, BBCubeFaces faces, UUID uuid, boolean visible) {
        this.name = name;
        this.from = from;
        this.to = to;
        this.origin = origin;
        this.rotation = rotation;
        this.inflate = inflate;
        this.autoUV = autoUV;
        this.faces = faces;
        this.uuid = uuid;
        this.visible = visible;
    }

    public static class BBCubeFaces {
        public static final Codec<BBCubeFaces> CODEC = RecordCodecBuilder.create(inst -> inst.group(CodecUtils.option("up", BBCubeFace.CODEC, BBCubeFaces::getUp), CodecUtils.option("down", BBCubeFace.CODEC, BBCubeFaces::getDown), CodecUtils.option("north", BBCubeFace.CODEC, BBCubeFaces::getNorth), CodecUtils.option("south", BBCubeFace.CODEC, BBCubeFaces::getSouth), CodecUtils.option("east", BBCubeFace.CODEC, BBCubeFaces::getEast), CodecUtils.option("west", BBCubeFace.CODEC, BBCubeFaces::getWest)).apply((Applicative)inst, BBCubeFaces::new));
        private BBCubeFace up;
        private BBCubeFace down;
        private BBCubeFace north;
        private BBCubeFace south;
        private BBCubeFace east;
        private BBCubeFace west;

        @NotNull
        public Map<class_2350, BBCubeFace> map() {
            return Map.ofEntries(Map.entry(class_2350.field_11036, this.up), Map.entry(class_2350.field_11033, this.down), Map.entry(class_2350.field_11034, this.east), Map.entry(class_2350.field_11039, this.west), Map.entry(class_2350.field_11035, this.south), Map.entry(class_2350.field_11043, this.north));
        }

        public BBCubeFace getUp() {
            return this.up;
        }

        public BBCubeFace getDown() {
            return this.down;
        }

        public BBCubeFace getNorth() {
            return this.north;
        }

        public BBCubeFace getSouth() {
            return this.south;
        }

        public BBCubeFace getEast() {
            return this.east;
        }

        public BBCubeFace getWest() {
            return this.west;
        }

        public void setUp(BBCubeFace up) {
            this.up = up;
        }

        public void setDown(BBCubeFace down) {
            this.down = down;
        }

        public void setNorth(BBCubeFace north) {
            this.north = north;
        }

        public void setSouth(BBCubeFace south) {
            this.south = south;
        }

        public void setEast(BBCubeFace east) {
            this.east = east;
        }

        public void setWest(BBCubeFace west) {
            this.west = west;
        }

        public BBCubeFaces(BBCubeFace up, BBCubeFace down, BBCubeFace north, BBCubeFace south, BBCubeFace east, BBCubeFace west) {
            this.up = up;
            this.down = down;
            this.north = north;
            this.south = south;
            this.east = east;
            this.west = west;
        }
    }

    public static class UV {
        public static final Codec<UV> CODEC = Codec.FLOAT.listOf().comapFlatMap(coordinates -> class_156.method_33141((List)coordinates, (int)4).map(list -> new UV(((Float)list.get(0)).floatValue(), ((Float)list.get(1)).floatValue(), ((Float)list.get(2)).floatValue(), ((Float)list.get(3)).floatValue())), vec -> List.of(Float.valueOf(vec.getFromU()), Float.valueOf(vec.getFromV()), Float.valueOf(vec.getToU()), Float.valueOf(vec.getToV())));
        private float fromU;
        private float fromV;
        private float toU;
        private float toV;

        public boolean isDummy() {
            return this.fromU == this.toU && this.fromV == this.toV;
        }

        public float getFromU() {
            return this.fromU;
        }

        public float getFromV() {
            return this.fromV;
        }

        public float getToU() {
            return this.toU;
        }

        public float getToV() {
            return this.toV;
        }

        public void setFromU(float fromU) {
            this.fromU = fromU;
        }

        public void setFromV(float fromV) {
            this.fromV = fromV;
        }

        public void setToU(float toU) {
            this.toU = toU;
        }

        public void setToV(float toV) {
            this.toV = toV;
        }

        public UV(float fromU, float fromV, float toU, float toV) {
            this.fromU = fromU;
            this.fromV = fromV;
            this.toU = toU;
            this.toV = toV;
        }
    }

    public static class BBCubeFace {
        public static final Codec<BBCubeFace> CODEC = RecordCodecBuilder.create(inst -> inst.group(CodecUtils.option("uv", UV.CODEC, BBCubeFace::getUv), CodecUtils.option("rotation", 0, Codec.INT, BBCubeFace::getRotation)).apply((Applicative)inst, BBCubeFace::new));
        private UV uv;
        private int rotation;

        public UV getUv() {
            return this.uv;
        }

        public int getRotation() {
            return this.rotation;
        }

        public void setUv(UV uv) {
            this.uv = uv;
        }

        public void setRotation(int rotation) {
            this.rotation = rotation;
        }

        public BBCubeFace(UV uv, int rotation) {
            this.uv = uv;
            this.rotation = rotation;
        }
    }
}

